--       _________ __                 __
--      /   _____//  |_____________ _/  |______     ____  __ __  ______
--      \_____  \\   __\_  __ \__  \\   __\__  \   / ___\|  |  \/  ___/
--      /        \|  |  |  | \// __ \|  |  / __ \_/ /_/  >  |  /\___ \ 
--     /_______  /|__|  |__|  (____  /__| (____  /\___  /|____//____  >
--             \/                  \/          \//_____/            \/ 
--  ______________________                           ______________________
--                        T H E   W A R   B E G I N S
--         Stratagus - A free fantasy real time strategy game engine
--
--      scripts.lua - The craft configuration language.
--
--      (c) Copyright 2005 by Jimmy Salmon
--
--      This program is free software; you can redistribute it and/or modify
--      it under the terms of the GNU General Public License as published by
--      the Free Software Foundation; either version 2 of the License, or
--      (at your option) any later version.
--  
--      This program is distributed in the hope that it will be useful,
--      but WITHOUT ANY WARRANTY; without even the implied warranty of
--      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--      GNU General Public License for more details.
--  
--      You should have received a copy of the GNU General Public License
--      along with this program; if not, write to the Free Software
--      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
--
--      $Id: scripts.lua 1486 2007-01-14 19:38:00Z jsalmon3 $


-- Set the unit type graphics to the correct tileset
table.foreach(UnitTypeFiles,
	function(k, v) DefineUnitType(k, {Image = {"file", v[tileset]}}) end)


-- Fix critters sounds and name
local CritterNames = {
  summer = "Pig", winter = "Seal", wasteland = "Pig", swamp = "Warthog",
}

local CritterSounds = {
  summer = "sheep-selected", winter = "seal-selected",
  wasteland = "pig-selected", swamp = "warthog-selected",
}

DefineUnitType("unit-critter", {
  Name = CritterNames[tileset]
})

MapSound("critter-selected", CritterSounds[tileset])


-- Icon and construction graphics also depend on the tileset

Load("scripts/icons.lua")
Load("scripts/constructions.lua")

if (GetPlayerData(GetThisPlayer(), "RaceName") == "human") then
	Load("scripts/human/ui.lua")
elseif (GetPlayerData(GetThisPlayer(), "RaceName") == "orc") then
	Load("scripts/orc/ui.lua")
end
