/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.httpclient;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ChunkedInputStream
extends FilterInputStream {
    byte[] chunk = null;
    int start = 0;
    int size = 0;
    String[][] _trailer = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public ChunkedInputStream(InputStream in) throws IOException {
        super(in);
        this.readChunk();
    }

    public String[][] getTrailer() {
        return this._trailer;
    }

    private void readChunk() throws IOException {
        String line = this.readLine().trim();
        try {
            this.size = Integer.parseInt(line.trim(), 16);
            this._logger.finest("Expecting a chunk of " + this.size + " bytes");
            this.chunk = new byte[this.size];
            int read = 0;
            while (read < this.size) {
                int got = this.in.read(this.chunk, read, Math.min(1024, this.size - read));
                this._logger.finest("read " + got + " bytes");
                if (got > 0) {
                    read += got;
                    continue;
                }
                if (read == 0) {
                    this._logger.info("read 0 bytes from the input stream! Huh!?");
                    continue;
                }
                this._logger.info("No more bytes to read from the stream, read " + read + " of " + this.size);
            }
            this._logger.finest("Got " + this.size + " bytes");
            if (this.size == 0) {
                this.readTrailer();
            } else {
                this.readLine();
            }
            this.start = 0;
        }
        catch (NumberFormatException nfe) {
            this._logger.severe("Error parsing chunk size from '" + line + "' : " + nfe);
        }
    }

    public int read() throws IOException {
        if (this.size == 0) {
            return -1;
        }
        if (this.start == this.size) {
            this.readChunk();
        }
        if (this.size == 0) {
            return -1;
        }
        return this.chunk[this.start++];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.size == 0) {
            return -1;
        }
        if (this.start == this.size) {
            this.readChunk();
        }
        if (this.size == 0) {
            return -1;
        }
        if (len - off >= this.available()) {
            len = this.available();
        }
        System.arraycopy(this.chunk, this.start, b, off, len);
        this.start += len;
        return len;
    }

    public int available() throws IOException {
        return this.size - this.start;
    }

    public boolean markSupported() {
        return false;
    }

    private String readLine() throws IOException {
        String line = new String();
        byte[] b = new byte[]{0};
        int i = this.in.read();
        while (i > -1 && i != 10 && i != 13) {
            b[0] = (byte)(i & 0xFF);
            String input = new String(b, 0, 1);
            line = line.concat(input);
            i = this.in.read();
        }
        if (i == 13) {
            i = this.in.read();
        }
        this._logger.finest("Read '" + line + "'");
        return line;
    }

    private void readTrailer() throws IOException {
        String line = this.readLine();
        ArrayList<String[]> trailer = new ArrayList<String[]>();
        while (!line.equals("")) {
            String[] pair = line.split(": *", 2);
            if (pair.length == 2) {
                trailer.add(pair);
            }
            line = this.readLine();
        }
        if (trailer.size() > 0) {
            this._trailer = new String[trailer.size()][2];
            for (int i = 0; i < trailer.size(); ++i) {
                String[] pair = (String[])trailer.get(i);
                this._trailer[i][0] = pair[0];
                this._trailer[i][1] = pair[1];
            }
        }
    }
}

