/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.util.Date;
import java.util.logging.Logger;
import org.owasp.webscarab.model.HttpUrl;

public class Cookie {
    private Date _date = null;
    private String _name = null;
    private String _value = null;
    private String _key = null;
    private String _comment = null;
    private String _domain = null;
    private String _path = null;
    private String _maxage = null;
    private boolean _secure = false;
    private String _version = null;
    private boolean _httponly = false;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Cookie(Date date, HttpUrl url, String setHeader) {
        this._date = date;
        this._domain = url.getHost();
        this._path = url.getPath();
        int index = this._path.lastIndexOf("/");
        this._path = index > 0 ? this._path.substring(0, index) : "/";
        this.parseHeader(setHeader);
        this._key = this._domain + this._path + " " + this._name;
    }

    public Cookie(Date date, String setHeader) {
        this._date = date;
        this.parseHeader(setHeader);
        this._key = this._domain + this._path + " " + this._name;
    }

    private void parseHeader(String setHeader) {
        if (setHeader == null) {
            throw new NullPointerException("You may not pass a null value for setHeader");
        }
        String[] parts = setHeader.split(" *; *");
        if (parts.length < 1) {
            throw new IllegalArgumentException("The setHeader must have at least one part to it!");
        }
        String[] av = parts[0].split("=", 2);
        if (av.length != 2) {
            throw new IllegalArgumentException("The header passed in must at least contain the name and value '" + parts[0] + "'");
        }
        this._name = av[0];
        this._value = av[1];
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i].equalsIgnoreCase("secure")) {
                this._secure = true;
                continue;
            }
            if (parts[i].equalsIgnoreCase("httponly")) {
                this._httponly = true;
                continue;
            }
            av = parts[i].split("=", 2);
            if (av.length != 2) {
                this._logger.warning("Unknown cookie attribute '" + parts[i] + "'");
                continue;
            }
            if (av[0].equalsIgnoreCase("Comment")) {
                this._comment = av[1];
                continue;
            }
            if (av[0].equalsIgnoreCase("Domain")) {
                this._domain = av[1];
                continue;
            }
            if (av[0].equalsIgnoreCase("Path")) {
                this._path = av[1];
                continue;
            }
            if (av[0].equalsIgnoreCase("Max-Age")) {
                this._maxage = av[1];
                continue;
            }
            if (!av[0].equalsIgnoreCase("Version")) continue;
            this._version = av[1];
        }
    }

    public String getKey() {
        return this._key;
    }

    public Date getDate() {
        return this._date;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    public String getDomain() {
        return this._domain;
    }

    public String getMaxAge() {
        return this._maxage;
    }

    public String getPath() {
        return this._path;
    }

    public boolean getSecure() {
        return this._secure;
    }

    public boolean getHTTPOnly() {
        return this._httponly;
    }

    public String getVersion() {
        return this._version;
    }

    public String getComment() {
        return this._comment;
    }

    public String setCookie() {
        StringBuffer buf = new StringBuffer();
        buf.append(this._name + "=" + this._value);
        if (this._comment != null) {
            buf.append("; Comment=" + this._comment);
        }
        if (this._domain != null) {
            buf.append("; Domain=" + this._domain);
        }
        if (this._maxage != null) {
            buf.append("; Max-Age=" + this._maxage);
        }
        if (this._path != null) {
            buf.append("; Path=" + this._path);
        }
        if (this._secure) {
            buf.append("; Secure");
        }
        if (this._httponly) {
            buf.append("; httponly");
        }
        if (this._version != null) {
            buf.append("; Version=" + this._version);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._date.getTime()).append(" ");
        buff.append(this.setCookie());
        return buff.toString();
    }
}

