/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.ConversationEvent;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationListener;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.util.ReentrantReaderPreferenceReadWriteLock;

public abstract class FilteredConversationModel
extends AbstractConversationModel {
    private ConversationModel _model;
    private ReentrantReaderPreferenceReadWriteLock _rwl = new ReentrantReaderPreferenceReadWriteLock();
    private List _conversations = new ArrayList();

    public FilteredConversationModel(FrameworkModel model, ConversationModel cmodel) {
        super(model);
        this._model = cmodel;
        this._model.addConversationListener(new Listener());
        this.updateConversations();
    }

    protected void updateConversations() {
        try {
            this._rwl.writeLock().acquire();
            this._conversations.clear();
            int count = this._model.getConversationCount();
            for (int i = 0; i < count; ++i) {
                ConversationID id = this._model.getConversationAt(i);
                if (this.shouldFilter(id)) continue;
                this._conversations.add(id);
            }
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this.fireConversationsChanged();
            this._rwl.readLock().release();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public abstract boolean shouldFilter(ConversationID var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isFiltered(ConversationID id) {
        try {
            this._rwl.readLock().acquire();
            boolean bl = this._conversations.indexOf(id) == -1;
            return bl;
        }
        catch (InterruptedException ie) {
            boolean bl = false;
            return bl;
        }
        finally {
            this._rwl.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationID getConversationAt(int index) {
        try {
            this._rwl.readLock().acquire();
            ConversationID conversationID = (ConversationID)this._conversations.get(index);
            return conversationID;
        }
        catch (InterruptedException ie) {
            ConversationID conversationID = null;
            return conversationID;
        }
        finally {
            this._rwl.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConversationCount() {
        try {
            this._rwl.readLock().acquire();
            int n = this._conversations.size();
            return n;
        }
        catch (InterruptedException ie) {
            int n = 0;
            return n;
        }
        finally {
            this._rwl.readLock().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfConversation(ConversationID id) {
        try {
            this._rwl.readLock().acquire();
            int n = Collections.binarySearch(this._conversations, id);
            return n;
        }
        catch (InterruptedException ie) {
            int n = -1;
            return n;
        }
        finally {
            this._rwl.readLock().release();
        }
    }

    public Sync readLock() {
        return this._rwl.readLock();
    }

    private class Listener
    implements ConversationListener {
        private Listener() {
        }

        public void conversationAdded(ConversationEvent evt) {
            ConversationID id = evt.getConversationID();
            if (!FilteredConversationModel.this.shouldFilter(id)) {
                try {
                    FilteredConversationModel.this._rwl.writeLock().acquire();
                    int index = FilteredConversationModel.this.getIndexOfConversation(id);
                    if (index < 0) {
                        index = -index - 1;
                        FilteredConversationModel.this._conversations.add(index, id);
                    }
                    FilteredConversationModel.this._rwl.readLock().acquire();
                    FilteredConversationModel.this._rwl.writeLock().release();
                    FilteredConversationModel.this.fireConversationAdded(id, index);
                    FilteredConversationModel.this._rwl.readLock().release();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public void conversationChanged(ConversationEvent evt) {
            ConversationID id = evt.getConversationID();
            int index = FilteredConversationModel.this.getIndexOfConversation(id);
            if (FilteredConversationModel.this.shouldFilter(id)) {
                if (index > -1) {
                    try {
                        FilteredConversationModel.this._rwl.writeLock().acquire();
                        FilteredConversationModel.this._conversations.remove(index);
                        FilteredConversationModel.this._rwl.readLock().acquire();
                        FilteredConversationModel.this._rwl.writeLock().release();
                        FilteredConversationModel.this.fireConversationRemoved(id, index);
                        FilteredConversationModel.this._rwl.readLock().release();
                    }
                    catch (InterruptedException ie) {}
                }
            } else if (index < 0) {
                index = -index - 1;
                try {
                    FilteredConversationModel.this._rwl.writeLock().acquire();
                    FilteredConversationModel.this._conversations.add(index, id);
                    FilteredConversationModel.this._rwl.readLock().acquire();
                    FilteredConversationModel.this._rwl.writeLock().release();
                    FilteredConversationModel.this.fireConversationAdded(id, index);
                    FilteredConversationModel.this._rwl.readLock().release();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        public void conversationRemoved(ConversationEvent evt) {
            ConversationID id = evt.getConversationID();
            int index = FilteredConversationModel.this.getIndexOfConversation(id);
            if (index > -1) {
                try {
                    FilteredConversationModel.this._rwl.writeLock().acquire();
                    FilteredConversationModel.this._conversations.remove(index);
                    FilteredConversationModel.this._rwl.readLock().acquire();
                    FilteredConversationModel.this._rwl.writeLock().release();
                    FilteredConversationModel.this.fireConversationRemoved(id, index);
                    FilteredConversationModel.this._rwl.readLock().release();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        public void conversationsChanged() {
            FilteredConversationModel.this.updateConversations();
        }
    }
}

