/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import EDU.oswego.cs.dl.util.concurrent.Sync;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.owasp.webscarab.model.AbstractConversationModel;
import org.owasp.webscarab.model.AbstractUrlModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.Cookie;
import org.owasp.webscarab.model.FileSystemStore;
import org.owasp.webscarab.model.FrameworkEvent;
import org.owasp.webscarab.model.FrameworkListener;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.SiteModelStore;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.model.UrlModel;
import org.owasp.webscarab.util.MRUCache;
import org.owasp.webscarab.util.ReentrantReaderPreferenceReadWriteLock;

public class FrameworkModel {
    private ReentrantReaderPreferenceReadWriteLock _rwl = new ReentrantReaderPreferenceReadWriteLock();
    private static final Cookie[] NO_COOKIES = new Cookie[0];
    private EventListenerList _listenerList = new EventListenerList();
    private Map _urlCache = new MRUCache(200);
    private SiteModelStore _store = null;
    private FrameworkUrlModel _urlModel;
    private FrameworkConversationModel _conversationModel;
    private boolean _modified = false;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public FrameworkModel() {
        this._logger.setLevel(Level.INFO);
        this._conversationModel = new FrameworkConversationModel(this);
        this._urlModel = new FrameworkUrlModel();
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        try {
            this._rwl.writeLock().acquire();
            if (type.equals("FileSystem") && store instanceof File) {
                try {
                    this._store = new FileSystemStore((File)store);
                }
                catch (Exception e) {
                    throw new StoreException("Error initialising session : " + e.getMessage());
                }
            } else {
                this._rwl.writeLock().release();
                throw new StoreException("Unknown store type " + type + " and store " + store);
            }
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._urlModel.fireUrlsChanged();
            this._conversationModel.fireConversationsChanged();
            this.fireCookiesChanged();
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public Sync readLock() {
        return this._rwl.readLock();
    }

    public UrlModel getUrlModel() {
        return this._urlModel;
    }

    public ConversationModel getConversationModel() {
        return this._conversationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws StoreException {
        if (this._modified) {
            try {
                this._rwl.readLock().acquire();
                try {
                    this._store.flush();
                    this._modified = false;
                }
                finally {
                    this._rwl.readLock().release();
                }
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
            }
        }
    }

    public boolean isModified() {
        return this._modified;
    }

    public ConversationID reserveConversationID() {
        return new ConversationID();
    }

    public void addConversation(ConversationID id, Date when, Request request, Response response, String origin) {
        try {
            HttpUrl url = request.getURL();
            this.addUrl(url);
            this._rwl.writeLock().acquire();
            int index = this._store.addConversation(id, when, request, response);
            this._store.setConversationProperty(id, "ORIGIN", origin);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._conversationModel.fireConversationAdded(id, index);
            this._rwl.readLock().release();
            this.addUrlProperty(url, "METHODS", request.getMethod());
            this.addUrlProperty(url, "STATUS", response.getStatusLine());
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = true;
    }

    public String getConversationOrigin(ConversationID id) {
        return this.getConversationProperty(id, "ORIGIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date getConversationDate(ConversationID id) {
        try {
            this._rwl.readLock().acquire();
            try {
                String when = this.getConversationProperty(id, "WHEN");
                if (when == null) {
                    Date date2 = null;
                    return date2;
                }
                long time = Long.parseLong(when);
                Date date = new Date(time);
                return date;
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public HttpUrl getRequestUrl(ConversationID conversation) {
        try {
            this._rwl.readLock().acquire();
            try {
                if (this._urlCache.containsKey(conversation)) {
                    HttpUrl httpUrl = (HttpUrl)this._urlCache.get(conversation);
                    return httpUrl;
                }
                String url = this.getConversationProperty(conversation, "URL");
                try {
                    HttpUrl httpUrl = new HttpUrl(url);
                    this._urlCache.put(conversation, httpUrl);
                    HttpUrl httpUrl2 = httpUrl;
                    return httpUrl2;
                }
                catch (MalformedURLException mue) {
                    System.err.println("Malformed URL for Conversation " + conversation + ": " + mue);
                    HttpUrl httpUrl = null;
                    this._rwl.readLock().release();
                    return httpUrl;
                }
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
            return null;
        }
    }

    public void setConversationProperty(ConversationID conversation, String property, String value) {
        try {
            this._rwl.writeLock().acquire();
            this._store.setConversationProperty(conversation, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._conversationModel.fireConversationChanged(conversation, 0);
            this.fireConversationPropertyChanged(conversation, property);
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = true;
    }

    public boolean addConversationProperty(ConversationID conversation, String property, String value) {
        boolean change = false;
        try {
            this._rwl.writeLock().acquire();
            change = this._store.addConversationProperty(conversation, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            if (change) {
                this._conversationModel.fireConversationChanged(conversation, 0);
                this.fireConversationPropertyChanged(conversation, property);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = this._modified || change;
        return change;
    }

    public String getConversationProperty(ConversationID conversation, String property) {
        String[] values = this.getConversationProperties(conversation, property);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuffer value = new StringBuffer(values[0]);
        for (int i = 1; i < values.length; ++i) {
            value.append(", ").append(values[i]);
        }
        return value.toString();
    }

    public String getRequestMethod(ConversationID id) {
        return this.getConversationProperty(id, "METHOD");
    }

    public String getResponseStatus(ConversationID id) {
        return this.getConversationProperty(id, "STATUS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getConversationProperties(ConversationID conversation, String property) {
        this._rwl.readLock().acquire();
        try {
            String[] stringArray = this._store.getConversationProperties(conversation, property);
            this._rwl.readLock().release();
            return stringArray;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUrl(HttpUrl url) {
        try {
            this._rwl.readLock().acquire();
            try {
                if (!this._store.isKnownUrl(url)) {
                    HttpUrl[] path = url.getUrlHierarchy();
                    for (int i = 0; i < path.length; ++i) {
                        if (this._store.isKnownUrl(path[i])) continue;
                        this._rwl.readLock().release();
                        while (!this._rwl.writeLock().attempt(5000L)) {
                            this._logger.severe("Timed out waiting for write lock, trying again");
                            this._rwl.debug();
                        }
                        if (!this._store.isKnownUrl(path[i])) {
                            this._store.addUrl(path[i]);
                            this._rwl.readLock().acquire();
                            this._rwl.writeLock().release();
                            this._urlModel.fireUrlAdded(path[i], 0);
                            this._modified = true;
                            continue;
                        }
                        this._rwl.readLock().acquire();
                        this._rwl.writeLock().release();
                    }
                }
            }
            finally {
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public void setUrlProperty(HttpUrl url, String property, String value) {
        this.addUrl(url);
        try {
            this._rwl.writeLock().acquire();
            this._store.setUrlProperty(url, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            this._urlModel.fireUrlChanged(url, 0);
            this.fireUrlPropertyChanged(url, property);
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = true;
    }

    public boolean addUrlProperty(HttpUrl url, String property, String value) {
        boolean change = false;
        this.addUrl(url);
        try {
            this._rwl.writeLock().acquire();
            change = this._store.addUrlProperty(url, property, value);
            this._rwl.readLock().acquire();
            this._rwl.writeLock().release();
            if (change) {
                this._urlModel.fireUrlChanged(url, 0);
                this.fireUrlPropertyChanged(url, property);
            }
            this._rwl.readLock().release();
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
        this._modified = this._modified || change;
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getUrlProperties(HttpUrl url, String property) {
        this._rwl.readLock().acquire();
        try {
            String[] stringArray = this._store.getUrlProperties(url, property);
            this._rwl.readLock().release();
            return stringArray;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    public String getUrlProperty(HttpUrl url, String property) {
        String[] values = this.getUrlProperties(url, property);
        if (values == null || values.length == 0) {
            return null;
        }
        if (values.length == 1) {
            return values[0];
        }
        StringBuffer value = new StringBuffer(30);
        value.append(values[0]);
        for (int i = 1; i < values.length; ++i) {
            value.append(", ").append(values[i]);
        }
        return value.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request getRequest(ConversationID conversation) {
        this._rwl.readLock().acquire();
        try {
            Request request = this._store.getRequest(conversation);
            this._rwl.readLock().release();
            return request;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response getResponse(ConversationID conversation) {
        this._rwl.readLock().acquire();
        try {
            Response response = this._store.getResponse(conversation);
            this._rwl.readLock().release();
            return response;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(FrameworkListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.add(FrameworkListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(FrameworkListener listener) {
        EventListenerList eventListenerList = this._listenerList;
        synchronized (eventListenerList) {
            this._listenerList.remove(FrameworkListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCookieCount() {
        if (this._store == null) {
            return 0;
        }
        this._rwl.readLock().acquire();
        try {
            int n = this._store.getCookieCount();
            this._rwl.readLock().release();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCookieCount(String key) {
        this._rwl.readLock().acquire();
        try {
            int n = this._store.getCookieCount(key);
            this._rwl.readLock().release();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCookieAt(int index) {
        this._rwl.readLock().acquire();
        try {
            String string = this._store.getCookieAt(index);
            this._rwl.readLock().release();
            return string;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie getCookieAt(String key, int index) {
        this._rwl.readLock().acquire();
        try {
            Cookie cookie = this._store.getCookieAt(key, index);
            this._rwl.readLock().release();
            return cookie;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfCookie(Cookie cookie) {
        this._rwl.readLock().acquire();
        try {
            int n = this._store.getIndexOfCookie(cookie);
            this._rwl.readLock().release();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIndexOfCookie(String key, Cookie cookie) {
        this._rwl.readLock().acquire();
        try {
            int n = this._store.getIndexOfCookie(key, cookie);
            this._rwl.readLock().release();
            return n;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie getCurrentCookie(String key) {
        this._rwl.readLock().acquire();
        try {
            int count = this._store.getCookieCount(key);
            Cookie cookie = this._store.getCookieAt(key, count - 1);
            this._rwl.readLock().release();
            return cookie;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return null;
            }
        }
    }

    public void addCookie(Cookie cookie) {
        try {
            this._rwl.writeLock().acquire();
            boolean added = this._store.addCookie(cookie);
            if (!added) {
                this._rwl.writeLock().release();
            } else {
                this._modified = true;
                this._rwl.readLock().acquire();
                this._rwl.writeLock().release();
                this.fireCookieAdded(cookie);
                this._rwl.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    public void removeCookie(Cookie cookie) {
        try {
            this._rwl.writeLock().acquire();
            boolean deleted = this._store.removeCookie(cookie);
            if (deleted) {
                this._modified = true;
                this._rwl.readLock().acquire();
                this._rwl.writeLock().release();
                this.fireCookieRemoved(cookie);
                this._rwl.readLock().release();
            } else {
                this._rwl.writeLock().release();
            }
        }
        catch (InterruptedException ie) {
            this._logger.severe("Interrupted! " + ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cookie[] getCookiesForUrl(HttpUrl url) {
        this._rwl.readLock().acquire();
        try {
            ArrayList<Cookie> cookies = new ArrayList<Cookie>();
            String host = url.getHost();
            String path = url.getPath();
            int size = this.getCookieCount();
            for (int i = 0; i < size; ++i) {
                String key = this.getCookieAt(i);
                Cookie cookie = this.getCurrentCookie(key);
                String domain = cookie.getDomain();
                if (!host.equals(domain) && (!domain.startsWith(".") || !host.endsWith(domain)) || !path.startsWith(cookie.getPath())) continue;
                cookies.add(cookie);
            }
            Cookie[] cookieArray = cookies.toArray(NO_COOKIES);
            this._rwl.readLock().release();
            return cookieArray;
        }
        catch (Throwable throwable) {
            try {
                this._rwl.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                this._logger.severe("Interrupted! " + ie);
                return NO_COOKIES;
            }
        }
    }

    protected void fireCookieAdded(Cookie cookie) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent(this, cookie);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$FrameworkListener == null ? FrameworkModel.class$("org.owasp.webscarab.model.FrameworkListener") : class$org$owasp$webscarab$model$FrameworkListener)) continue;
            try {
                ((FrameworkListener)listeners[i + 1]).cookieAdded(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireCookieRemoved(Cookie cookie) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent(this, cookie);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$FrameworkListener == null ? FrameworkModel.class$("org.owasp.webscarab.model.FrameworkListener") : class$org$owasp$webscarab$model$FrameworkListener)) continue;
            try {
                ((FrameworkListener)listeners[i + 1]).cookieRemoved(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireCookiesChanged() {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$FrameworkListener == null ? FrameworkModel.class$("org.owasp.webscarab.model.FrameworkListener") : class$org$owasp$webscarab$model$FrameworkListener)) continue;
            try {
                ((FrameworkListener)listeners[i + 1]).cookiesChanged();
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireConversationPropertyChanged(ConversationID id, String property) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent((Object)this, id, property);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$FrameworkListener == null ? FrameworkModel.class$("org.owasp.webscarab.model.FrameworkListener") : class$org$owasp$webscarab$model$FrameworkListener)) continue;
            try {
                ((FrameworkListener)listeners[i + 1]).conversationPropertyChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    protected void fireUrlPropertyChanged(HttpUrl url, String property) {
        Object[] listeners = this._listenerList.getListenerList();
        FrameworkEvent evt = new FrameworkEvent((Object)this, url, property);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$model$FrameworkListener == null ? FrameworkModel.class$("org.owasp.webscarab.model.FrameworkListener") : class$org$owasp$webscarab$model$FrameworkListener)) continue;
            try {
                ((FrameworkListener)listeners[i + 1]).urlPropertyChanged(evt);
                continue;
            }
            catch (Exception e) {
                this._logger.severe("Unhandled exception: " + e);
            }
        }
    }

    private class FrameworkConversationModel
    extends AbstractConversationModel {
        public FrameworkConversationModel(FrameworkModel model) {
            super(model);
        }

        public Sync readLock() {
            return FrameworkModel.this._rwl.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ConversationID getConversationAt(int index) {
            this.readLock().acquire();
            try {
                ConversationID conversationID = FrameworkModel.this._store.getConversationAt(null, index);
                this.readLock().release();
                return conversationID;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getConversationCount() {
            if (FrameworkModel.this._store == null) {
                return 0;
            }
            this.readLock().acquire();
            try {
                int n = FrameworkModel.this._store.getConversationCount(null);
                this.readLock().release();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOfConversation(ConversationID id) {
            this.readLock().acquire();
            try {
                int n = FrameworkModel.this._store.getIndexOfConversation(null, id);
                this.readLock().release();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
        }
    }

    private class FrameworkUrlModel
    extends AbstractUrlModel {
        private FrameworkUrlModel() {
        }

        public Sync readLock() {
            return FrameworkModel.this._rwl.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getChildCount(HttpUrl parent) {
            if (FrameworkModel.this._store == null) {
                return 0;
            }
            this.readLock().acquire();
            try {
                int n = FrameworkModel.this._store.getChildCount(parent);
                this.readLock().release();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return 0;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexOf(HttpUrl url) {
            this.readLock().acquire();
            try {
                int n = FrameworkModel.this._store.getIndexOf(url);
                this.readLock().release();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HttpUrl getChildAt(HttpUrl parent, int index) {
            this.readLock().acquire();
            try {
                HttpUrl httpUrl = FrameworkModel.this._store.getChildAt(parent, index);
                this.readLock().release();
                return httpUrl;
            }
            catch (Throwable throwable) {
                try {
                    this.readLock().release();
                    throw throwable;
                }
                catch (InterruptedException ie) {
                    FrameworkModel.this._logger.severe("Interrupted! " + ie);
                    return null;
                }
            }
        }
    }
}

