/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.parser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.parser.ContentParser;
import org.owasp.webscarab.parser.HTMLParser;
import org.owasp.webscarab.util.MRUCache;

public class Parser {
    private static List _parsers = new ArrayList();
    private static MRUCache _cache = new MRUCache(8);

    private Parser() {
    }

    public static Object parse(HttpUrl url, Message message) {
        ContentParser parser;
        if (_cache.containsKey(message)) {
            return _cache.get(message);
        }
        Iterator it = _parsers.iterator();
        Object parsed = null;
        while (it.hasNext() && (parsed = (parser = (ContentParser)it.next()).parseMessage(url, message)) == null) {
        }
        _cache.put(message, parsed);
        return parsed;
    }

    static {
        _parsers.add(new HTMLParser());
    }
}

