/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.owasp.webscarab.httpclient.Authenticator;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.BasicCredential;
import org.owasp.webscarab.plugin.CredentialManagerUI;
import org.owasp.webscarab.plugin.DomainCredential;
import org.owasp.webscarab.util.Encoding;

public class CredentialManager
implements Authenticator {
    private Map _basicCredentials = new TreeMap();
    private Map _domainCredentials = new TreeMap();
    private CredentialManagerUI _ui = null;

    public void setUI(CredentialManagerUI ui) {
        this._ui = ui;
    }

    public synchronized String getCredentials(HttpUrl url, String[] challenges) {
        String creds = this.getPreferredCredentials(url.getHost(), challenges);
        if (creds != null) {
            return creds;
        }
        boolean prompt = Boolean.valueOf(Preferences.getPreference("WebScarab.promptForCredentials", "false"));
        if (prompt && this._ui != null && challenges != null && challenges.length > 0) {
            boolean ask = false;
            for (int i = 0; i < challenges.length; ++i) {
                if (!challenges[i].startsWith("Basic") && !challenges[i].startsWith("NTLM") && !challenges[i].startsWith("Negotiate")) continue;
                ask = true;
            }
            if (ask) {
                this._ui.requestCredentials(url.getHost(), challenges);
            }
        }
        return this.getPreferredCredentials(url.getHost(), challenges);
    }

    public synchronized String getProxyCredentials(String hostname, String[] challenges) {
        String creds = this.getPreferredCredentials(hostname, challenges);
        if (creds != null) {
            return creds;
        }
        boolean prompt = Boolean.valueOf(Preferences.getPreference("WebScarab.promptForCredentials", "false"));
        if (prompt && this._ui != null && challenges != null && challenges.length > 0) {
            boolean ask = false;
            for (int i = 0; i < challenges.length; ++i) {
                if (!challenges[i].startsWith("Basic") && !challenges[i].startsWith("NTLM") && !challenges[i].startsWith("Negotiate")) continue;
                ask = true;
            }
            if (ask) {
                this._ui.requestCredentials(hostname, challenges);
            }
        }
        return this.getPreferredCredentials(hostname, challenges);
    }

    public void addBasicCredentials(BasicCredential cred) {
        if ((cred.getUsername() == null || cred.getUsername().equals("")) && (cred.getPassword() == null || cred.getPassword().equals(""))) {
            return;
        }
        TreeMap<String, BasicCredential> realms = (TreeMap<String, BasicCredential>)this._basicCredentials.get(cred.getHost());
        if (realms == null) {
            realms = new TreeMap<String, BasicCredential>();
            this._basicCredentials.put(cred.getHost(), realms);
        }
        realms.put(cred.getRealm(), cred);
    }

    public void addDomainCredentials(DomainCredential cred) {
        if ((cred.getUsername() == null || cred.getUsername().equals("")) && (cred.getPassword() == null || cred.getPassword().equals(""))) {
            return;
        }
        this._domainCredentials.put(cred.getHost(), cred);
    }

    public int getBasicCredentialCount() {
        return this.getAllBasicCredentials().length;
    }

    public BasicCredential getBasicCredentialAt(int index) {
        return this.getAllBasicCredentials()[index];
    }

    public void deleteBasicCredentialAt(int index) {
        int i = -1;
        Iterator hosts = this._basicCredentials.keySet().iterator();
        while (hosts.hasNext()) {
            Map realms = (Map)this._basicCredentials.get(hosts.next());
            Iterator realm = realms.keySet().iterator();
            while (realm.hasNext()) {
                Object key = realm.next();
                if (++i != index) continue;
                realms.remove(key);
            }
        }
    }

    public int getDomainCredentialCount() {
        return this._domainCredentials.entrySet().size();
    }

    public DomainCredential getDomainCredentialAt(int index) {
        ArrayList all = new ArrayList();
        Iterator hosts = this._domainCredentials.keySet().iterator();
        while (hosts.hasNext()) {
            all.add(this._domainCredentials.get(hosts.next()));
        }
        return all.toArray(new DomainCredential[0])[index];
    }

    public void deleteDomainCredentialAt(int index) {
        int i = -1;
        Iterator hosts = this._domainCredentials.keySet().iterator();
        while (hosts.hasNext()) {
            Object key = hosts.next();
            if (++i != index) continue;
            this._domainCredentials.remove(key);
        }
    }

    private BasicCredential[] getAllBasicCredentials() {
        ArrayList all = new ArrayList();
        Iterator hosts = this._basicCredentials.keySet().iterator();
        while (hosts.hasNext()) {
            Map realms = (Map)this._basicCredentials.get(hosts.next());
            Iterator realm = realms.keySet().iterator();
            while (realm.hasNext()) {
                all.add(realms.get(realm.next()));
            }
        }
        return all.toArray(new BasicCredential[0]);
    }

    private String getPreferredCredentials(String host, String[] challenges) {
        String creds;
        int i;
        if (challenges == null || challenges.length == 0) {
            return null;
        }
        for (i = 0; i < challenges.length; ++i) {
            if (!challenges[i].startsWith("Basic") || (creds = this.getBasicCredentials(host, challenges[i])) == null) continue;
            return "Basic " + creds;
        }
        for (i = 0; i < challenges.length; ++i) {
            if (!challenges[i].startsWith("NTLM") || (creds = this.getDomainCredentials(host)) == null) continue;
            return "NTLM " + creds;
        }
        for (i = 0; i < challenges.length; ++i) {
            if (!challenges[i].startsWith("Negotiate") || (creds = this.getDomainCredentials(host)) == null) continue;
            return "Negotiate " + creds;
        }
        return null;
    }

    private String getBasicCredentials(String host, String challenge) {
        String realm = challenge.substring("Basic Realm=\"".length(), challenge.length() - 1);
        Map realms = (Map)this._basicCredentials.get(host);
        if (realms == null) {
            return null;
        }
        BasicCredential cred = (BasicCredential)realms.get(realm);
        if (cred == null) {
            return null;
        }
        String encoded = cred.getUsername() + ":" + cred.getPassword();
        return Encoding.base64encode(encoded.getBytes(), false);
    }

    private String getDomainCredentials(String host) {
        DomainCredential cred = (DomainCredential)this._domainCredentials.get(host);
        if (cred == null) {
            return null;
        }
        String encoded = cred.getDomain() + "\\" + cred.getUsername() + ":" + cred.getPassword();
        return Encoding.base64encode(encoded.getBytes(), false);
    }
}

