/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.owasp.webscarab.plugin.Script;

public class Hook {
    private String _name;
    private String _description;
    private List _scripts = new ArrayList();
    protected BSFManager _bsfManager = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Hook(String name, String description) {
        this._name = name;
        this._description = description;
    }

    public void setBSFManager(BSFManager bsfManager) {
        this._bsfManager = bsfManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runScripts() {
        if (this._bsfManager == null) {
            return;
        }
        BSFManager bSFManager = this._bsfManager;
        synchronized (bSFManager) {
            for (int i = 0; i < this._scripts.size(); ++i) {
                Script script = (Script)this._scripts.get(i);
                if (!script.isEnabled()) continue;
                try {
                    this._bsfManager.exec(script.getLanguage(), this._name, 0, 0, (Object)script.getScript());
                    continue;
                }
                catch (BSFException bsfe) {
                    this._logger.warning("Script exception: " + (Object)((Object)bsfe));
                }
            }
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._description;
    }

    public int getScriptCount() {
        return this._scripts.size();
    }

    public Script getScript(int i) {
        return (Script)this._scripts.get(i);
    }

    public void addScript(Script script) {
        this._scripts.add(script);
    }

    public void addScript(Script script, int position) {
        this._scripts.add(position, script);
    }

    public Script removeScript(int position) {
        return (Script)this._scripts.remove(position);
    }
}

