/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.Logger;

public class Script {
    private File _file;
    private String _script;
    private long _lastModified;
    private boolean _enabled;
    private String _language = null;
    private Logger _logger = Logger.getLogger(this.getClass().toString());

    public Script(File file) throws IOException {
        this._file = file;
        this.reload();
        this._enabled = false;
    }

    public void reload() throws IOException {
        this._logger.info("reloading " + this._file);
        FileReader fr = null;
        try {
            int got;
            fr = new FileReader(this._file);
            char[] buff = new char[1024];
            StringBuffer script = new StringBuffer();
            while ((got = fr.read(buff)) > 0) {
                script.append(buff, 0, got);
            }
            this._script = script.toString();
            this._lastModified = this._file.lastModified();
        }
        catch (IOException ioe) {
            this._enabled = false;
            this._script = "";
            throw ioe;
        }
        finally {
            if (fr != null) {
                fr.close();
            }
        }
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            try {
                this.reload();
            }
            catch (IOException ioe) {
                this._logger.severe("Error reloading script " + this._file + " : " + ioe);
                this._enabled = false;
                return;
            }
        }
        this._enabled = enabled;
    }

    public File getFile() {
        return this._file;
    }

    public String getScript() {
        return this._script;
    }

    public void setScript(String script) throws IOException {
        this._script = script;
        FileWriter fw = null;
        try {
            fw = new FileWriter(this._file);
            fw.write(this._script);
        }
        catch (IOException ioe) {
            this._script = null;
            this._lastModified = -1L;
            this._language = null;
            this._enabled = false;
            throw ioe;
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public long getLastModified() {
        return this._lastModified;
    }

    public String getLanguage() {
        return this._language;
    }

    public void setLanguage(String language) {
        this._language = language;
    }
}

