/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Script;
import org.owasp.webscarab.plugin.ScriptListener;

public class ScriptManager {
    private BSFManager _bsfManager;
    private TreeMap _hooks = new TreeMap();
    private EventListenerList _listeners = new EventListenerList();
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public ScriptManager(Framework framework) {
        try {
            this._bsfManager = new BSFManager();
            this._bsfManager.declareBean("framework", (Object)framework, framework.getClass());
            this._bsfManager.declareBean("out", (Object)System.out, System.out.getClass());
            this._bsfManager.declareBean("err", (Object)System.err, System.out.getClass());
        }
        catch (BSFException bsfe) {
            this._logger.severe("Declaring a bean should not throw an exception! " + (Object)((Object)bsfe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScriptListener(ScriptListener listener) {
        EventListenerList eventListenerList = this._listeners;
        synchronized (eventListenerList) {
            this._listeners.add(ScriptListener.class, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeScriptListener(ScriptListener listener) {
        EventListenerList eventListenerList = this._listeners;
        synchronized (eventListenerList) {
            this._listeners.remove(ScriptListener.class, listener);
        }
    }

    public void registerHooks(String pluginName, Hook[] hooks) {
        if (hooks != null && hooks.length > 0) {
            this._hooks.put(pluginName, hooks);
            for (int i = 0; i < hooks.length; ++i) {
                hooks[i].setBSFManager(this._bsfManager);
            }
            this.fireHooksChanged();
        }
    }

    public int getPluginCount() {
        return this._hooks.size();
    }

    public String getPlugin(int i) {
        String[] plugins = this._hooks.keySet().toArray(new String[0]);
        return plugins[i];
    }

    public int getHookCount(String plugin) {
        Hook[] hooks = (Hook[])this._hooks.get(plugin);
        if (hooks == null) {
            return 0;
        }
        return hooks.length;
    }

    public Hook getHook(String plugin, int i) {
        Hook[] hooks = (Hook[])this._hooks.get(plugin);
        if (hooks == null) {
            return null;
        }
        return hooks[i];
    }

    public void addScript(String plugin, Hook hook, Script script, int position) throws BSFException {
        String language = BSFManager.getLangFromFilename((String)script.getFile().getName());
        if (language != null) {
            script.setLanguage(language);
            script.setEnabled(true);
            hook.addScript(script, position);
            this.fireScriptAdded(plugin, hook, script);
        }
    }

    public void addScript(String plugin, Hook hook, Script script) throws BSFException {
        this.addScript(plugin, hook, script, hook.getScriptCount());
    }

    public void setEnabled(String plugin, Hook hook, Script script, boolean enabled) {
        script.setEnabled(enabled);
        this.fireScriptChanged(plugin, hook, script);
    }

    public void removeScript(String plugin, Hook hook, Script script) {
        int count = hook.getScriptCount();
        for (int i = 0; i < count; ++i) {
            Script s = hook.getScript(i);
            if (s != script) continue;
            hook.removeScript(i);
            this.fireScriptRemoved(plugin, hook, script);
            return;
        }
    }

    public void loadScripts() {
        Iterator hookIt = this._hooks.entrySet().iterator();
        while (hookIt.hasNext()) {
            Map.Entry entry = hookIt.next();
            String plugin = (String)entry.getKey();
            Hook[] hooks = (Hook[])entry.getValue();
            if (hooks == null) continue;
            for (int i = 0; i < hooks.length; ++i) {
                int j;
                for (j = 0; j < hooks[i].getScriptCount(); ++j) {
                    hooks[i].removeScript(j);
                }
                j = 0;
                String scriptName = Preferences.getPreference(hooks[i].getName() + "." + j + ".name");
                while (scriptName != null) {
                    File f = new File(scriptName);
                    if (f.canRead()) {
                        try {
                            Script script = new Script(f);
                            String enabled = Preferences.getPreference(hooks[i].getName() + "." + j + ".enabled", "false");
                            this.addScript(plugin, hooks[i], script);
                            this.setEnabled(plugin, hooks[i], script, Boolean.valueOf(enabled));
                        }
                        catch (IOException ioe) {
                            this._logger.warning("Error loading script '" + scriptName + "' : " + ioe.getLocalizedMessage());
                        }
                        catch (BSFException bsfe) {
                            this._logger.warning("Error loading script '" + scriptName + "' : " + bsfe.getLocalizedMessage());
                        }
                    }
                    scriptName = Preferences.getPreference(hooks[i].getName() + "." + ++j + ".name");
                }
            }
        }
    }

    public void saveScripts() {
        Iterator hookIt = this._hooks.entrySet().iterator();
        while (hookIt.hasNext()) {
            Map.Entry entry = hookIt.next();
            Hook[] hooks = (Hook[])entry.getValue();
            if (hooks == null) continue;
            for (int i = 0; i < hooks.length; ++i) {
                for (int j = 0; j < hooks[i].getScriptCount(); ++j) {
                    Script script = hooks[i].getScript(j);
                    Preferences.setPreference(hooks[i].getName() + "." + j + ".name", script.getFile().getAbsolutePath());
                    Preferences.setPreference(hooks[i].getName() + "." + j + ".enabled", Boolean.toString(script.isEnabled()));
                }
                Preferences.remove(hooks[i].getName() + "." + hooks[i].getScriptCount() + ".name");
                Preferences.remove(hooks[i].getName() + "." + hooks[i].getScriptCount() + ".enabled");
            }
        }
    }

    protected void fireHooksChanged() {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).hooksChanged();
        }
    }

    protected void fireScriptAdded(String plugin, Hook hook, Script script) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptAdded(plugin, hook, script);
        }
    }

    protected void fireScriptRemoved(String plugin, Hook hook, Script script) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptRemoved(plugin, hook, script);
        }
    }

    protected void fireScriptStarted(String plugin, Hook hook, Script script) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptStarted(plugin, hook, script);
        }
    }

    protected void fireScriptEnded(String plugin, Hook hook, Script script) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptEnded(plugin, hook, script);
        }
    }

    protected void fireScriptChanged(String plugin, Hook hook, Script script) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptChanged(plugin, hook, script);
        }
    }

    protected void fireScriptError(String plugin, Hook hook, Script script, Throwable error) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).scriptError(plugin, hook, script, error);
        }
    }

    protected void fireHookEnded(String plugin, Hook hook) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$org$owasp$webscarab$plugin$ScriptListener == null ? ScriptManager.class$("org.owasp.webscarab.plugin.ScriptListener") : class$org$owasp$webscarab$plugin$ScriptListener)) continue;
            ((ScriptListener)listeners[i + 1]).hookEnded(plugin, hook);
        }
    }
}

