/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.compare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.compare.CompareModel;
import org.owasp.webscarab.util.LevenshteinDistance;

public class Compare
implements Plugin {
    private CompareModel _model;
    private ConversationID _selected = null;
    private Thread _runThread = null;
    private Object _lock = new Object();
    private LevenshteinDistance _diff = null;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Compare(Framework framework) {
        this._model = new CompareModel(framework.getModel());
    }

    public CompareModel getModel() {
        return this._model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBaseConversation(HttpUrl url, ConversationID id) {
        this._model.clearConversations();
        this._selected = id;
        if (this._model.isBusy()) {
            this._runThread.interrupt();
        }
        Object object = this._lock;
        synchronized (object) {
            this._lock.notifyAll();
        }
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
    }

    public void flush() throws StoreException {
    }

    public String getPluginName() {
        return "Compare";
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._runThread = Thread.currentThread();
        this._model.setRunning(true);
        int count = 0;
        ConversationID id = null;
        ConversationModel cmodel = this._model.getConversationModel();
        while (!this._model.isStopping()) {
            try {
                Object object = this._lock;
                synchronized (object) {
                    this._lock.wait();
                }
                if (id != this._selected) {
                    id = this._selected;
                    this._model.setBusy(true);
                    HttpUrl baseUrl = cmodel.getRequestUrl(id);
                    if (baseUrl.getQuery() != null) {
                        baseUrl = baseUrl.getParentUrl();
                    }
                    Response baseResponse = cmodel.getResponse(id);
                    byte[] baseBytes = baseResponse.getContent();
                    String type = baseResponse.getHeader("Content-Type");
                    if (type == null || !type.startsWith("text")) {
                        this._logger.warning("Base response is not text, skipping!");
                        return;
                    }
                    List baseline = this.tokenize(baseBytes);
                    this._diff = new LevenshteinDistance(baseline);
                    count = cmodel.getConversationCount();
                    this._logger.info("Checking " + count + " conversaitons");
                    for (int i = 0; i < count; ++i) {
                        ConversationID cid = cmodel.getConversationAt(i);
                        HttpUrl curl = cmodel.getRequestUrl(cid);
                        if (curl.getQuery() != null) {
                            curl = curl.getParentUrl();
                        }
                        if (!curl.equals(baseUrl)) continue;
                        this._logger.info("Checking conversation " + i + " == " + cid);
                        if (cid.equals(id)) {
                            this._model.setDistance(cid, 0);
                            continue;
                        }
                        Response response = cmodel.getResponse(cid);
                        String ctype = response.getHeader("Content-Type");
                        this._logger.info("Content-type is " + ctype);
                        if (ctype == null || !ctype.startsWith("text")) continue;
                        byte[] bytes = response.getContent();
                        List target = this.tokenize(bytes);
                        this._model.setDistance(cid, this._diff.getDistance(target));
                    }
                    this._model.setBusy(false);
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {}
        }
        this._model.setRunning(false);
        this._model.setStopping(false);
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public boolean stop() {
        this._model.setStopping(true);
        this._runThread.interrupt();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !this._model.isRunning();
    }

    private List tokenize(byte[] bytes) {
        if (bytes == null) {
            return new ArrayList();
        }
        String[] words = new String(bytes).split("\\s");
        List<String> tokens = Arrays.asList(words);
        return tokens;
    }
}

