/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.compare.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.compare.Compare;
import org.owasp.webscarab.plugin.compare.CompareModel;
import org.owasp.webscarab.ui.swing.ConversationListModel;
import org.owasp.webscarab.ui.swing.ConversationRenderer;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.Diff;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.DiffPanel;
import org.owasp.webscarab.util.swing.ListComboBoxModel;
import org.owasp.webscarab.util.swing.SwingWorker;
import org.owasp.webscarab.util.swing.TableSorter;

public class ComparePanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = -7352280691484196048L;
    private Compare _compare;
    private CompareModel _model;
    private ConversationTableModel _tableModel;
    private TableSorter _conversationSorter;
    private DiffPanel _diffPanel;
    private String _base = null;
    private JComboBox baseComboBox;
    private JSplitPane compareSplitPane;
    private JTable conversationTable;
    private JScrollPane jScrollPane1;
    static /* synthetic */ Class class$java$lang$Integer;

    public ComparePanel(Compare compare) {
        this.initComponents();
        this._compare = compare;
        this._model = this._compare.getModel();
        this.baseComboBox.setModel(new ListComboBoxModel(new ConversationListModel(this._model.getConversationModel())));
        this.baseComboBox.setRenderer(new ConversationRenderer(this._model.getConversationModel()));
        this._tableModel = new ConversationTableModel(this._model.getComparisonModel());
        this._tableModel.addColumn(new ColumnDataModel(){

            public Object getValue(Object key) {
                if (ComparePanel.this._model == null) {
                    return null;
                }
                return ComparePanel.this._model.getDistance((ConversationID)key);
            }

            public String getColumnName() {
                return "Distance";
            }

            public Class getColumnClass() {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ComparePanel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
        });
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
        this._conversationSorter = new TableSorter(this._tableModel, this.conversationTable.getTableHeader());
        this.conversationTable.setModel(this._conversationSorter);
        this._diffPanel = new DiffPanel();
        this.compareSplitPane.setBottomComponent(this._diffPanel);
        this.baseComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object o = ComparePanel.this.baseComboBox.getSelectedItem();
                if (o instanceof ConversationID) {
                    ConversationID id = (ConversationID)o;
                    ConversationModel cModel = ComparePanel.this._model.getConversationModel();
                    Response response = cModel.getResponse(id);
                    String cType = response.getHeader("Content-Type");
                    if (cType == null || !cType.startsWith("text")) {
                        JOptionPane.showMessageDialog(ComparePanel.this, "Selected conversation is not text", "Error", 0);
                        return;
                    }
                    byte[] content = response.getContent();
                    if (content == null || content.length == 0) {
                        JOptionPane.showMessageDialog(ComparePanel.this, "Selected conversation has no content", "Error", 0);
                        return;
                    }
                    ComparePanel.this._compare.setBaseConversation(null, id);
                    ComparePanel.this._base = new String(content);
                }
            }
        });
        this.conversationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ConversationID id;
                int selected = ComparePanel.this.conversationTable.getSelectedRow();
                ComparePanel.this._diffPanel.clear();
                if (selected == -1) {
                    return;
                }
                selected = ComparePanel.this._conversationSorter.modelIndex(selected);
                ConversationModel cmodel = ComparePanel.this._model.getComparisonModel();
                Response response = cmodel.getResponse(id = cmodel.getConversationAt(selected));
                String contentType = response.getHeader("Content-Type");
                if (contentType == null || !contentType.startsWith("text")) {
                    JOptionPane.showMessageDialog(ComparePanel.this, "Selected conversation is not text", "Error", 0);
                    return;
                }
                byte[] content = response.getContent();
                if (content == null || content.length == 0) {
                    JOptionPane.showMessageDialog(ComparePanel.this, "Selected conversation has no content", "Error", 0);
                    return;
                }
                final String dst = new String(content);
                new SwingWorker(){

                    public Object construct() {
                        return Diff.getEdits(ComparePanel.this._base, dst);
                    }

                    public void finished() {
                        List edits = (List)this.get();
                        ComparePanel.this._diffPanel.showDifferences(ComparePanel.this._base, dst, edits);
                    }
                }.start();
            }
        });
    }

    private void initComponents() {
        this.baseComboBox = new JComboBox();
        this.compareSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.conversationTable = new JTable();
        this.setLayout(new BorderLayout());
        this.baseComboBox.setMaximumSize(null);
        this.add((Component)this.baseComboBox, "North");
        this.compareSplitPane.setOrientation(0);
        this.compareSplitPane.setResizeWeight(0.3);
        this.compareSplitPane.setOneTouchExpandable(true);
        this.conversationTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.conversationTable);
        this.compareSplitPane.setLeftComponent(this.jScrollPane1);
        this.add((Component)this.compareSplitPane, "Center");
    }

    public Action[] getConversationActions() {
        return new Action[0];
    }

    public ColumnDataModel[] getConversationColumns() {
        return new ColumnDataModel[0];
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return "Compare";
    }

    public Action[] getUrlActions() {
        return new Action[0];
    }

    public ColumnDataModel[] getUrlColumns() {
        return new ColumnDataModel[0];
    }
}

