/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fragments;

import java.io.File;
import java.util.logging.Logger;
import org.htmlparser.nodes.RemarkNode;
import org.htmlparser.tags.ScriptTag;
import org.htmlparser.util.NodeList;
import org.htmlparser.util.ParserException;
import org.htmlparser.util.SimpleNodeIterator;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.parser.Parser;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.fragments.FileSystemStore;
import org.owasp.webscarab.plugin.fragments.FragmentsModel;

public class Fragments
implements Plugin {
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private FragmentsModel _model = null;

    public Fragments(Framework framework) {
        this._model = new FragmentsModel(framework.getModel());
    }

    public FragmentsModel getModel() {
        return this._model;
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        if (!type.equals("FileSystem") || !(store instanceof File)) {
            throw new StoreException("Store type '" + type + "' is not supported in " + this.getClass().getName());
        }
        this._model.setStore(new FileSystemStore((File)store, session));
    }

    public String getPluginName() {
        return "Fragments";
    }

    public void run() {
        this._model.setRunning(true);
    }

    public boolean stop() {
        this._model.setRunning(false);
        return !this._model.isRunning();
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
        HttpUrl url = request.getURL();
        Object parsed = Parser.parse(url, response);
        if (parsed != null && parsed instanceof NodeList) {
            NodeList nodes = (NodeList)parsed;
            try {
                NodeList comments = nodes.searchFor(RemarkNode.class);
                SimpleNodeIterator ni = comments.elements();
                while (ni.hasMoreNodes()) {
                    String fragment = ni.nextNode().toHtml();
                    this._model.addFragment(url, id, "COMMENTS", fragment);
                }
                NodeList scripts = nodes.searchFor(ScriptTag.class);
                SimpleNodeIterator ni2 = scripts.elements();
                while (ni2.hasMoreNodes()) {
                    String fragment = ni2.nextNode().toHtml();
                    this._model.addFragment(url, id, "SCRIPTS", fragment);
                }
            }
            catch (ParserException pe) {
                this._logger.warning("Looking for fragments, got '" + pe + "'");
            }
        }
    }

    public void flush() throws StoreException {
        this._model.flush();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }
}

