/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.fragments.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.util.swing.MultiLineCellRenderer;

public class FragmentsFrame
extends JFrame {
    private static final long serialVersionUID = 7945448210186454157L;
    private FragmentTableModel _ftm = new FragmentTableModel();
    private JTable fragmentTable;
    private JScrollPane jScrollPane1;

    public FragmentsFrame() {
        this.initComponents();
        this.fragmentTable.setModel(this._ftm);
        this.fragmentTable.setDefaultRenderer(String.class, new MultiLineCellRenderer());
    }

    public void setFragments(String[] fragments) {
        this._ftm.setFragments(fragments);
        this.fragmentTable.getColumnModel().getColumn(0).setPreferredWidth(640);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.fragmentTable = new JTable();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Fragment Frame");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FragmentsFrame.this.exitForm(evt);
            }
        });
        this.fragmentTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.fragmentTable.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.fragmentTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 640) / 2, (screenSize.height - 480) / 2, 640, 480);
    }

    private void exitForm(WindowEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        FragmentsFrame ff = new FragmentsFrame();
        ff.setFragments(new String[]{"a\nb\ncdef\n", "abc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\nabc def ghi jkl mno pqr stu vwx yz\n", "0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 0123456789 "});
        ff.setVisible(true);
    }

    private class FragmentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -4290112756620953610L;
        private String[] _fragments = null;

        public void setFragments(String[] fragments) {
            this._fragments = fragments;
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 1;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = FragmentsFrame.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getRowCount() {
            if (this._fragments == null) {
                return 0;
            }
            return this._fragments.length;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this._fragments[rowIndex];
        }
    }
}

