/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.manualrequest.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.manualrequest.ManualRequest;
import org.owasp.webscarab.plugin.manualrequest.ManualRequestModel;
import org.owasp.webscarab.plugin.manualrequest.ManualRequestUI;
import org.owasp.webscarab.ui.swing.ConversationListModel;
import org.owasp.webscarab.ui.swing.ConversationRenderer;
import org.owasp.webscarab.ui.swing.RequestPanel;
import org.owasp.webscarab.ui.swing.ResponsePanel;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.ListComboBoxModel;
import org.owasp.webscarab.util.swing.SwingWorker;

public class ManualRequestPanel
extends JPanel
implements SwingPluginUI,
ManualRequestUI {
    private static final long serialVersionUID = 277808739447506130L;
    private ManualRequestModel _model;
    private ManualRequest _manualRequest;
    private final RequestPanel _requestPanel;
    private final ResponsePanel _responsePanel;
    private final RequestUpdater _reqUpdater = new RequestUpdater();
    private final ResponseUpdater _respUpdater = new ResponseUpdater();
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private JSplitPane conversationSplitPane;
    private JButton fetchResponseButton;
    private JButton getCookieButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JComboBox requestComboBox;
    private JButton updateCookiesButton;

    public ManualRequestPanel(ManualRequest manualRequest) {
        this.initComponents();
        this._manualRequest = manualRequest;
        this._model = this._manualRequest.getModel();
        Request request = new Request();
        request.setMethod("GET");
        request.setVersion("HTTP/1.0");
        this._requestPanel = new RequestPanel();
        this._requestPanel.setEditable(true);
        this._requestPanel.setRequest(request);
        this._requestPanel.setBorder(new TitledBorder("Request"));
        this.conversationSplitPane.setLeftComponent(this._requestPanel);
        this._responsePanel = new ResponsePanel();
        this._responsePanel.setEditable(false);
        this._responsePanel.setResponse(null);
        this._responsePanel.setBorder(new TitledBorder("Response"));
        this.conversationSplitPane.setRightComponent(this._responsePanel);
        ConversationListModel conversationList = new ConversationListModel(this._model.getConversationModel());
        ListComboBoxModel requestModel = new ListComboBoxModel(conversationList);
        this.requestComboBox.setModel(requestModel);
        this.requestComboBox.setRenderer(new ConversationRenderer(this._model.getConversationModel()));
        this.requestComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManualRequestPanel.this.requestComboBoxActionPerformed(e);
            }
        });
        this._manualRequest.setUI(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.requestComboBox = new JComboBox();
        this.conversationSplitPane = new JSplitPane();
        this.jPanel2 = new JPanel();
        this.getCookieButton = new JButton();
        this.fetchResponseButton = new JButton();
        this.updateCookiesButton = new JButton();
        this.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setText("Previous Requests : ");
        this.jLabel1.setMinimumSize(new Dimension(135, 15));
        this.jPanel1.add((Component)this.jLabel1, "West");
        this.jPanel1.add((Component)this.requestComboBox, "Center");
        this.add((Component)this.jPanel1, "North");
        this.conversationSplitPane.setOrientation(0);
        this.conversationSplitPane.setResizeWeight(0.5);
        this.conversationSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.conversationSplitPane, "Center");
        this.jPanel2.setLayout(new GridLayout());
        this.getCookieButton.setText("Get Cookies");
        this.getCookieButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualRequestPanel.this.getCookieButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.getCookieButton);
        this.fetchResponseButton.setText("Fetch Response");
        this.fetchResponseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualRequestPanel.this.fetchResponseButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.fetchResponseButton);
        this.updateCookiesButton.setText("Update CookieJar");
        this.updateCookiesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualRequestPanel.this.updateCookiesButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.updateCookiesButton);
        this.add((Component)this.jPanel2, "South");
    }

    private void requestComboBoxActionPerformed(ActionEvent evt) {
        Object o = this.requestComboBox.getSelectedItem();
        if (o instanceof ConversationID) {
            ConversationID id = (ConversationID)o;
            Request request = this._model.getConversationModel().getRequest(id);
            this._manualRequest.setRequest(request);
        }
    }

    private void updateCookiesButtonActionPerformed(ActionEvent evt) {
        this._manualRequest.updateCookies();
    }

    private void getCookieButtonActionPerformed(ActionEvent evt) {
        try {
            Request request = this._requestPanel.getRequest();
            if (request != null && request.getURL() != null) {
                this._manualRequest.setRequest(request);
                this._manualRequest.addRequestCookies();
            }
        }
        catch (MalformedURLException mue) {
            JOptionPane.showMessageDialog(this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, new String[]{"The request is malformed", pe.getMessage()}, "Malformed Request", 0);
        }
    }

    private void fetchResponseButtonActionPerformed(ActionEvent evt) {
        try {
            Request request = this._requestPanel.getRequest();
            this.fetchResponse(request);
        }
        catch (MalformedURLException mue) {
            JOptionPane.showMessageDialog(this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, new String[]{"The request is malformed", pe.getMessage()}, "Malformed Request", 0);
        }
    }

    private void fetchResponse(Request request) {
        if (request != null) {
            this._requestPanel.setEnabled(false);
            this.fetchResponseButton.setEnabled(false);
            this.updateCookiesButton.setEnabled(false);
            this.getCookieButton.setEnabled(false);
            this._manualRequest.setRequest(request);
            new SwingWorker(){

                public Object construct() {
                    try {
                        ManualRequestPanel.this._manualRequest.fetchResponse();
                        return null;
                    }
                    catch (Exception e) {
                        return e;
                    }
                }

                public void finished() {
                    Object obj = this.getValue();
                    if (obj != null) {
                        Exception e = (Exception)obj;
                        JOptionPane.showMessageDialog(null, new String[]{"Error fetching response: ", e.toString()}, "Error", 0);
                        ManualRequestPanel.this._logger.severe("Exception fetching response: " + e);
                        e.printStackTrace();
                    }
                    ManualRequestPanel.this.fetchResponseButton.setEnabled(true);
                    ManualRequestPanel.this.updateCookiesButton.setEnabled(true);
                    ManualRequestPanel.this.getCookieButton.setEnabled(true);
                    ManualRequestPanel.this._requestPanel.setEnabled(true);
                }
            }.start();
        } else {
            this._logger.severe("Can't fetch a null request");
        }
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return new String("Manual Request");
    }

    public Action[] getConversationActions() {
        return null;
    }

    public Action[] getUrlActions() {
        return null;
    }

    public void requestChanged(Request request) {
        this._reqUpdater.setRequest(request);
    }

    public void responseChanged(Response response) {
        this._respUpdater.setResponse(response);
    }

    public void setEnabled(final boolean enabled) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.fetchResponseButton.setEnabled(enabled);
            this.getCookieButton.setEnabled(enabled);
            this.updateCookiesButton.setEnabled(enabled);
            this.requestComboBox.setEnabled(enabled);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ManualRequestPanel.this.setEnabled(enabled);
                }
            });
        }
    }

    public ColumnDataModel[] getConversationColumns() {
        return null;
    }

    public ColumnDataModel[] getUrlColumns() {
        return null;
    }

    private class ResponseUpdater
    implements Runnable {
        private Response _resp;

        private ResponseUpdater() {
        }

        public void setResponse(Response response) {
            this._resp = response;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception e) {
                    ManualRequestPanel.this._logger.info("Exception " + e);
                }
            }
        }

        public void run() {
            ManualRequestPanel.this._responsePanel.setEditable(false);
            ManualRequestPanel.this._responsePanel.setResponse(this._resp);
        }
    }

    private class RequestUpdater
    implements Runnable {
        private Request _req;

        private RequestUpdater() {
        }

        public void setRequest(Request request) {
            this._req = request;
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(this);
                }
                catch (Exception e) {
                    ManualRequestPanel.this._logger.info("Exception " + e);
                }
            }
        }

        public void run() {
            ManualRequestPanel.this._requestPanel.setEditable(true);
            ManualRequestPanel.this._requestPanel.setRequest(this._req);
        }
    }
}

