/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;

public class BrowserCache
extends ProxyPlugin {
    private boolean _enabled = false;

    public BrowserCache() {
        this.parseProperties();
    }

    public void parseProperties() {
        String prop = "BrowserCache.enabled";
        String value = Preferences.getPreference(prop, "false");
        this._enabled = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public String getPluginName() {
        return new String("Browser Cache");
    }

    public void setEnabled(boolean bool) {
        this._enabled = bool;
        String prop = "BrowserCache.enabled";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient _in;

        public Plugin(HTTPClient in) {
            this._in = in;
        }

        public Response fetchResponse(Request request) throws IOException {
            if (BrowserCache.this._enabled) {
                request.deleteHeader("ETag");
                request.deleteHeader("If-Modified-Since");
                request.deleteHeader("If-None-Match");
            }
            return this._in.fetchResponse(request);
        }
    }
}

