/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.owasp.webscarab.model.HttpUrl;

public class ListenerSpec
implements Comparable {
    private String _address;
    private int _port;
    private HttpUrl _base = null;
    private boolean _primaryProxy = false;
    private InetSocketAddress _sockAddr = null;

    public ListenerSpec(String address, int port, HttpUrl base, boolean primaryProxy) {
        if (address == null) {
            address = "*";
        }
        this._address = address;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port must be between 0 and 65536");
        }
        this._port = port;
        this._base = base;
        this._primaryProxy = primaryProxy;
    }

    public String getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public HttpUrl getBase() {
        return this._base;
    }

    public boolean isPrimaryProxy() {
        return this._primaryProxy;
    }

    public String getKey() {
        return this._address + ":" + this._port;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this._address + ":" + this._port + (this._base != null ? " => " + this._base : "") + (this._primaryProxy ? " Primary" : "");
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public InetSocketAddress getInetSocketAddress() {
        if (this._sockAddr == null) {
            this._sockAddr = new InetSocketAddress(this._address, this._port);
        }
        return this._sockAddr;
    }

    public void verifyAvailable() throws IOException {
        InetSocketAddress sa = this.getInetSocketAddress();
        ServerSocket serversocket = new ServerSocket(sa.getPort(), 5, sa.getAddress());
        serversocket.close();
    }

    public int compareTo(Object o) {
        return this.toString().compareTo(o.toString());
    }
}

