/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.webscarab.httpclient.HTTPClient;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.ProxyPlugin;

public class RevealHidden
extends ProxyPlugin {
    private boolean _enabled = false;

    public RevealHidden() {
        this.parseProperties();
    }

    public void parseProperties() {
        String prop = "RevealHidden.enabled";
        String value = Preferences.getPreference(prop, "false");
        this._enabled = "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    public String getPluginName() {
        return new String("Reveal Hidden");
    }

    public void setEnabled(boolean bool) {
        this._enabled = bool;
        String prop = "RevealHidden.enabled";
        Preferences.setPreference(prop, Boolean.toString(bool));
    }

    public boolean getEnabled() {
        return this._enabled;
    }

    public HTTPClient getProxyPlugin(HTTPClient in) {
        return new Plugin(in);
    }

    private class Plugin
    implements HTTPClient {
        private HTTPClient _in;

        public Plugin(HTTPClient in) {
            this._in = in;
        }

        public Response fetchResponse(Request request) throws IOException {
            byte[] content;
            String ct;
            Response response = this._in.fetchResponse(request);
            if (RevealHidden.this._enabled && (ct = response.getHeader("Content-Type")) != null && ct.matches("text/.*") && (content = response.getContent()) != null) {
                response.setContent(this.revealHidden(content));
                response.addHeader("X-RevealHidden", "possibly modified");
            }
            return response;
        }

        private byte[] revealHidden(byte[] content) {
            Pattern inputPattern = Pattern.compile("(<input.+?type\\s*=\\s*[\"']{0,1})hidden([\"']{0,1}.+?>)", 2);
            Matcher inputMatcher = inputPattern.matcher(new String(content));
            StringBuffer outbuf = new StringBuffer();
            while (inputMatcher.find()) {
                String input = inputMatcher.group();
                String name = "noname";
                Pattern namePattern = Pattern.compile("name=[\"']{0,1}(\\w+)[\"']{0,1}", 2);
                Matcher nameMatcher = namePattern.matcher(input);
                if (nameMatcher.find() && nameMatcher.groupCount() == 1) {
                    name = nameMatcher.group(1);
                }
                input = inputMatcher.group(1) + "text" + inputMatcher.group(2);
                inputMatcher.appendReplacement(outbuf, this.constructReplacement(name, input));
            }
            inputMatcher.appendTail(outbuf);
            return outbuf.toString().getBytes();
        }

        private String constructReplacement(String name, String input) {
            StringBuffer result = new StringBuffer();
            result.append("<div style=\"background: pink; border: red 1px solid; padding: 2px; margin:4px; text-align: left;\">");
            result.append("<p style=\"color: red; text-align: left; margin-top: 0px; font-size: xx-small;\">Hidden Input Field</p>");
            result.append("<p style=\"text-align: center; color: black; margin: 0px; font-size: normal;\">");
            result.append("[").append(name).append("]").append("&nbsp;").append(input);
            result.append("</p>");
            result.append("<p style=\"color: red; text-align: right; margin-bottom: 0px; font-size: xx-small;\">Revealed by WebScarab</p>");
            result.append("</div>");
            return result.toString();
        }
    }
}

