/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import bsh.EvalError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintStream;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.owasp.webscarab.plugin.proxy.BeanShell;
import org.owasp.webscarab.plugin.proxy.BeanShellUI;
import org.owasp.webscarab.plugin.proxy.swing.ProxyPluginUI;
import org.owasp.webscarab.util.swing.DocumentOutputStream;

public class BeanShellPanel
extends JPanel
implements ProxyPluginUI,
BeanShellUI {
    private static final long serialVersionUID = 5073008807690179538L;
    private BeanShell _beanShell;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private DocumentOutputStream _dos;
    private PrintStream _docStream;
    private JButton commitButton;
    private JCheckBox enableCheckBox;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea logTextArea;
    private JPanel scriptPanel;
    private JTextArea scriptTextArea;

    public BeanShellPanel(BeanShell beanShell) {
        this._beanShell = beanShell;
        this.initComponents();
        this.scriptTextArea.registerKeyboardAction(new AutoIndentAction(), KeyStroke.getKeyStroke(10, 0), 0);
        this.configure();
        this._beanShell.setUI(this);
    }

    public String getPluginName() {
        return new String("Bean Shell");
    }

    public void configure() {
        boolean enabled = this._beanShell.getEnabled();
        this.enableCheckBox.setSelected(enabled);
        this.scriptTextArea.setEnabled(enabled);
        this.scriptTextArea.setText(this._beanShell.getScript());
        this.commitButton.setEnabled(enabled);
        this._dos = new DocumentOutputStream(10240);
        this._docStream = new PrintStream(this._dos);
        this.logTextArea.setDocument(this._dos.getDocument());
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.scriptPanel = new JPanel();
        this.enableCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.scriptTextArea = new JTextArea();
        this.commitButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.logTextArea = new JTextArea();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setResizeWeight(0.8);
        this.scriptPanel.setLayout(new GridBagLayout());
        this.enableCheckBox.setText("Enabled : ");
        this.enableCheckBox.setHorizontalTextPosition(10);
        this.enableCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellPanel.this.enableCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.scriptPanel.add((Component)this.enableCheckBox, gridBagConstraints);
        this.scriptTextArea.setFont(new Font("Monospaced", 0, 14));
        this.scriptTextArea.setMargin(new Insets(5, 5, 5, 5));
        this.jScrollPane1.setViewportView(this.scriptTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.scriptPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.commitButton.setText("Commit");
        this.commitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanShellPanel.this.commitButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        this.scriptPanel.add((Component)this.commitButton, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.scriptPanel);
        this.jPanel1.setLayout(new BorderLayout());
        this.logTextArea.setBackground(new Color(204, 204, 204));
        this.logTextArea.setEditable(false);
        this.jScrollPane2.setViewportView(this.logTextArea);
        this.jPanel1.add((Component)this.jScrollPane2, "Center");
        this.jSplitPane1.setRightComponent(this.jPanel1);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void commitButtonActionPerformed(ActionEvent evt) {
        try {
            this._beanShell.setScript(this.scriptTextArea.getText());
        }
        catch (EvalError ee) {
            this._logger.severe("Script error: " + ee);
        }
    }

    private void enableCheckBoxActionPerformed(ActionEvent evt) {
        boolean enabled = this.enableCheckBox.isSelected();
        this._beanShell.setEnabled(enabled);
        this.scriptTextArea.setEnabled(enabled);
        this.commitButton.setEnabled(enabled);
    }

    public JPanel getPanel() {
        return this;
    }

    public PrintStream getErr() {
        return this._docStream;
    }

    public PrintStream getOut() {
        return this._docStream;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.commitButton.setEnabled(enabled);
        this.enableCheckBox.setEnabled(enabled);
        this.scriptTextArea.setEnabled(enabled && this.enableCheckBox.isSelected());
    }

    private static class AutoIndentAction
    extends AbstractAction {
        private static final long serialVersionUID = 4742439629762409215L;

        private AutoIndentAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            JTextArea comp = (JTextArea)ae.getSource();
            Document doc = comp.getDocument();
            if (!comp.isEditable()) {
                return;
            }
            try {
                int line = comp.getLineOfOffset(comp.getCaretPosition());
                int start = comp.getLineStartOffset(line);
                int end = comp.getLineEndOffset(line);
                String str = doc.getText(start, end - start - 1);
                String whiteSpace = this.getLeadingWhiteSpace(str);
                doc.insertString(comp.getCaretPosition(), '\n' + whiteSpace, null);
            }
            catch (BadLocationException ex) {
                try {
                    doc.insertString(comp.getCaretPosition(), "\n", null);
                }
                catch (BadLocationException ignore) {
                    // empty catch block
                }
            }
        }

        private String getLeadingWhiteSpace(String str) {
            return str.substring(0, this.getLeadingWhiteSpaceWidth(str));
        }

        private int getLeadingWhiteSpaceWidth(String str) {
            char ch;
            int whitespace;
            for (whitespace = 0; whitespace < str.length() && ((ch = str.charAt(whitespace)) == ' ' || ch == '\t'); ++whitespace) {
            }
            return whitespace;
        }
    }
}

