/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.ui.swing.RequestPanel;
import org.owasp.webscarab.ui.swing.ResponsePanel;

public class ManualEditFrame
extends JFrame {
    private static final long serialVersionUID = -8237270407615405475L;
    private static boolean _cancelAll = false;
    private static Object _lock = new Object();
    private boolean _done = false;
    private Request _request = null;
    private RequestPanel _requestPanel = null;
    private Response _response = null;
    private ResponsePanel _responsePanel = null;
    private JButton abortButton;
    private JButton acceptButton;
    private JButton cancelAllButton;
    private JButton cancelButton;
    private JSplitPane contentSplitPane;
    private JCheckBox interceptRequestCheckBox;
    private JCheckBox interceptResponseCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;

    public ManualEditFrame() {
        this.initComponents();
        this.setPreferredSize();
        this._requestPanel = new RequestPanel();
        this.contentSplitPane.setTopComponent(this._requestPanel);
        this._responsePanel = new ResponsePanel();
        this.contentSplitPane.setBottomComponent(this._responsePanel);
        this.getRootPane().setDefaultButton(this.acceptButton);
        this.installShortcuts();
    }

    private void installShortcuts() {
        AbstractAction toggleRequest = new AbstractAction(){
            private static final long serialVersionUID = 4660900260023719510L;

            public void actionPerformed(ActionEvent e) {
                ManualEditFrame.this.interceptRequestCheckBox.doClick();
            }
        };
        KeyStroke toggleRequestKey = KeyStroke.getKeyStroke(81, 10);
        this.getRootPane().registerKeyboardAction(toggleRequest, "TOGGLEREQUEST", toggleRequestKey, 2);
        AbstractAction toggleResponse = new AbstractAction(){
            private static final long serialVersionUID = 5909538388895326161L;

            public void actionPerformed(ActionEvent e) {
                ManualEditFrame.this.interceptResponseCheckBox.doClick();
            }
        };
        KeyStroke toggleResponseKey = KeyStroke.getKeyStroke(83, 10);
        this.getRootPane().registerKeyboardAction(toggleResponse, "TOGGLERESPONSE", toggleResponseKey, 2);
    }

    public void setInterceptModels(ButtonModel interceptRequest, ButtonModel interceptResponse) {
        this.interceptRequestCheckBox.setModel(interceptRequest);
        this.interceptRequestCheckBox.setEnabled(true);
        this.interceptRequestCheckBox.setVisible(true);
        this.interceptResponseCheckBox.setModel(interceptResponse);
        this.interceptResponseCheckBox.setEnabled(true);
        this.interceptResponseCheckBox.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request editRequest(Request request) {
        Object object = _lock;
        synchronized (object) {
            _cancelAll = false;
            this._done = false;
            this._request = request;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ManualEditFrame.this._requestPanel.setEditable(true);
                    ManualEditFrame.this._requestPanel.setRequest(ManualEditFrame.this._request);
                    ManualEditFrame.this._responsePanel.setEditable(false);
                    ManualEditFrame.this._responsePanel.setResponse(null);
                    ManualEditFrame.this.setVisible(true);
                    ManualEditFrame.this.toFront();
                    ManualEditFrame.this.requestFocus();
                    ManualEditFrame.this.contentSplitPane.setDividerLocation(1.0);
                }
            });
            do {
                try {
                    _lock.wait();
                }
                catch (InterruptedException ie) {
                    System.out.println("Wait interrupted");
                }
            } while (!_cancelAll && !this._done);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ManualEditFrame.this.setVisible(false);
                    ManualEditFrame.this.dispose();
                }
            });
            return this._request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response editResponse(final Request request, Response response) {
        Object object = _lock;
        synchronized (object) {
            _cancelAll = false;
            this._done = false;
            this._response = response;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ManualEditFrame.this._requestPanel.setEditable(false);
                    ManualEditFrame.this._requestPanel.setRequest(request);
                    ManualEditFrame.this._responsePanel.setEditable(true);
                    ManualEditFrame.this._responsePanel.setResponse(ManualEditFrame.this._response);
                    ManualEditFrame.this.setVisible(true);
                    ManualEditFrame.this.toFront();
                    ManualEditFrame.this.requestFocus();
                    ManualEditFrame.this.contentSplitPane.setDividerLocation(0.3);
                }
            });
            do {
                try {
                    _lock.wait();
                }
                catch (InterruptedException ie) {
                    System.out.println("Wait interrupted");
                }
            } while (!_cancelAll && !this._done);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ManualEditFrame.this.setVisible(false);
                    ManualEditFrame.this.dispose();
                }
            });
            return this._response;
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.acceptButton = new JButton();
        this.cancelButton = new JButton();
        this.abortButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.cancelAllButton = new JButton();
        this.jPanel2 = new JPanel();
        this.interceptRequestCheckBox = new JCheckBox();
        this.interceptResponseCheckBox = new JCheckBox();
        this.contentSplitPane = new JSplitPane();
        this.setTitle("Intercept");
        this.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                ManualEditFrame.this.formComponentMoved(evt);
            }

            public void componentResized(ComponentEvent evt) {
                ManualEditFrame.this.formComponentResized(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ManualEditFrame.this.exitForm(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.acceptButton.setText("Accept changes");
        this.acceptButton.setToolTipText("Accepts any changes made to this conversation");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditFrame.this.acceptButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.acceptButton, new GridBagConstraints());
        this.cancelButton.setText("Cancel changes");
        this.cancelButton.setToolTipText("Cancels any changes made to this conversation");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditFrame.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.cancelButton, new GridBagConstraints());
        this.abortButton.setText("Abort request");
        this.abortButton.setToolTipText("Prevents this request from being sent to the server. Returns an error to the browser");
        this.abortButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditFrame.this.abortButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.abortButton, new GridBagConstraints());
        this.jSeparator1.setOrientation(1);
        this.jSeparator1.setMinimumSize(new Dimension(20, 0));
        this.jSeparator1.setPreferredSize(new Dimension(20, 0));
        this.jPanel1.add((Component)this.jSeparator1, new GridBagConstraints());
        this.cancelAllButton.setText("Cancel ALL intercepts");
        this.cancelAllButton.setToolTipText("Cancels any pending changes, and allows intercepted conversations to proceed");
        this.cancelAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditFrame.this.cancelAllButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add((Component)this.cancelAllButton, new GridBagConstraints());
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.interceptRequestCheckBox.setText("Intercept requests : ");
        this.interceptRequestCheckBox.setHorizontalTextPosition(10);
        this.interceptRequestCheckBox.setEnabled(false);
        this.jPanel2.add(this.interceptRequestCheckBox);
        this.interceptResponseCheckBox.setText("Intercept responses : ");
        this.interceptResponseCheckBox.setHorizontalTextPosition(10);
        this.interceptResponseCheckBox.setEnabled(false);
        this.jPanel2.add(this.interceptResponseCheckBox);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.contentSplitPane.setOrientation(0);
        this.contentSplitPane.setResizeWeight(0.5);
        this.contentSplitPane.setOneTouchExpandable(true);
        this.getContentPane().add((Component)this.contentSplitPane, "Center");
        this.pack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAllButtonActionPerformed(ActionEvent evt) {
        _cancelAll = true;
        this._done = true;
        Object object = _lock;
        synchronized (object) {
            _lock.notifyAll();
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        Preferences.getPreferences().setProperty("ManualEditFrame.size.x", Integer.toString(this.getWidth()));
        Preferences.getPreferences().setProperty("ManualEditFrame.size.y", Integer.toString(this.getHeight()));
    }

    private void formComponentMoved(ComponentEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        Preferences.getPreferences().setProperty("ManualEditFrame.position.x", Integer.toString(this.getX()));
        Preferences.getPreferences().setProperty("ManualEditFrame.position.y", Integer.toString(this.getY()));
    }

    private void setPreferredSize() {
        try {
            int xpos = Integer.parseInt(Preferences.getPreference("ManualEditFrame.position.x").trim());
            int ypos = Integer.parseInt(Preferences.getPreference("ManualEditFrame.position.y").trim());
            int width = Integer.parseInt(Preferences.getPreference("ManualEditFrame.size.x").trim());
            int height = Integer.parseInt(Preferences.getPreference("ManualEditFrame.size.y").trim());
            this.setBounds(xpos, ypos, width, height);
        }
        catch (NumberFormatException nfe) {
            this.setSize(800, 600);
        }
        catch (NullPointerException npe) {
            this.setSize(800, 600);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortButtonActionPerformed(ActionEvent evt) {
        this._done = true;
        this._request = null;
        this._response = null;
        Object object = _lock;
        synchronized (object) {
            _lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptButtonActionPerformed(ActionEvent evt) {
        try {
            if (this._response != null) {
                this._response = this._responsePanel.getResponse();
            } else if (this._request != null) {
                this._request = this._requestPanel.getRequest();
            }
            this._done = true;
            Object object = _lock;
            synchronized (object) {
                _lock.notifyAll();
            }
        }
        catch (MalformedURLException mue) {
            JOptionPane.showMessageDialog(this, new String[]{"The URL requested is malformed", mue.getMessage()}, "Malformed URL", 0);
        }
        catch (ParseException pe) {
            JOptionPane.showMessageDialog(this, new String[]{"The request is malformed", pe.getMessage()}, "Malformed Request", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelButtonActionPerformed(ActionEvent evt) {
        this._done = true;
        Object object = _lock;
        synchronized (object) {
            _lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitForm(WindowEvent evt) {
        this._done = true;
        Object object = _lock;
        synchronized (object) {
            _lock.notifyAll();
        }
    }
}

