/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.proxy.ManualEdit;
import org.owasp.webscarab.plugin.proxy.ManualEditUI;
import org.owasp.webscarab.plugin.proxy.swing.ManualEditFrame;
import org.owasp.webscarab.plugin.proxy.swing.ProxyPluginUI;

public class ManualEditPanel
extends JPanel
implements ProxyPluginUI,
ManualEditUI {
    private static final long serialVersionUID = 4874553823942170256L;
    private ManualEdit _manualEdit;
    private ButtonModel _requestButtonModel;
    private ButtonModel _responseButtonModel;
    private JLabel interceptExcludeLabel;
    private JTextField interceptExcludeRegexTextField;
    private JLabel interceptIncludeLabel;
    private JTextField interceptIncludeRegexTextField;
    private JList interceptMethodList;
    private JCheckBox interceptRequestCheckBox;
    private JCheckBox interceptResponseCheckBox;
    private JPanel interceptResponsePanel;
    private JTextField interceptResponseTextField;
    private JPanel interceptrequestPanel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane3;
    private JCheckBox sensitiveCheckBox;

    public ManualEditPanel(ManualEdit manualEdit) {
        this._manualEdit = manualEdit;
        this.initComponents();
        this._requestButtonModel = this.interceptRequestCheckBox.getModel();
        this._requestButtonModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean enabled = ManualEditPanel.this.interceptRequestCheckBox.isSelected();
                ManualEditPanel.this.interceptIncludeRegexTextField.setEnabled(ManualEditPanel.this.isEnabled() && enabled);
                ManualEditPanel.this.interceptExcludeRegexTextField.setEnabled(ManualEditPanel.this.isEnabled() && enabled);
                ManualEditPanel.this.interceptMethodList.setEnabled(ManualEditPanel.this.isEnabled() && enabled);
                ManualEditPanel.this._manualEdit.setInterceptRequest(enabled);
            }
        });
        this._responseButtonModel = this.interceptResponseCheckBox.getModel();
        this._responseButtonModel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean enabled = ManualEditPanel.this.interceptResponseCheckBox.isSelected();
                ManualEditPanel.this.interceptResponseTextField.setEnabled(ManualEditPanel.this.isEnabled() && enabled);
                ManualEditPanel.this._manualEdit.setInterceptResponse(enabled);
            }
        });
        this.configure();
        this.interceptMethodList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ManualEditPanel.this.interceptMethodListValueChanged(evt);
            }
        });
        this._manualEdit.setUI(this);
        this.addHierarchyListener(new HierarchyListener(){

            public void hierarchyChanged(HierarchyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        ManualEditPanel.this.installShortcuts();
                    }
                });
                ManualEditPanel.this.removeHierarchyListener(this);
            }
        });
    }

    private void installShortcuts() {
        AbstractAction toggleRequest = new AbstractAction(){
            private static final long serialVersionUID = -9087215230742742495L;

            public void actionPerformed(ActionEvent e) {
                System.out.println("Toggle request");
                ManualEditPanel.this.interceptRequestCheckBox.doClick();
            }
        };
        KeyStroke toggleRequestKey = KeyStroke.getKeyStroke(81, 10);
        SwingUtilities.getRootPane(this).registerKeyboardAction(toggleRequest, "TOGGLEREQUEST", toggleRequestKey, 2);
        AbstractAction toggleResponse = new AbstractAction(){
            private static final long serialVersionUID = 6167233061339024122L;

            public void actionPerformed(ActionEvent e) {
                System.out.println("Toggle response");
                ManualEditPanel.this.interceptResponseCheckBox.doClick();
            }
        };
        KeyStroke toggleResponseKey = KeyStroke.getKeyStroke(83, 10);
        SwingUtilities.getRootPane(this).registerKeyboardAction(toggleResponse, "TOGGLERESPONSE", toggleResponseKey, 2);
    }

    public String getPluginName() {
        return new String("Manual Edit");
    }

    public void configure() {
        boolean enabled = this._manualEdit.getInterceptRequest();
        this.interceptRequestCheckBox.setSelected(enabled);
        this.sensitiveCheckBox.setSelected(this._manualEdit.isCaseSensitive());
        this.interceptIncludeRegexTextField.setEnabled(this.isEnabled() && enabled);
        this.interceptIncludeRegexTextField.setText(this._manualEdit.getIncludeRegex());
        this.interceptExcludeRegexTextField.setEnabled(this.isEnabled() && enabled);
        this.interceptExcludeRegexTextField.setText(this._manualEdit.getExcludeRegex());
        this.interceptMethodList.setEnabled(this.isEnabled() && enabled);
        String[] interceptMethods = this._manualEdit.getInterceptMethods();
        this.interceptMethodList.setSelectedIndices(this.getIndices(interceptMethods, this.interceptMethodList.getModel()));
        enabled = this._manualEdit.getInterceptResponse();
        this.interceptResponseTextField.setEnabled(this.isEnabled() && enabled);
        this.interceptResponseCheckBox.setSelected(this._manualEdit.getInterceptResponse());
        this.interceptResponseTextField.setText(this._manualEdit.getInterceptResponseRegex());
    }

    private int[] getIndices(String[] items, ListModel model) {
        int[] indices = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            boolean found = false;
            for (int j = 0; j < model.getSize(); ++j) {
                if (!items[i].equals(model.getElementAt(j))) continue;
                indices[i] = j;
                found = true;
            }
            if (found) continue;
            indices[i] = -1;
            System.err.println("Did not find item[" + i + "] == '" + items[i] + "' in the list model");
        }
        return indices;
    }

    private void initComponents() {
        this.interceptrequestPanel = new JPanel();
        this.interceptRequestCheckBox = new JCheckBox();
        this.sensitiveCheckBox = new JCheckBox();
        this.interceptIncludeLabel = new JLabel();
        this.interceptIncludeRegexTextField = new JTextField();
        this.interceptExcludeLabel = new JLabel();
        this.interceptExcludeRegexTextField = new JTextField();
        this.jScrollPane3 = new JScrollPane();
        this.interceptMethodList = new JList();
        this.interceptResponsePanel = new JPanel();
        this.interceptResponseCheckBox = new JCheckBox();
        this.interceptResponseTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.interceptrequestPanel.setLayout(new GridBagLayout());
        this.interceptRequestCheckBox.setText("Intercept requests : ");
        this.interceptRequestCheckBox.setToolTipText("Use Ctrl-Alt Q to toggle");
        this.interceptRequestCheckBox.setHorizontalTextPosition(10);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.interceptrequestPanel.add((Component)this.interceptRequestCheckBox, gridBagConstraints);
        this.sensitiveCheckBox.setText("Case Sensitive Regular Expressions ?");
        this.sensitiveCheckBox.setHorizontalTextPosition(10);
        this.sensitiveCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditPanel.this.sensitiveCheckBoxActionPerformed(evt);
            }
        });
        this.interceptrequestPanel.add((Component)this.sensitiveCheckBox, new GridBagConstraints());
        this.interceptIncludeLabel.setText("Include Paths matching : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.interceptrequestPanel.add((Component)this.interceptIncludeLabel, gridBagConstraints);
        this.interceptIncludeRegexTextField.setToolTipText("Use a regular expression to select which URLs to intercept. Leave blank to ignore.");
        this.interceptIncludeRegexTextField.setEnabled(false);
        this.interceptIncludeRegexTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditPanel.this.interceptIncludeRegexTextFieldActionPerformed(evt);
            }
        });
        this.interceptIncludeRegexTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ManualEditPanel.this.interceptIncludeRegexTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.interceptrequestPanel.add((Component)this.interceptIncludeRegexTextField, gridBagConstraints);
        this.interceptExcludeLabel.setText("Exclude paths matching : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.interceptrequestPanel.add((Component)this.interceptExcludeLabel, gridBagConstraints);
        this.interceptExcludeRegexTextField.setToolTipText("Use a regular expression to select which URLs not to intercept. Leave blank to ignore.");
        this.interceptExcludeRegexTextField.setEnabled(false);
        this.interceptExcludeRegexTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditPanel.this.interceptExcludeRegexTextFieldActionPerformed(evt);
            }
        });
        this.interceptExcludeRegexTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                ManualEditPanel.this.interceptExcludeRegexTextFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.interceptrequestPanel.add((Component)this.interceptExcludeRegexTextField, gridBagConstraints);
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setViewportBorder(BorderFactory.createTitledBorder("Methods"));
        this.jScrollPane3.setMinimumSize(new Dimension(100, 120));
        this.jScrollPane3.setPreferredSize(new Dimension(100, 120));
        this.jScrollPane3.setAutoscrolls(true);
        this.interceptMethodList.setModel(new AbstractListModel(){
            private static final long serialVersionUID = 2656664151003905524L;
            String[] strings = new String[]{"GET", "POST", "HEAD", "PUT", "DELETE", "TRACE", "PROPFIND", "OPTIONS", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "SEARCH", "SUBSCRIBE"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.interceptMethodList.setToolTipText("Select which request methods to intercept");
        this.interceptMethodList.setEnabled(false);
        this.interceptMethodList.setVisibleRowCount(0);
        this.jScrollPane3.setViewportView(this.interceptMethodList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 1.0;
        this.interceptrequestPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.interceptrequestPanel, gridBagConstraints);
        this.interceptResponsePanel.setLayout(new GridBagLayout());
        this.interceptResponseCheckBox.setText("Intercept responses : ");
        this.interceptResponseCheckBox.setToolTipText("Use Ctrl-Alt S to toggle");
        this.interceptResponseCheckBox.setHorizontalTextPosition(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.interceptResponsePanel.add((Component)this.interceptResponseCheckBox, gridBagConstraints);
        this.interceptResponseTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ManualEditPanel.this.interceptResponseTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.interceptResponsePanel.add((Component)this.interceptResponseTextField, gridBagConstraints);
        this.jLabel1.setText("Only MIME-Types matching :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.interceptResponsePanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.interceptResponsePanel, gridBagConstraints);
    }

    private void sensitiveCheckBoxActionPerformed(ActionEvent evt) {
        this._manualEdit.setCaseSensitive(this.sensitiveCheckBox.isSelected());
    }

    private void interceptResponseTextFieldActionPerformed(ActionEvent evt) {
        this._manualEdit.setInterceptResponseRegex(this.interceptResponseTextField.getText());
    }

    private void interceptExcludeRegexTextFieldFocusLost(FocusEvent evt) {
        this._manualEdit.setExcludeRegex(this.interceptExcludeRegexTextField.getText());
    }

    private void interceptExcludeRegexTextFieldActionPerformed(ActionEvent evt) {
        this._manualEdit.setExcludeRegex(this.interceptExcludeRegexTextField.getText());
    }

    private void interceptIncludeRegexTextFieldFocusLost(FocusEvent evt) {
        this._manualEdit.setIncludeRegex(this.interceptIncludeRegexTextField.getText());
    }

    private void interceptIncludeRegexTextFieldActionPerformed(ActionEvent evt) {
        this._manualEdit.setIncludeRegex(this.interceptIncludeRegexTextField.getText());
    }

    private void interceptMethodListValueChanged(ListSelectionEvent evt) {
        int[] indices = this.interceptMethodList.getSelectedIndices();
        String[] methods = new String[indices.length];
        ListModel lm = this.interceptMethodList.getModel();
        for (int i = 0; i < indices.length; ++i) {
            methods[i] = (String)lm.getElementAt(indices[i]);
        }
        this._manualEdit.setInterceptMethods(methods);
    }

    public JPanel getPanel() {
        return this;
    }

    public Request editRequest(Request request) {
        ManualEditFrame mef = new ManualEditFrame();
        mef.setTitle("Edit Request");
        mef.setInterceptModels(this.interceptRequestCheckBox.getModel(), this.interceptResponseCheckBox.getModel());
        return mef.editRequest(request);
    }

    public Response editResponse(Request request, Response response) {
        ManualEditFrame mef = new ManualEditFrame();
        mef.setTitle("Edit Response");
        mef.setInterceptModels(this.interceptRequestCheckBox.getModel(), this.interceptResponseCheckBox.getModel());
        return mef.editResponse(request, response);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.interceptRequestCheckBox.setEnabled(enabled);
        this.interceptResponseCheckBox.setEnabled(enabled);
        this.interceptMethodList.setEnabled(enabled && this.interceptRequestCheckBox.isSelected());
        this.interceptIncludeRegexTextField.setEnabled(enabled && this.interceptRequestCheckBox.isSelected());
        this.interceptExcludeRegexTextField.setEnabled(enabled && this.interceptRequestCheckBox.isSelected());
        this.interceptResponseTextField.setEnabled(enabled && this.interceptResponseCheckBox.isSelected());
    }
}

