/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.search.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.plugin.search.Search;
import org.owasp.webscarab.plugin.search.SearchModel;
import org.owasp.webscarab.ui.swing.ColumnWidthTracker;
import org.owasp.webscarab.ui.swing.ConversationTableModel;
import org.owasp.webscarab.ui.swing.DateRenderer;
import org.owasp.webscarab.ui.swing.ShowConversationAction;
import org.owasp.webscarab.ui.swing.SwingPluginUI;
import org.owasp.webscarab.util.swing.ColumnDataModel;
import org.owasp.webscarab.util.swing.SwingWorker;
import org.owasp.webscarab.util.swing.TableSorter;

public class SearchPanel
extends JPanel
implements SwingPluginUI {
    private static final long serialVersionUID = -594313478603602953L;
    private Search _search;
    private SearchModel _model;
    private ConversationModel _conversationModel;
    private DefaultComboBoxModel _searches = new DefaultComboBoxModel();
    private ShowConversationAction _showConversationAction;
    private TableSorter _conversationSorter;
    private JButton addButton;
    private JScrollPane conversationScrollPane;
    private JTable conversationTable;
    private JButton deleteButton;
    private JTextField descriptionTextField;
    private JTextArea expressionTextArea;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel3;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JButton reloadButton;
    private JPanel resultsPanel;
    private JComboBox searchComboBox;
    private JList searchList;
    private JPanel searchPanel;

    public SearchPanel(Search search) {
        this._search = search;
        this._model = search.getModel();
        this._conversationModel = this._model.getConversationModel();
        this.initComponents();
        this.searchList.setModel(this._searches);
        this.searchComboBox.setModel(this._searches);
        this._model.addPropertyChangeListener(new Listener());
        this.searchList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                Object selected = SearchPanel.this.searchList.getSelectedValue();
                String description = "";
                String expression = "";
                if (selected != null) {
                    description = (String)selected;
                    expression = SearchPanel.this._model.getSearchExpression(description);
                }
                SearchPanel.this.descriptionTextField.setText(description);
                SearchPanel.this.expressionTextArea.setText(expression);
            }
        });
        ConversationTableModel tm = new ConversationTableModel(this._conversationModel);
        this._conversationSorter = new TableSorter(tm, this.conversationTable.getTableHeader());
        this.conversationTable.setModel(this._conversationSorter);
        this.conversationTable.setDefaultRenderer(Date.class, new DateRenderer());
        ColumnWidthTracker.getTracker("ConversationTable").addTable(this.conversationTable);
        this._showConversationAction = new ShowConversationAction(this._model.getConversationModel());
        this.conversationTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    int row = SearchPanel.this.conversationTable.getSelectedRow();
                    row = SearchPanel.this._conversationSorter.modelIndex(row);
                    if (row > -1) {
                        ConversationID id = SearchPanel.this._conversationModel.getConversationAt(row);
                        SearchPanel.this._showConversationAction.putValue("CONVERSATION", id);
                        ActionEvent evt = new ActionEvent(SearchPanel.this.conversationTable, 0, (String)SearchPanel.this._showConversationAction.getValue("ActionCommandKey"));
                        SearchPanel.this._showConversationAction.actionPerformed(evt);
                    }
                }
            }
        });
        this.updateSearches();
    }

    private void updateSearches() {
        this._searches.removeAllElements();
        String[] searches = this._model.getSearches();
        for (int i = 0; i < searches.length; ++i) {
            this._searches.addElement(searches[i]);
        }
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.searchPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.searchList = new JList();
        this.jLabel1 = new JLabel();
        this.descriptionTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.jScrollPane4 = new JScrollPane();
        this.expressionTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.reloadButton = new JButton();
        this.resultsPanel = new JPanel();
        this.searchComboBox = new JComboBox();
        this.conversationScrollPane = new JScrollPane();
        this.conversationTable = new JTable();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.searchPanel.setLayout(new GridBagLayout());
        this.jLabel2.setText("Searches");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.searchPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane3.setPreferredSize(new Dimension(0, 0));
        this.searchList.setSelectionMode(0);
        this.jScrollPane3.setViewportView(this.searchList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.2;
        gridBagConstraints.weighty = 1.0;
        this.searchPanel.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel1.setText("Description");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.searchPanel.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.searchPanel.add((Component)this.descriptionTextField, gridBagConstraints);
        this.jLabel3.setText("Search Expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.searchPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane4.setMinimumSize(new Dimension(22, 44));
        this.jScrollPane4.setPreferredSize(new Dimension(0, 0));
        this.jScrollPane4.setViewportView(this.expressionTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.8;
        gridBagConstraints.weighty = 0.5;
        this.searchPanel.add((Component)this.jScrollPane4, gridBagConstraints);
        this.jPanel3.setLayout(new GridLayout(1, 0));
        this.addButton.setText("Add");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.addButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.addButton);
        this.deleteButton.setText("Delete");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.deleteButton);
        this.reloadButton.setText("Reload");
        this.reloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.reloadButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.reloadButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        this.searchPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.searchPanel);
        this.resultsPanel.setLayout(new BorderLayout());
        this.searchComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.searchComboBoxActionPerformed(evt);
            }
        });
        this.resultsPanel.add((Component)this.searchComboBox, "North");
        this.conversationTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.conversationTable.setAutoResizeMode(0);
        this.conversationScrollPane.setViewportView(this.conversationTable);
        this.resultsPanel.add((Component)this.conversationScrollPane, "Center");
        this.jSplitPane1.setRightComponent(this.resultsPanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void searchComboBoxActionPerformed(ActionEvent evt) {
        Object selected = this.searchComboBox.getSelectedItem();
        if (selected != null) {
            String description = (String)selected;
            this._search.setFilter(description);
        }
    }

    private void reloadButtonActionPerformed(ActionEvent evt) {
        Object selected = this.searchList.getSelectedValue();
        if (selected != null) {
            String description = (String)selected;
            this.reload(description);
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        Object selected = this.searchList.getSelectedValue();
        if (selected != null) {
            String description = (String)selected;
            this._search.removeSearch(description);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String description = this.descriptionTextField.getText();
        String expression = this.expressionTextArea.getText();
        if (!description.equals("") && !expression.equals("")) {
            this._search.addSearch(description, expression);
            this.reload(description);
            this.searchList.setSelectedValue(description, true);
            this.searchComboBox.setSelectedItem(description);
        }
    }

    private void reload(final String description) {
        this.addButton.setEnabled(false);
        this.deleteButton.setEnabled(false);
        this.reloadButton.setEnabled(false);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                System.err.println("Reloading " + description);
                SearchPanel.this._search.reload(description);
                return null;
            }

            public void finished() {
                SearchPanel.this.addButton.setEnabled(true);
                SearchPanel.this.deleteButton.setEnabled(true);
                SearchPanel.this.reloadButton.setEnabled(true);
            }
        };
        worker.start();
    }

    public Action[] getConversationActions() {
        return new Action[0];
    }

    public ColumnDataModel[] getConversationColumns() {
        return new ColumnDataModel[0];
    }

    public JPanel getPanel() {
        return this;
    }

    public String getPluginName() {
        return this._search.getPluginName();
    }

    public Action[] getUrlActions() {
        return new Action[0];
    }

    public ColumnDataModel[] getUrlColumns() {
        return new ColumnDataModel[0];
    }

    private class Listener
    implements PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("Searches")) {
                Runnable runner = new Runnable(){

                    public void run() {
                        SearchPanel.this.updateSearches();
                    }
                };
                this.runOnEDT(runner);
            }
        }

        private void runOnEDT(Runnable runner) {
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(runner);
                } else {
                    runner.run();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

