/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.sessionid;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.owasp.webscarab.plugin.sessionid.Calculator;
import org.owasp.webscarab.plugin.sessionid.SessionID;

public class DefaultCalculator
implements Calculator {
    private Pattern _pattern;
    private Map _cache = new HashMap();
    Logger _logger = Logger.getLogger(this.getClass().getName());
    private ArrayList _chars = new ArrayList();
    private BigInteger _min = null;
    private BigInteger _max = null;

    public DefaultCalculator() {
        this("^(.+)$");
    }

    public DefaultCalculator(String regex) {
        this._pattern = Pattern.compile(regex);
    }

    public boolean add(SessionID id) {
        String value = id.getValue();
        Matcher matcher = this._pattern.matcher(value);
        if (matcher.matches() && matcher.groupCount() >= 1) {
            value = matcher.group(1);
            return this.update(value);
        }
        System.err.println("value '" + value + "' did not match the pattern!");
        return false;
    }

    private boolean update(String value) {
        this._logger.fine("Value is '" + value + "'");
        boolean changed = false;
        for (int i = 0; i < value.length(); ++i) {
            char ch = value.charAt(value.length() - 1 - i);
            this._logger.fine("Working on position " + i + ", character '" + ch + "'");
            String set = null;
            if (this._chars.size() > i) {
                set = (String)this._chars.get(i);
            }
            if (set == null) {
                set = new String();
            }
            this._logger.fine("Character set was '" + set + "'");
            String updset = this.insertCharacter(set, ch);
            if (updset.equals(set)) continue;
            this._logger.fine("Character set is now '" + updset + "'");
            this.reset();
            if (this._chars.size() > i) {
                this._chars.set(i, updset);
            } else {
                this._chars.add(i, updset);
            }
            changed = true;
        }
        return changed;
    }

    private String insertCharacter(String set, char ch) {
        if (set.indexOf(ch) != -1) {
            return set;
        }
        char[] chars = set.toCharArray();
        int insert = -Arrays.binarySearch(chars, ch) - 1;
        StringBuffer buff = new StringBuffer();
        buff.append(chars, 0, insert);
        buff.append(ch);
        buff.append(chars, insert, chars.length - insert);
        return buff.toString();
    }

    public BigInteger calculate(SessionID id) {
        if (this._cache.containsKey(id)) {
            return (BigInteger)this._cache.get(id);
        }
        String value = id.getValue();
        Matcher matcher = this._pattern.matcher(value);
        if (!matcher.matches() || matcher.groupCount() < 1) {
            return BigInteger.ZERO;
        }
        value = matcher.group(1);
        BigInteger total = BigInteger.ZERO;
        BigInteger max = BigInteger.ONE;
        int length = value.length();
        this._logger.fine("Calculating '" + value + "'");
        for (int i = 0; i < length; ++i) {
            String charset = (String)this._chars.get(i);
            char ch = value.charAt(length - 1 - i);
            int pos = charset.indexOf(ch);
            this._logger.fine("Working on position " + i + ", character '" + ch + "'");
            this._logger.fine("pos is " + pos);
            BigInteger val = new BigInteger(Integer.toString(pos));
            total = total.add(val.multiply(max));
            max = max.multiply(new BigInteger(Integer.toString(charset.length())));
        }
        if (this._max == null || this._max.compareTo(total) < 0) {
            this._max = total;
        }
        if (this._min == null || this._min.compareTo(total) > 0) {
            this._min = total;
        }
        this._cache.put(id, total);
        return total;
    }

    public void reset() {
        this._cache.clear();
    }

    public BigInteger max() {
        return this._max;
    }

    public BigInteger min() {
        return this._min;
    }
}

