/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.sessionid;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.sessionid.SessionID;
import org.owasp.webscarab.plugin.sessionid.SessionIDStore;

public class FileSystemStore
implements SessionIDStore {
    private SortedMap _sessionIDs = new TreeMap();
    private File _dir;

    public FileSystemStore(File dir) throws StoreException {
        this._dir = dir;
        File f = new File(this._dir, "sessionids");
        if (f.exists()) {
            this.load();
        }
    }

    private void load() throws StoreException {
        File f = new File(this._dir, "sessionids");
        if (!f.isFile()) {
            return;
        }
        try {
            BufferedReader br = new BufferedReader(new FileReader(f));
            String key = br.readLine();
            while (key != null) {
                ArrayList<SessionID> list = new ArrayList<SessionID>();
                this._sessionIDs.put(key, list);
                String line = br.readLine();
                while (line != null && !line.equals("")) {
                    SessionID id = new SessionID(line);
                    list.add(id);
                    line = br.readLine();
                }
                key = br.readLine();
            }
        }
        catch (IOException ioe) {
            throw new StoreException("Error reading sessionids: " + ioe);
        }
    }

    public int addSessionID(String key, SessionID id) {
        int insert;
        ArrayList<SessionID> list = (ArrayList<SessionID>)this._sessionIDs.get(key);
        if (list == null) {
            list = new ArrayList<SessionID>();
            this._sessionIDs.put(key, list);
        }
        if ((insert = Collections.binarySearch(list, id)) < 0) {
            insert = -insert - 1;
        }
        list.add(insert, id);
        return insert;
    }

    public void clearSessionIDs(String key) {
        this._sessionIDs.remove(key);
    }

    public int getSessionIDNameCount() {
        return this._sessionIDs.size();
    }

    public String getSessionIDName(int index) {
        Iterator it = this._sessionIDs.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (index == 0) {
                return key;
            }
            --index;
        }
        return null;
    }

    public int getSessionIDCount(String key) {
        List list = (List)this._sessionIDs.get(key);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    public SessionID getSessionIDAt(String key, int index) {
        List list = (List)this._sessionIDs.get(key);
        if (list == null) {
            return null;
        }
        return (SessionID)list.get(index);
    }

    public void flush() throws StoreException {
        File f = new File(this._dir, "sessionids");
        if (f.exists() && !f.isFile()) {
            throw new StoreException("Couldn't create output file " + f);
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(f));
            Iterator it = this._sessionIDs.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                bw.write(key + "\r\n");
                List list = (List)this._sessionIDs.get(key);
                Iterator it2 = list.iterator();
                while (it2.hasNext()) {
                    SessionID id = (SessionID)it2.next();
                    bw.write(id.toString() + "\r\n");
                }
                bw.write("\r\n");
            }
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            throw new StoreException("IOException: " + ioe);
        }
    }
}

