/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.xsscrlf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.logging.Logger;
import org.owasp.webscarab.httpclient.ConversationHandler;
import org.owasp.webscarab.httpclient.FetcherQueue;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.NamedValue;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.xsscrlf.XSSCRLFModel;
import org.owasp.webscarab.util.Encoding;

public class XSSCRLF
implements Plugin,
ConversationHandler {
    private Framework _framework;
    private XSSCRLFModel _model;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private FetcherQueue _fetcherQueue = null;
    private int _threads = 4;
    private int _delay = 100;
    public static int MINLENGTH = 3;

    public XSSCRLF(Framework framework) {
        this._framework = framework;
        this._model = new XSSCRLFModel(framework.getModel());
    }

    public void analyse(ConversationID id, Request request, Response response, String origin) {
        byte[] requestContent;
        HttpUrl url = request.getURL();
        if (this._framework.getModel().getConversationOrigin(id).equals(this.getPluginName())) {
            return;
        }
        String contentType = response.getHeader("Content-Type");
        if (contentType == null) {
            return;
        }
        if (!contentType.matches("text/.*") && !contentType.equals("application/x-javascript")) {
            return;
        }
        byte[] responseContent = response.getContent();
        if (!(responseContent != null && responseContent.length != 0 || response.getStatus().startsWith("3"))) {
            return;
        }
        String responseBody = null;
        if (responseContent != null) {
            responseBody = new String(responseContent).toUpperCase();
        }
        NamedValue[] headers = response.getHeaders();
        NamedValue[] ucHeaders = new NamedValue[headers.length];
        for (int i = 0; i < headers.length; ++i) {
            ucHeaders[i] = new NamedValue(headers[i].getName().toUpperCase(), headers[i].getValue().toUpperCase());
        }
        String queryString = request.getURL().getQuery();
        if (queryString != null && queryString.length() > 0) {
            NamedValue[] params = NamedValue.splitNamedValues(queryString, "&", "=");
            this.checkParams(id, url, params, "GET", ucHeaders, responseBody);
        }
        if (request.getMethod().equals("POST") && "application/x-www-form-urlencoded".equals(contentType = request.getHeader("Content-Type")) && (requestContent = request.getContent()) != null && requestContent.length > 0) {
            String requestBody = new String(requestContent);
            NamedValue[] params = NamedValue.splitNamedValues(requestBody, "&", "=");
            this.checkParams(id, url, params, "POST", ucHeaders, responseBody);
        }
    }

    private void checkParams(ConversationID id, HttpUrl url, NamedValue[] params, String paramLocation, NamedValue[] headers, String body) {
        if (params == null) {
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            String value = params[i].getValue().toUpperCase();
            if (value.length() < MINLENGTH) continue;
            if (this.isInHeaders(value, headers)) {
                this._model.markAsCRLFSuspicious(id, url, paramLocation, params[i].getName());
            }
            if (body == null || body.indexOf(value) <= -1) continue;
            this._model.markAsXSSSuspicious(id, url, paramLocation, params[i].getName());
        }
    }

    private boolean isInHeaders(String expression, NamedValue[] headers) {
        if (expression.length() < MINLENGTH) {
            return false;
        }
        expression = Encoding.urlDecode(expression.toUpperCase());
        for (int i = 0; i < headers.length; ++i) {
            if (headers[i].getValue().toUpperCase().indexOf(expression) == -1 && headers[i].getName().toUpperCase().indexOf(expression) == -1) continue;
            return true;
        }
        return false;
    }

    public void flush() throws StoreException {
    }

    public String getPluginName() {
        return "XSS/CRLF";
    }

    public Object getScriptableObject() {
        return null;
    }

    public Hook[] getScriptingHooks() {
        return new Hook[0];
    }

    public String getStatus() {
        return this._model.getStatus();
    }

    public boolean isBusy() {
        return this._model.isBusy();
    }

    public boolean isModified() {
        return this._model.isModified();
    }

    public boolean isRunning() {
        return this._model.isRunning();
    }

    public void run() {
        this._model.setRunning(true);
        this._model.setStatus("Started");
        this._model.setStopping(false);
        this._fetcherQueue = new FetcherQueue(this.getPluginName(), this, this._threads, this._delay);
        this._model.setRunning(true);
        while (!this._model.isStopping()) {
            Request req = this._model.dequeueRequest();
            if (req == null) continue;
            this._fetcherQueue.submit(req);
        }
        this._model.setRunning(false);
        this._model.setStatus("Stopped");
    }

    public void responseReceived(Response response) {
        String body = new String(response.getContent());
        ConversationID id = null;
        if (body != null && body.length() >= this._model.getXSSTestString().length() && body.indexOf(this._model.getXSSTestString()) != -1) {
            this._logger.info("XSS - Possibly Vulnerable: " + response.getRequest().getURL());
            id = this._framework.addConversation(response.getRequest(), response, this.getPluginName());
            this._model.setXSSVulnerable(id, response.getRequest().getURL());
        }
        if (response.getHeader(this._model.getCRLFInjectedHeader()) != null) {
            this._logger.info("CRFL - Possibly Vulnerable: " + response.getRequest().getURL());
            if (id == null) {
                id = this._framework.addConversation(response.getRequest(), response, this.getPluginName());
            }
            this._model.setCRLFVulnerable(id, response.getRequest().getURL());
        }
    }

    public void requestError(Request request, IOException ioe) {
    }

    public void setSession(String type, Object store, String session) throws StoreException {
    }

    public boolean stop() {
        this._model.setRunning(false);
        return this._model.isRunning();
    }

    public XSSCRLFModel getModel() {
        return this._model;
    }

    public void stopChecks() {
        System.out.println("stopChecks()");
    }

    public synchronized String loadString(File file) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        BufferedReader input = new BufferedReader(new FileReader(file));
        while ((line = input.readLine()) != null) {
            buf.append(line);
        }
        return buf.toString();
    }

    public void checkSelected(ConversationID[] ids) {
        for (int j = 0; j < ids.length; ++j) {
            Request req = this._model.getRequest(ids[j]);
            this.checkConversation(ids[j], req, "GET");
            this.checkConversation(ids[j], req, "POST");
        }
    }

    private void checkConversation(ConversationID id, Request req, String where) {
        int i;
        String[] params = this._model.getCRLFSuspiciousParameters(id, where);
        if (params != null && params.length > 0) {
            for (i = 0; i < params.length; ++i) {
                this._logger.info("Testing for CRLF - Conversation ID: " + id + " Parameter:" + params[i]);
                this.submitCRLFTest(req, where, params[i]);
            }
        }
        if ((params = this._model.getXSSSuspiciousParameters(id, where)) != null && params.length > 0) {
            for (i = 0; i < params.length; ++i) {
                this._logger.info("Testing for XSS - Conversation ID: " + id + " Parameter:" + params[i]);
                this.submitXSSTest(req, "GET", params[i]);
            }
        }
    }

    private void submitXSSTest(Request origReq, String where, String param) {
        String testString = Encoding.urlEncode(this._model.getXSSTestString());
        Request req = new Request(origReq);
        req.setURL(this.getURLwithTestString(req.getURL(), param, testString));
        this._model.enqueueRequest(req, param);
    }

    private void submitCRLFTest(Request origReq, String where, String param) {
        String testString = this._model.getCRLFTestString();
        Request req = new Request(origReq);
        req.setURL(this.getURLwithTestString(req.getURL(), param, testString));
        this._model.enqueueRequest(req, param);
    }

    private HttpUrl getURLwithTestString(HttpUrl url, String name, String value) {
        StringBuffer buf = new StringBuffer("?");
        String querystring = url.getQuery();
        if (querystring == null) {
            return null;
        }
        NamedValue[] params = NamedValue.splitNamedValues(querystring, "&", "=");
        for (int i = 0; i < params.length; ++i) {
            if (params[i].getName().equals(name)) {
                buf.append(params[i].getName() + "=" + value);
            } else {
                buf.append(params[i].getName() + "=" + params[i].getValue());
            }
            if (i >= params.length - 1) continue;
            buf.append("&");
        }
        try {
            return new HttpUrl(url.getSHPP() + buf.toString());
        }
        catch (MalformedURLException e) {
            this._logger.info("Exception: " + e);
            return null;
        }
    }
}

