/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.xsscrlf;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FilteredConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.plugin.AbstractPluginModel;

public class XSSCRLFModel
extends AbstractPluginModel {
    private FrameworkModel _model;
    private ConversationModel _conversationModel;
    private ConversationModel _suspectedConversationModel;
    private LinkedList toBeAnalyzedQueue = new LinkedList();
    private Set testedURLandParameterpairs = new HashSet();
    private String xssTestString = "><script>a=/XSS BUG/; alert(a.source)</script>";
    private String crlfTestString = "%0d%0aWebscarabXSSCRLFTest:%20OK%0d%0a";
    private String crlfInjectedHeader = "WebscarabXSSCRLFTest";

    public XSSCRLFModel(FrameworkModel model) {
        this._model = model;
        this._conversationModel = new FilteredConversationModel(model, model.getConversationModel()){

            public boolean shouldFilter(ConversationID id) {
                return !XSSCRLFModel.this.isXSSVulnerable(id) && !XSSCRLFModel.this.isCRLFVulnerable(id);
            }
        };
        this._suspectedConversationModel = new FilteredConversationModel(model, model.getConversationModel()){

            public boolean shouldFilter(ConversationID id) {
                return !XSSCRLFModel.this.isCRLFSuspected(id) && !XSSCRLFModel.this.isXSSSuspected(id);
            }
        };
    }

    public ConversationModel getVulnerableConversationModel() {
        return this._conversationModel;
    }

    public ConversationModel getSuspectedConversationModel() {
        return this._suspectedConversationModel;
    }

    public void markAsXSSSuspicious(ConversationID id, HttpUrl url, String location, String parameter) {
        this._model.addConversationProperty(id, "XSS-" + location, parameter);
        this._model.addUrlProperty(url, "XSS-" + location, parameter);
    }

    public void markAsCRLFSuspicious(ConversationID id, HttpUrl url, String location, String parameter) {
        this._model.addConversationProperty(id, "CRLF-" + location, parameter);
        this._model.addUrlProperty(url, "CRLF-" + location, parameter);
    }

    public boolean isXSSSuspected(ConversationID id) {
        boolean suspect = false;
        suspect |= this._model.getConversationProperty(id, "XSS-GET") != null;
        return suspect |= this._model.getConversationProperty(id, "XSS-POST") != null;
    }

    public String getXSSSuspected(ConversationID id) {
        String params = this._model.getConversationProperty(id, "XSS-GET");
        if (params != null) {
            return params;
        }
        return this._model.getConversationProperty(id, "XSS-POST");
    }

    public boolean isCRLFSuspected(ConversationID id) {
        boolean suspect = false;
        suspect |= this._model.getConversationProperty(id, "CRLF-GET") != null;
        return suspect |= this._model.getConversationProperty(id, "CRLF-POST") != null;
    }

    public String getCRLFSuspected(ConversationID id) {
        String params = this._model.getConversationProperty(id, "CRLF-GET");
        if (params != null) {
            return params;
        }
        return this._model.getConversationProperty(id, "CRLF-POST");
    }

    public boolean isSuspected(HttpUrl url) {
        boolean suspect = false;
        suspect |= this._model.getUrlProperty(url, "XSS-GET") != null;
        suspect |= this._model.getUrlProperty(url, "XSS-POST") != null;
        suspect |= this._model.getUrlProperty(url, "CRLF-GET") != null;
        return suspect |= this._model.getUrlProperty(url, "CRLF-POST") != null;
    }

    public void setCRLFVulnerable(ConversationID id, HttpUrl url) {
        this._model.setUrlProperty(url, "CRLF", "TRUE");
        this._model.setConversationProperty(id, "CRLF", "TRUE");
    }

    public boolean isCRLFVulnerable(ConversationID id) {
        return "TRUE".equals(this._model.getConversationProperty(id, "CRLF"));
    }

    public boolean isCRLFVulnerable(HttpUrl url) {
        return "TRUE".equals(this._model.getUrlProperty(url, "CRLF"));
    }

    public void setXSSVulnerable(ConversationID id, HttpUrl url) {
        this._model.setUrlProperty(url, "XSS", "TRUE");
        this._model.setConversationProperty(id, "XSS", "TRUE");
    }

    public boolean isXSSVulnerable(ConversationID id) {
        return "TRUE".equals(this._model.getConversationProperty(id, "XSS"));
    }

    public boolean isXSSVulnerable(HttpUrl url) {
        return "TRUE".equals(this._model.getUrlProperty(url, "XSS"));
    }

    public String[] getCRLFSuspiciousParameters(ConversationID id, String where) {
        return this._model.getConversationProperties(id, "CRLF-" + where);
    }

    public String[] getXSSSuspiciousParameters(ConversationID id, String where) {
        return this._model.getConversationProperties(id, "XSS-" + where);
    }

    public String getXSSTestString() {
        return this.xssTestString;
    }

    public void setXSSTestString(String _xssTestString) {
        this.xssTestString = _xssTestString;
    }

    public String getCRLFTestString() {
        return this.crlfTestString;
    }

    public void setCRLFTestString(String _crlfTestString) {
        this.crlfTestString = _crlfTestString;
    }

    public String getCRLFInjectedHeader() {
        return this.crlfInjectedHeader;
    }

    public void setCRLFInjectedHeader(String _crlfInjectedHeader) {
        this.crlfInjectedHeader = _crlfInjectedHeader;
    }

    public Request getRequest(ConversationID id) {
        return this._model.getRequest(id);
    }

    public Response getResponse(ConversationID id) {
        return this._model.getResponse(id);
    }

    private boolean isTested(Request req, String vulnParam) {
        HttpUrl url = req.getURL();
        return this.testedURLandParameterpairs.contains(url.getSHPP() + vulnParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueRequest(Request req, String paramName) {
        LinkedList linkedList = this.toBeAnalyzedQueue;
        synchronized (linkedList) {
            if (!this.isTested(req, paramName)) {
                this.toBeAnalyzedQueue.addLast(req);
                this.toBeAnalyzedQueue.notifyAll();
                this.testedURLandParameterpairs.add(req.getURL().getSHPP() + paramName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request dequeueRequest() {
        LinkedList linkedList = this.toBeAnalyzedQueue;
        synchronized (linkedList) {
            try {
                while (this.toBeAnalyzedQueue.isEmpty()) {
                    this.toBeAnalyzedQueue.wait();
                }
                return (Request)this.toBeAnalyzedQueue.removeFirst();
            }
            catch (InterruptedException e) {
                return null;
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }
}

