/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.ConversationModel;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.ui.swing.ConversationListModel;
import org.owasp.webscarab.ui.swing.ConversationRenderer;
import org.owasp.webscarab.ui.swing.RequestPanel;
import org.owasp.webscarab.ui.swing.ResponsePanel;
import org.owasp.webscarab.util.swing.GloballyContextSensitiveAction;
import org.owasp.webscarab.util.swing.ListComboBoxModel;

public class ConversationPanel
extends JPanel {
    private static final long serialVersionUID = -5973620315232052252L;
    private static Dimension _preferredSize = null;
    private static Point _preferredLocation = null;
    private ConversationModel _model = null;
    private ConversationID _selected = null;
    private JFrame _frame = null;
    private String _title = null;
    private RequestPanel _requestPanel;
    private ResponsePanel _responsePanel;
    private JComboBox conversationComboBox;
    private JSplitPane conversationSplitPane;
    private JButton findButton;
    private JButton nextButton;
    private JButton previousButton;
    private JToolBar toolBar;

    public ConversationPanel() {
        this.initComponents();
        this.addPanels();
    }

    public ConversationPanel(ConversationModel model) {
        this._model = model;
        this.initComponents();
        this.addPanels();
        ConversationListModel clm = new ConversationListModel(model);
        this.conversationComboBox.setModel(new ListComboBoxModel(clm));
        this.conversationComboBox.setRenderer(new ConversationRenderer(model));
        this.add((Component)this.toolBar, "North");
        this.getActionMap().put("TOGGLELAYOUT", new AbstractAction(){
            private static final long serialVersionUID = 1558804946998494321L;

            public void actionPerformed(ActionEvent event) {
                if (ConversationPanel.this.conversationSplitPane.getOrientation() == 1) {
                    ConversationPanel.this.conversationSplitPane.setOrientation(0);
                } else {
                    ConversationPanel.this.conversationSplitPane.setOrientation(1);
                }
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke(84, 2), "TOGGLELAYOUT");
    }

    private void addPanels() {
        String dividerLocation;
        this._requestPanel = new RequestPanel();
        this.conversationSplitPane.setTopComponent(this._requestPanel);
        this._responsePanel = new ResponsePanel();
        this.conversationSplitPane.setBottomComponent(this._responsePanel);
        String orientation = Preferences.getPreference("ConversationPanel.orientation");
        if (orientation != null) {
            try {
                this.conversationSplitPane.setOrientation(Integer.parseInt(orientation));
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((dividerLocation = Preferences.getPreference("ConversationPanel.dividerLocation")) != null) {
            try {
                this.conversationSplitPane.setDividerLocation(Integer.parseInt(dividerLocation));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.conversationSplitPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("dividerLocation")) {
                    Preferences.setPreference("ConversationPanel.dividerLocation", e.getNewValue().toString());
                } else if (e.getPropertyName().equals("orientation")) {
                    Preferences.setPreference("ConversationPanel.orientation", e.getNewValue().toString());
                }
            }
        });
    }

    private void resizeFrame() {
        if (_preferredSize == null) {
            try {
                int width = Integer.parseInt(Preferences.getPreference("ConversationFrame.width", "600"));
                int height = Integer.parseInt(Preferences.getPreference("ConversationFrame.height", "500"));
                _preferredSize = new Dimension(width, height);
            }
            catch (Exception e) {
                _preferredSize = new Dimension(800, 600);
            }
        }
        if (_preferredLocation == null) {
            try {
                String value = Preferences.getPreference("ConversationFrame.x");
                if (value != null) {
                    int x = Integer.parseInt(value);
                    value = Preferences.getPreference("ConversationFrame.y");
                    int y = Integer.parseInt(value);
                    _preferredLocation = new Point(x, y);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_preferredLocation != null) {
            this._frame.setLocation(_preferredLocation);
        }
        if (_preferredSize != null) {
            this._frame.setSize(_preferredSize);
        }
        this._frame.addComponentListener(new ComponentAdapter(){

            public void componentMoved(ComponentEvent evt) {
                if (!ConversationPanel.this._frame.isVisible()) {
                    return;
                }
                _preferredLocation = ConversationPanel.this._frame.getLocation();
                Preferences.setPreference("ConversationFrame.x", Integer.toString(_preferredLocation.x));
                Preferences.setPreference("ConversationFrame.y", Integer.toString(_preferredLocation.y));
            }

            public void componentResized(ComponentEvent evt) {
                if (!ConversationPanel.this._frame.isVisible()) {
                    return;
                }
                _preferredSize = ConversationPanel.this._frame.getSize();
                Preferences.setPreference("ConversationFrame.width", Integer.toString(_preferredSize.width));
                Preferences.setPreference("ConversationFrame.height", Integer.toString(_preferredSize.height));
            }
        });
    }

    public void setRequest(Request request, boolean editable) {
        this._requestPanel.setEditable(editable);
        this._requestPanel.setRequest(request);
    }

    public boolean isRequestModified() {
        return this._requestPanel.isModified();
    }

    public Request getRequest() throws MalformedURLException, ParseException {
        return this._requestPanel.getRequest();
    }

    public void setResponse(Response response, boolean editable) {
        this._responsePanel.setEditable(editable);
        this._responsePanel.setResponse(response);
    }

    public boolean isResponseModified() {
        return this._responsePanel.isModified();
    }

    public Response getResponse() {
        return this._responsePanel.getResponse();
    }

    public void setSelectedConversation(ConversationID id) {
        this._selected = id;
        this.conversationComboBox.setSelectedItem(this._selected);
    }

    public ConversationID getSelectedConversation() {
        return this._selected;
    }

    public JFrame inFrame() {
        ConversationID selected = this.getSelectedConversation();
        if (selected != null) {
            return this.inFrame("WebScarab - conversation " + selected);
        }
        return this.inFrame(null);
    }

    public JFrame inFrame(String title) {
        this._title = title;
        this._frame = new JFrame();
        this._frame.getContentPane().add(this);
        this._frame.setTitle(this._title);
        this.resizeFrame();
        return this._frame;
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.previousButton = new JButton();
        this.nextButton = new JButton();
        this.findButton = new JButton(new GloballyContextSensitiveAction("TOGGLEFIND", "Find", "Find"));
        this.conversationComboBox = new JComboBox();
        this.conversationSplitPane = new JSplitPane();
        this.toolBar.setFloatable(false);
        this.previousButton.setMnemonic('P');
        this.previousButton.setText("Previous");
        this.previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConversationPanel.this.previousButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.previousButton);
        this.nextButton.setMnemonic('N');
        this.nextButton.setText("Next");
        this.nextButton.setMaximumSize(new Dimension(61, 27));
        this.nextButton.setMinimumSize(new Dimension(61, 27));
        this.nextButton.setPreferredSize(new Dimension(65, 27));
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConversationPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.nextButton);
        this.findButton.setText("Find");
        this.findButton.setMaximumSize(new Dimension(61, 27));
        this.findButton.setMinimumSize(new Dimension(61, 27));
        this.toolBar.add(this.findButton);
        this.conversationComboBox.setMaximumSize(new Dimension(600, Short.MAX_VALUE));
        this.conversationComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConversationPanel.this.conversationComboBoxActionPerformed(evt);
            }
        });
        this.toolBar.add(this.conversationComboBox);
        this.setLayout(new BorderLayout());
        this.conversationSplitPane.setDividerLocation(100);
        this.conversationSplitPane.setOrientation(0);
        this.conversationSplitPane.setResizeWeight(0.3);
        this.conversationSplitPane.setOneTouchExpandable(true);
        this.add((Component)this.conversationSplitPane, "Center");
    }

    private void conversationComboBoxActionPerformed(ActionEvent evt) {
        ConversationID id = (ConversationID)this.conversationComboBox.getSelectedItem();
        if (id == null) {
            this.setRequest(null, false);
            this.setResponse(null, false);
            if (this._frame != null) {
                this._frame.setTitle("WebScarab - no conversation selected");
            }
        } else {
            Request request = this._model.getRequest(id);
            Response response = this._model.getResponse(id);
            this.setRequest(request, false);
            this.setResponse(response, false);
            if (this._frame != null) {
                this._frame.setTitle("WebScarab - conversation " + id);
            }
        }
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        int index = this.conversationComboBox.getSelectedIndex();
        if (index + 1 < this.conversationComboBox.getModel().getSize()) {
            this.conversationComboBox.setSelectedIndex(index + 1);
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        int index = this.conversationComboBox.getSelectedIndex();
        if (index > 0) {
            this.conversationComboBox.setSelectedIndex(index - 1);
        }
    }

    public static void main(String[] args) {
        try {
            FrameworkModel model = new FrameworkModel();
            model.setSession("FileSystem", new File("/tmp/l/1"), "");
            ConversationPanel cp = new ConversationPanel(model.getConversationModel());
            JFrame frame = cp.inFrame();
            frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    System.exit(0);
                }
            });
            frame.setVisible(true);
            cp.setSelectedConversation(new ConversationID(1));
        }
        catch (StoreException se) {
            se.printStackTrace();
            System.exit(0);
        }
    }
}

