/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.plugin.Framework;
import org.owasp.webscarab.util.W32WinInet;

public class ProxyConfig
extends JDialog {
    private static final long serialVersionUID = 1655655396211378140L;
    private HTTPClientFactory _factory = HTTPClientFactory.getInstance();
    private Framework _framework;
    private JButton applyButton;
    private JButton cancelButton;
    private JTextField httpProxyPortTextField;
    private JTextField httpProxyServerTextField;
    private JTextField httpsProxyPortTextField;
    private JTextField httpsProxyServerTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea noProxyTextArea;
    private JButton w32Button;

    public ProxyConfig(Frame parent, Framework framework) {
        super(parent, true);
        this._framework = framework;
        this.initComponents();
        this.httpProxyServerTextField.setText(this._factory.getHttpProxy());
        this.httpProxyPortTextField.setText(Integer.toString(this._factory.getHttpProxyPort()));
        this.httpsProxyServerTextField.setText(this._factory.getHttpsProxy());
        this.httpsProxyPortTextField.setText(Integer.toString(this._factory.getHttpsProxyPort()));
        String[] noproxies = this._factory.getNoProxy();
        if (noproxies.length > 0) {
            StringBuffer buff = new StringBuffer();
            buff.append(noproxies[0]);
            for (int i = 1; i < noproxies.length; ++i) {
                buff.append(", ").append(noproxies[i]);
            }
            this.noProxyTextArea.setText(buff.toString());
        } else {
            this.noProxyTextArea.setText("");
        }
        if (!W32WinInet.isAvailable()) {
            this.w32Button.getParent().remove(this.w32Button);
        }
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.httpProxyServerTextField = new JTextField();
        this.jLabel5 = new JLabel();
        this.httpProxyPortTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.httpsProxyServerTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.httpsProxyPortTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.noProxyTextArea = new JTextArea();
        this.jPanel1 = new JPanel();
        this.w32Button = new JButton();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Config proxies");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ProxyConfig.this.closeDialog(evt);
            }
        });
        this.jLabel2.setText("HTTP  Proxy : ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.httpProxyServerTextField.setMinimumSize(new Dimension(250, 20));
        this.httpProxyServerTextField.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.httpProxyServerTextField, gridBagConstraints);
        this.jLabel5.setText("Port :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        this.httpProxyPortTextField.setMinimumSize(new Dimension(60, 20));
        this.httpProxyPortTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.httpProxyPortTextField, gridBagConstraints);
        this.jLabel4.setText("HTTPS Proxy : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        this.httpsProxyServerTextField.setMinimumSize(new Dimension(250, 20));
        this.httpsProxyServerTextField.setPreferredSize(new Dimension(250, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.httpsProxyServerTextField, gridBagConstraints);
        this.jLabel3.setText("Port :");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.httpsProxyPortTextField.setMinimumSize(new Dimension(60, 20));
        this.httpsProxyPortTextField.setPreferredSize(new Dimension(60, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.httpsProxyPortTextField, gridBagConstraints);
        this.jLabel1.setText("No Proxy : ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setMinimumSize(new Dimension(250, 48));
        this.jScrollPane1.setPreferredSize(new Dimension(250, 51));
        this.noProxyTextArea.setLineWrap(true);
        this.noProxyTextArea.setToolTipText("Enter a comma separated list of hosts that do not need to go through the proxy");
        this.noProxyTextArea.setMinimumSize(new Dimension(250, 40));
        this.noProxyTextArea.setPreferredSize(new Dimension(250, 40));
        this.jScrollPane1.setViewportView(this.noProxyTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.w32Button.setText("Get IE Settings");
        this.w32Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyConfig.this.w32ButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.w32Button);
        this.applyButton.setText("Apply");
        this.applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyConfig.this.applyButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.applyButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ProxyConfig.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    private void w32ButtonActionPerformed(ActionEvent evt) {
        if (W32WinInet.isAvailable()) {
            String server = W32WinInet.getHttpProxyServer();
            this.httpProxyServerTextField.setText(server == null ? "" : server);
            int port = W32WinInet.getHttpProxyPort();
            if (port < 1) {
                port = 3128;
            }
            this.httpProxyPortTextField.setText(Integer.toString(port));
            server = W32WinInet.getHttpsProxyServer();
            this.httpsProxyServerTextField.setText(server == null ? "" : server);
            port = W32WinInet.getHttpsProxyPort();
            if (port < 1) {
                port = 3128;
            }
            this.httpsProxyPortTextField.setText(Integer.toString(port));
            String bypass = W32WinInet.getNoProxy();
            if (bypass == null) {
                bypass = "";
            }
            this.noProxyTextArea.setText(bypass.replaceAll(";", ","));
        }
    }

    private void applyButtonActionPerformed(ActionEvent evt) {
        String error = null;
        String httpserver = this.httpProxyServerTextField.getText().trim();
        int httpport = -1;
        try {
            String p = this.httpProxyPortTextField.getText().trim();
            if (httpserver.equals("") && p.equals("")) {
                p = "3128";
            }
            if ((httpport = Integer.parseInt(p)) < 1 || httpport > 65535) {
                error = "HTTP Proxy port must be between 0 and 65536";
            }
        }
        catch (NumberFormatException nfe) {
            error = "Error parsing the HTTP Proxy port number";
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
            return;
        }
        String httpsserver = this.httpsProxyServerTextField.getText().trim();
        int httpsport = -1;
        try {
            String p = this.httpsProxyPortTextField.getText().trim();
            if (httpsserver.equals("") && p.equals("")) {
                p = "3128";
            }
            if ((httpsport = Integer.parseInt(p)) < 1 || httpsport > 65535) {
                error = "HTTPS Proxy port must be between 0 and 65536";
            }
        }
        catch (NumberFormatException nfe) {
            error = "Error parsing the HTTPS Proxy port number";
        }
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, "Error", 0);
            return;
        }
        String[] noproxies = this.noProxyTextArea.getText().trim().split(" *, *");
        boolean running = this._framework.isRunning();
        if (running) {
            if (this._framework.isBusy()) {
                String[] status = this._framework.getStatus();
                JOptionPane.showMessageDialog(this, status, "Error - plugins are busy", 0);
                return;
            }
            this._framework.stopPlugins();
        }
        this._factory.setHttpProxy(httpserver, httpport);
        this._factory.setHttpsProxy(httpsserver, httpsport);
        this._factory.setNoProxy(noproxies);
        if (running) {
            this._framework.startPlugins();
        }
        Preferences.setPreference("WebScarab.httpProxy", httpserver + ":" + httpport);
        Preferences.setPreference("WebScarab.httpsProxy", httpsserver + ":" + httpsport);
        Preferences.setPreference("WebScarab.noProxy", this.noProxyTextArea.getText());
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

