/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.ui.swing.editors.HexPanel;

public class EditorFactory {
    private static Map _editors = null;
    private static ByteArrayEditor[] NONE = new ByteArrayEditor[0];
    private static Logger _logger = Logger.getLogger("org.owasp.webscarab.ui.swing.editors.EditorFactory");

    private EditorFactory() {
    }

    public static void registerEditor(String contentType, String editorClass) {
        ArrayList<String> list = (ArrayList<String>)_editors.get(contentType);
        if (list == null) {
            list = new ArrayList<String>();
            _editors.put(contentType, list);
        }
        if (list.indexOf(editorClass) < 0) {
            list.add(editorClass);
        }
    }

    public static ByteArrayEditor[] getEditors(String contentType) {
        if (contentType == null) {
            return new ByteArrayEditor[]{new HexPanel()};
        }
        Iterator it = _editors.keySet().iterator();
        ArrayList editors = new ArrayList();
        while (it.hasNext()) {
            String type = (String)it.next();
            if (!contentType.matches(type)) continue;
            List list = (List)_editors.get(type);
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                String className = (String)it2.next();
                try {
                    Object ed = Class.forName(className).newInstance();
                    if (ed instanceof ByteArrayEditor && ed instanceof Component) {
                        editors.add(ed);
                        continue;
                    }
                    _logger.warning("Editor " + className + " must implement ByteArrayEditor and Component");
                }
                catch (Exception e) {
                    _logger.warning("Exception trying to instantiate " + className + " : " + e);
                }
            }
        }
        return editors.toArray(NONE);
    }

    static {
        _editors = new LinkedHashMap();
        EditorFactory.registerEditor("multipart/form-data; *.*", "org.owasp.webscarab.ui.swing.editors.MultiPartPanel");
        EditorFactory.registerEditor("application/x-serialized-object", "org.owasp.webscarab.ui.swing.editors.SerializedObjectPanel");
        EditorFactory.registerEditor("image/.*", "org.owasp.webscarab.ui.swing.editors.ImagePanel");
        EditorFactory.registerEditor("application/x-www-form-urlencoded(;.*){0,1}", "org.owasp.webscarab.ui.swing.editors.UrlEncodedPanel");
        EditorFactory.registerEditor("text/html.*", "org.owasp.webscarab.ui.swing.editors.HTMLPanel");
        EditorFactory.registerEditor("text/html.*", "org.owasp.webscarab.ui.swing.editors.XMLPanel");
        EditorFactory.registerEditor("text/xml.*", "org.owasp.webscarab.ui.swing.editors.XMLPanel");
        EditorFactory.registerEditor("text/.*", "org.owasp.webscarab.ui.swing.editors.TextPanel");
        EditorFactory.registerEditor("application/x-javascript(;.*){0,1}", "org.owasp.webscarab.ui.swing.editors.TextPanel");
        EditorFactory.registerEditor("application/x-www-form-urlencoded(;.*){0,1}", "org.owasp.webscarab.ui.swing.editors.TextPanel");
        EditorFactory.registerEditor("application/x-amf(;.*){0,1}", "org.owasp.webscarab.ui.swing.editors.AMFPanel");
        EditorFactory.registerEditor(".*", "org.owasp.webscarab.ui.swing.editors.HexPanel");
    }
}

