/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.mozilla.intl.chardet.nsDetector;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.ui.swing.editors.MyHTMLEditorKit;

public class HTMLPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = 6521674496262573570L;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private byte[] _bytes = null;
    private JEditorPane htmlEditorPane;
    private JScrollPane htmlScrollPane;

    public HTMLPanel() {
        this.initComponents();
        this.setName("HTML");
        this.htmlEditorPane.setEditable(false);
        this.htmlEditorPane.setEditorKit(new MyHTMLEditorKit());
        this.htmlEditorPane.addHyperlinkListener(new LinkToolTipListener());
    }

    public String[] getContentTypes() {
        return new String[]{"text/html.*"};
    }

    public void setEditable(boolean editable) {
    }

    private String getCharset(String contentType, byte[] bytes) {
        nsDetector det = new nsDetector(0);
        boolean isAscii = det.isAscii(bytes, bytes.length);
        if (!isAscii) {
            det.DoIt(bytes, bytes.length, false);
        }
        String[] charsets = det.getProbableCharsets();
        det.DataEnd();
        if (isAscii) {
            return "ASCII";
        }
        if (charsets.length == 0) {
            return null;
        }
        if (charsets.length == 1 && charsets[0].equals("nomatch")) {
            return null;
        }
        return charsets[0];
    }

    public void setBytes(String contentType, byte[] bytes) {
        block7: {
            this._bytes = bytes;
            if (bytes != null) {
                String charset = null;
                if (contentType.indexOf("charset") == -1) {
                    charset = this.getCharset(contentType, bytes);
                    contentType = contentType + "; charset=" + charset;
                } else {
                    charset = contentType.substring(contentType.indexOf("charset=") + 8);
                }
                this.htmlEditorPane.setContentType(contentType);
                this.htmlEditorPane.setDocument(JEditorPane.createEditorKitForContentType("text/html").createDefaultDocument());
                this.htmlEditorPane.putClientProperty("IgnoreCharsetDirective", Boolean.TRUE);
                this.htmlEditorPane.getDocument().putProperty("IgnoreCharsetDirective", Boolean.TRUE);
                try {
                    if (charset != null) {
                        this.htmlEditorPane.setText(new String(bytes, charset));
                        break block7;
                    }
                    this.htmlEditorPane.setText(new String(bytes));
                }
                catch (Exception e) {
                    this._logger.warning("Error setting HTML text: " + e);
                    e.printStackTrace();
                }
            } else {
                this.htmlEditorPane.setText("");
            }
        }
        this.htmlEditorPane.setCaretPosition(0);
    }

    public boolean isModified() {
        return false;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    private void initComponents() {
        this.htmlScrollPane = new JScrollPane();
        this.htmlEditorPane = new NoNetEditorPane();
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(400, 20));
        this.setPreferredSize(new Dimension(400, 20));
        this.htmlScrollPane.setViewportView(this.htmlEditorPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.htmlScrollPane, gridBagConstraints);
    }

    public class LinkToolTipListener
    implements HyperlinkListener {
        public void hyperlinkUpdate(HyperlinkEvent he) {
            HyperlinkEvent.EventType type = he.getEventType();
            if (type == HyperlinkEvent.EventType.ENTERED) {
                JEditorPane jep = (JEditorPane)he.getSource();
                URL url = he.getURL();
                if (url != null) {
                    jep.setToolTipText(url.toString());
                } else {
                    jep.setToolTipText(he.getDescription());
                }
            } else if (type == HyperlinkEvent.EventType.EXITED) {
                JEditorPane jep = (JEditorPane)he.getSource();
                jep.setToolTipText("");
            }
        }
    }

    private class NoNetEditorPane
    extends JEditorPane {
        private static final long serialVersionUID = 5246114185513152820L;

        private NoNetEditorPane() {
        }

        protected InputStream getStream(URL page) throws IOException {
            HTMLPanel.this._logger.info("Rejecting request for " + page);
            throw new IOException("We do not support network traffic");
        }
    }
}

