/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;

public class HexPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = -6389071746723775943L;
    private HexTableModel _tableModel = null;
    private boolean _editable = false;
    private int _columns = 16;
    private boolean _modified = false;
    private byte[] _data = null;
    private byte[] _original = null;
    private JTable hexTable;
    private JScrollPane jScrollPane1;

    public HexPanel() {
        this.initComponents();
        this.setName("Hex");
        this._tableModel = new HexTableModel(this._columns);
        this.hexTable.setModel(this._tableModel);
        this.hexTable.setFont(new Font("Monospaced", 0, 12));
        this.hexTable.getTableHeader().setReorderingAllowed(false);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.putClientProperty("html.disable", Boolean.TRUE);
        this.hexTable.setDefaultRenderer(Object.class, renderer);
        TableColumnModel colModel = this.hexTable.getColumnModel();
        for (int i = 0; i < this._columns + 2; ++i) {
            colModel.getColumn(i).setPreferredWidth(18);
            colModel.getColumn(i).setResizable(false);
        }
        colModel.getColumn(0).setPreferredWidth(72);
        colModel.getColumn(this._columns + 1).setPreferredWidth(this._columns * 9);
        InputMap im = this.getInputMap(1);
        im.put(KeyStroke.getKeyStroke(83, 2), "Save");
        im.put(KeyStroke.getKeyStroke(76, 2), "Load");
        this.getActionMap().put("Save", new AbstractAction(){
            private static final long serialVersionUID = 6229743807139403588L;

            public void actionPerformed(ActionEvent evt) {
                JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
                jfc.setDialogTitle("Select a file to write the message content to");
                int returnVal = jfc.showSaveDialog(HexPanel.this);
                if (returnVal == 0) {
                    try {
                        FileOutputStream fos = new FileOutputStream(jfc.getSelectedFile());
                        fos.write(HexPanel.this._data);
                        fos.close();
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(HexPanel.this, "Error writing file: " + ioe.getMessage(), "Error", 0);
                    }
                }
                Preferences.setPreference("WebScarab.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
            }
        });
        this.getActionMap().put("Load", new AbstractAction(){
            private static final long serialVersionUID = 2208374207129449438L;

            public void actionPerformed(ActionEvent evt) {
                if (!HexPanel.this._editable) {
                    return;
                }
                JFileChooser jfc = new JFileChooser(Preferences.getPreference("WebScarab.DefaultDirectory"));
                jfc.setDialogTitle("Select a file to read the message content from");
                int returnVal = jfc.showOpenDialog(HexPanel.this);
                if (returnVal == 0) {
                    try {
                        int got;
                        FileInputStream fis = new FileInputStream(jfc.getSelectedFile());
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buff = new byte[2048];
                        while ((got = fis.read(buff)) > 0) {
                            baos.write(buff, 0, got);
                        }
                        fis.close();
                        baos.close();
                        HexPanel.access$002(HexPanel.this, baos.toByteArray());
                        HexPanel.this._tableModel.fireTableDataChanged();
                        HexPanel.this._modified = true;
                    }
                    catch (IOException ioe) {
                        JOptionPane.showMessageDialog(HexPanel.this, "Error writing file: " + ioe.getMessage(), "Error", 0);
                    }
                }
                Preferences.setPreference("WebScarab.DefaultDirectory", jfc.getCurrentDirectory().getAbsolutePath());
            }
        });
    }

    public String[] getContentTypes() {
        return new String[]{".*"};
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this.hexTable.setBackground(editable ? Color.WHITE : Color.LIGHT_GRAY);
    }

    public void setBytes(String contentType, byte[] bytes) {
        this._original = bytes;
        if (bytes == null) {
            this._data = null;
        } else {
            this._data = new byte[bytes.length];
            System.arraycopy(bytes, 0, this._data, 0, bytes.length);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this._tableModel.fireTableDataChanged();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    HexPanel.this._tableModel.fireTableDataChanged();
                }
            });
        }
        this._modified = false;
    }

    public boolean isModified() {
        if (this.hexTable.isEditing()) {
            this.hexTable.getCellEditor().stopCellEditing();
        }
        return this._editable && this._modified;
    }

    public byte[] getBytes() {
        if (this._editable && this.isModified()) {
            this._original = this._data;
        }
        this._modified = false;
        return this._original;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.hexTable = new JTable();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(453, 20));
        this.jScrollPane1.setMinimumSize(new Dimension(22, 48));
        this.hexTable.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.hexTable.setAutoResizeMode(0);
        this.jScrollPane1.setViewportView(this.hexTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public static void main(String[] args) {
        JFrame top = new JFrame("Hex Editor");
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        HexPanel hp = new HexPanel();
        top.getContentPane().add(hp);
        top.setBounds(100, 100, 600, 400);
        try {
            hp.setBytes(null, new byte[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47});
            hp.setEditable(true);
            top.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static /* synthetic */ byte[] access$002(HexPanel x0, byte[] x1) {
        x0._data = x1;
        return x1;
    }

    private class HexTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -5393432450731234710L;
        private int _columns = 8;

        public HexTableModel() {
        }

        public HexTableModel(int columns) {
            this._columns = columns;
        }

        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return "Position";
            }
            if (columnIndex - 1 < this._columns) {
                return Integer.toHexString(columnIndex - 1).toUpperCase();
            }
            return "String";
        }

        public int getColumnCount() {
            return this._columns + 2;
        }

        public int getRowCount() {
            if (HexPanel.this._data == null || HexPanel.this._data.length == 0) {
                return 0;
            }
            if (HexPanel.this._data.length % this._columns == 0) {
                return HexPanel.this._data.length / this._columns;
            }
            return HexPanel.this._data.length / this._columns + 1;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.pad(Integer.toHexString(rowIndex * this._columns).toUpperCase(), '0', 8);
            }
            if (columnIndex - 1 < this._columns) {
                int position = rowIndex * this._columns + columnIndex - 1;
                if (position < HexPanel.this._data.length) {
                    int i = HexPanel.this._data[position];
                    if (i < 0) {
                        i += 256;
                    }
                    return this.pad(Integer.toString(i, 16).toUpperCase(), '0', 2);
                }
                return "";
            }
            int start = rowIndex * this._columns;
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < this._columns; ++i) {
                int pos = start + i;
                if (pos >= HexPanel.this._data.length) {
                    return buff.toString();
                }
                if (HexPanel.this._data[pos] < 32 || HexPanel.this._data[pos] > 126) {
                    buff.append(".");
                    continue;
                }
                buff.append((char)HexPanel.this._data[pos]);
            }
            return buff.toString();
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 0 || columnIndex > this._columns) {
                return false;
            }
            int position = rowIndex * this._columns + columnIndex - 1;
            if (position < HexPanel.this._data.length) {
                return HexPanel.this._editable;
            }
            return false;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            int position = rowIndex * this._columns + columnIndex - 1;
            if (position >= HexPanel.this._data.length) {
                System.out.println("Out of range");
                return;
            }
            if (aValue instanceof String) {
                try {
                    String s = (String)aValue;
                    ((HexPanel)HexPanel.this)._data[position] = new Integer(Integer.parseInt(s.trim(), 16)).byteValue();
                    this.fireTableCellUpdated(rowIndex, this._columns + 1);
                    HexPanel.this._modified = true;
                }
                catch (NumberFormatException nfe) {
                    System.out.println("Number format error : " + nfe);
                }
            } else {
                System.out.println("Value is a " + aValue.getClass().getName());
            }
        }

        private String pad(String initial, char padchar, int length) {
            if (initial.length() >= length) {
                return initial;
            }
            StringBuffer buff = new StringBuffer(length);
            for (int i = 0; i < length - initial.length(); ++i) {
                buff.append(padchar);
            }
            buff.append(initial);
            return buff.toString();
        }
    }
}

