/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;

public class ImagePanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = 6069538617330618742L;
    private byte[] _data = new byte[0];
    private JLabel imageLabel;
    private JScrollPane imageScrollPane;

    public ImagePanel() {
        this.initComponents();
        this.setName("Image");
    }

    public String[] getContentTypes() {
        return new String[]{"image/.*"};
    }

    public void setEditable(boolean editable) {
    }

    public byte[] getBytes() {
        return this._data;
    }

    public void setBytes(String contentType, byte[] bytes) {
        this.imageLabel.setIcon(null);
        if (bytes != null && bytes.length > 0) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                BufferedImage image = ImageIO.read(bais);
                if (image != null) {
                    this.imageLabel.setIcon(new ImageIcon(image));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.imageLabel.setIcon(null);
            }
        }
    }

    public boolean isModified() {
        return false;
    }

    private void initComponents() {
        this.imageScrollPane = new JScrollPane();
        this.imageLabel = new JLabel();
        this.setLayout(new GridBagLayout());
        this.imageScrollPane.setViewportView(this.imageLabel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.imageScrollPane, gridBagConstraints);
    }

    public static void main(String[] args) {
        byte[] content = new byte[]{};
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream("/usr/share/xfce/backdrops/Flower.jpg");
            byte[] buff = new byte[1024];
            int got = 0;
            while ((got = fis.read(buff)) > 0) {
                baos.write(buff, 0, got);
            }
            content = baos.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
        JFrame top = new JFrame("Image Panel");
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        ImagePanel ip = new ImagePanel();
        top.getContentPane().add(ip);
        top.setBounds(100, 100, 600, 400);
        try {
            ip.setBytes(null, content);
            ip.setEditable(false);
            top.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

