/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public class SearchDialog
extends JDialog {
    private static final long serialVersionUID = -3627749756146163207L;
    private JTextComponent _textComponent = null;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JLabel findLabel;
    private JTextField findTextField;
    private JButton replaceButton;
    private JLabel replaceLabel;
    private JTextField replaceTextField;
    private JButton searchButton;

    public SearchDialog(Frame parent, JTextComponent textComponent) {
        super(parent);
        String selection;
        if (textComponent == null) {
            throw new NullPointerException("Can't search a null text component!");
        }
        this._textComponent = textComponent;
        this.initComponents();
        if (!this._textComponent.isEditable()) {
            this.replaceButton.setVisible(false);
            this.replaceTextField.setVisible(false);
            this.replaceLabel.setVisible(false);
            this.pack();
        }
        if ((selection = this._textComponent.getSelectedText()) != null) {
            this.findTextField.setText(selection);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent evt) {
                SearchDialog.this.findTextField.requestFocus();
            }
        });
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){
            private static final long serialVersionUID = 482285775389739514L;

            public void actionPerformed(ActionEvent e) {
                SearchDialog.this.setVisible(false);
            }
        };
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.searchButton);
    }

    public void doSearch() {
        if (this._textComponent == null) {
            System.err.println("Uninitialised textComponent");
            return;
        }
        String searchText = this.findTextField.getText();
        if (searchText.length() > 0) {
            int caret = this._textComponent.getSelectionStart();
            int position = this._textComponent.getText().indexOf(searchText, caret + 1);
            if (position == -1 && caret > 0) {
                position = this._textComponent.getText().indexOf(searchText);
            }
            if (position > -1) {
                try {
                    this._textComponent.setCaretPosition(position);
                    this._textComponent.moveCaretPosition(position + searchText.length());
                }
                catch (IllegalArgumentException iae) {
                    System.err.println("error showing search results : " + iae);
                }
            } else {
                System.err.println("'" + searchText + "' not found!");
                this._textComponent.setCaretPosition(caret);
            }
        }
    }

    public void doReplace() {
        if (this._textComponent == null) {
            System.err.println("Uninitialised textComponent");
            return;
        }
        String searchText = this.findTextField.getText();
        String replaceText = this.replaceTextField.getText();
        if (searchText.length() > 0) {
            String text = this._textComponent.getText();
            int caret = this._textComponent.getSelectionStart();
            int position = this._textComponent.getText().indexOf(searchText, caret);
            if (position == -1 && caret > 0) {
                position = this._textComponent.getText().indexOf(searchText);
            }
            if (position < 0) {
                System.err.println("Search text not found");
                return;
            }
            text = text.substring(0, position) + replaceText + text.substring(position + searchText.length());
            this._textComponent.setText(text);
            this._textComponent.setCaretPosition(position);
            this._textComponent.moveCaretPosition(position + replaceText.length());
        }
    }

    private void initComponents() {
        this.findLabel = new JLabel();
        this.findTextField = new JTextField();
        this.replaceLabel = new JLabel();
        this.replaceTextField = new JTextField();
        this.buttonPanel = new JPanel();
        this.searchButton = new JButton();
        this.replaceButton = new JButton();
        this.closeButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Find");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                SearchDialog.this.closeDialog(evt);
            }
        });
        this.findLabel.setText("Find ");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findLabel, gridBagConstraints);
        this.findTextField.setColumns(40);
        this.findTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.findTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.findTextField, gridBagConstraints);
        this.replaceLabel.setText("Replace");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceLabel, gridBagConstraints);
        this.replaceTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.replaceTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.replaceTextField, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.searchButton.setText("Search");
        this.searchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.searchButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.searchButton, gridBagConstraints);
        this.replaceButton.setText("Replace");
        this.replaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.replaceButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.buttonPanel.add((Component)this.replaceButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SearchDialog.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.buttonPanel.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 400) / 2, (screenSize.height - 120) / 2, 400, 120);
    }

    private void replaceTextFieldActionPerformed(ActionEvent evt) {
        this.doReplace();
    }

    private void findTextFieldActionPerformed(ActionEvent evt) {
        this.doSearch();
    }

    private void replaceButtonActionPerformed(ActionEvent evt) {
        this.doReplace();
    }

    private void searchButtonActionPerformed(ActionEvent evt) {
        this.doSearch();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
    }

    public static void main(String[] args) {
        JTextArea text = new JTextArea();
        text.setEditable(true);
        new SearchDialog((Frame)new JFrame(), text).setVisible(true);
    }
}

