/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.ui.swing.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.ui.swing.editors.ByteArrayEditor;
import org.owasp.webscarab.ui.swing.editors.RegexSearcher;
import org.owasp.webscarab.util.CharsetUtils;

public class TextPanel
extends JPanel
implements ByteArrayEditor {
    private static final long serialVersionUID = -3187847151844324989L;
    private static boolean _findVisible = false;
    private static String _find = "";
    private static boolean _caseSensitive = false;
    private int _start = 0;
    private boolean _editable = false;
    private boolean _modified = false;
    private byte[] _bytes = null;
    private String _charset = null;
    private String _text = null;
    private DocumentChangeListener _dcl = new DocumentChangeListener();
    private RegexSearcher searcher;
    private JCheckBox findCaseCheckBox;
    private JLabel findLabel;
    private JLabel findMessageLabel;
    private JButton findNextButton;
    private JPanel findPanel;
    private JButton findPreviousButton;
    private JTextField findTextField;
    private JScrollPane textScrollPane;
    private JTextArea textTextArea;

    public TextPanel() {
        this.initComponents();
        this.findCaseCheckBox.setSelected(_caseSensitive);
        this.setName("Text");
        this.searcher = new RegexSearcher(this.textTextArea, this.textTextArea.getSelectionColor(), Color.YELLOW);
        InputMap inputMap = this.textTextArea.getInputMap(0);
        this.textTextArea.getActionMap().put("TOGGLEWRAP", new AbstractAction(){
            private static final long serialVersionUID = -5660836423742675291L;

            public void actionPerformed(ActionEvent event) {
                TextPanel.this.textTextArea.setLineWrap(!TextPanel.this.textTextArea.getLineWrap());
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(87, 2), "TOGGLEWRAP");
        this.textTextArea.getActionMap().put("TOGGLEFIND", new AbstractAction(){
            private static final long serialVersionUID = 1834782994385394227L;

            public void actionPerformed(ActionEvent event) {
                _findVisible = !TextPanel.this.findPanel.isVisible();
                TextPanel.this.findPanel.setVisible(_findVisible);
                if (_findVisible) {
                    TextPanel.this.findTextField.requestFocusInWindow();
                }
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(70, 2), "TOGGLEFIND");
        this.findPanel.setVisible(_findVisible);
        this.findTextField.setText(_find);
        this.findTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                this.find();
            }

            public void removeUpdate(DocumentEvent evt) {
                this.find();
            }

            public void insertUpdate(DocumentEvent evt) {
                this.find();
            }

            private void find() {
                _find = TextPanel.this.findTextField.getText();
                TextPanel.this.doFind(_find, _caseSensitive);
                TextPanel.this._start = TextPanel.this.nextMatch(0);
            }
        });
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this.textTextArea.setEditable(editable);
    }

    public void setBytes(String contentType, byte[] bytes) {
        this._bytes = bytes;
        if (bytes == null) {
            this.setText(contentType, "");
        } else {
            this._charset = null;
            int ci = contentType.indexOf("charset");
            if (ci == -1) {
                this._charset = CharsetUtils.getCharset(bytes);
                if (this._charset == null) {
                    this._charset = "ASCII";
                }
            } else {
                this._charset = contentType.substring(ci + 8);
            }
            try {
                this.setText(contentType, new String(bytes, this._charset));
            }
            catch (UnsupportedEncodingException e) {
                this.setText(contentType, e.getMessage());
            }
        }
    }

    public void setText(String contentType, String text) {
        String wrap = Preferences.getPreference("TextPanel.wrap", "false");
        if (wrap != null && wrap.equals("true")) {
            this.textTextArea.setLineWrap(true);
        }
        this._text = text;
        this.textTextArea.getDocument().removeDocumentListener(this._dcl);
        this._modified = false;
        if (text != null) {
            this.textTextArea.setText(text);
        }
        this.textTextArea.setCaretPosition(0);
        if (this._editable) {
            this.textTextArea.getDocument().addDocumentListener(this._dcl);
        }
        this.doFind(_find, _caseSensitive);
        this._start = this.nextMatch(0);
    }

    public String getText() {
        this._text = this.textTextArea.getText();
        return this._text;
    }

    public boolean isModified() {
        return this._editable && this._modified;
    }

    public byte[] getBytes() {
        if (this.isModified()) {
            try {
                String text = this.getText();
                if (this._charset == null) {
                    this._charset = CharsetUtils.getCharset(text.getBytes());
                }
                this._bytes = this._charset != null ? text.getBytes(this._charset) : text.getBytes();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return this._bytes;
    }

    private int nextMatch(int oldPos) {
        int pos = this.searcher.nextMatch();
        StringBuffer message = new StringBuffer();
        if (pos == -1) {
            message.append("Not found");
        } else {
            if (pos <= oldPos) {
                message.append("Reached end of page, continued from top. ");
            }
            message.append(this.getLocation(pos));
        }
        this.findMessageLabel.setText(message.toString());
        return pos;
    }

    private int previousMatch(int oldPos) {
        int pos = this.searcher.previousMatch();
        StringBuffer message = new StringBuffer();
        if (pos == -1) {
            message.append("Not found");
        } else {
            if (pos >= oldPos) {
                message.append("Reached top of page, continued from bottom. ");
            }
            message.append("Found at " + this.getLocation(pos));
        }
        this.findMessageLabel.setText(message.toString());
        return pos;
    }

    private void doFind(String pattern, boolean caseSensitive) {
        try {
            this.searcher.search(pattern, caseSensitive);
        }
        catch (PatternSyntaxException pse) {
            this.findMessageLabel.setText(pse.getMessage());
        }
    }

    private String getLocation(int pos) {
        Element root = this.textTextArea.getDocument().getDefaultRootElement();
        int row = root.getElementIndex(pos);
        Element rowElement = root.getElement(row);
        int column = pos - rowElement.getStartOffset();
        return "line " + (row + 1) + ", " + (column + 1);
    }

    private void initComponents() {
        this.textScrollPane = new JScrollPane();
        this.textTextArea = new JTextArea();
        this.findPanel = new JPanel();
        this.findLabel = new JLabel();
        this.findTextField = new JTextField();
        this.findNextButton = new JButton();
        this.findPreviousButton = new JButton();
        this.findCaseCheckBox = new JCheckBox();
        this.findMessageLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.textTextArea.setEditable(false);
        this.textScrollPane.setViewportView(this.textTextArea);
        this.add((Component)this.textScrollPane, "Center");
        this.findPanel.setLayout(new GridBagLayout());
        this.findLabel.setText("Find: ");
        this.findPanel.add((Component)this.findLabel, new GridBagConstraints());
        this.findTextField.setMinimumSize(new Dimension(60, 19));
        this.findTextField.setPreferredSize(new Dimension(80, 19));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.findPanel.add((Component)this.findTextField, gridBagConstraints);
        this.findNextButton.setMnemonic('N');
        this.findNextButton.setText("Next");
        this.findNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.findNextButtonActionPerformed(evt);
            }
        });
        this.findPanel.add((Component)this.findNextButton, new GridBagConstraints());
        this.findPreviousButton.setMnemonic('N');
        this.findPreviousButton.setText("Previous");
        this.findPreviousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.findPreviousButtonActionPerformed(evt);
            }
        });
        this.findPanel.add((Component)this.findPreviousButton, new GridBagConstraints());
        this.findCaseCheckBox.setMnemonic('M');
        this.findCaseCheckBox.setText("Match Case");
        this.findCaseCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextPanel.this.findCaseCheckBoxActionPerformed(evt);
            }
        });
        this.findPanel.add((Component)this.findCaseCheckBox, new GridBagConstraints());
        this.findMessageLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.findPanel.add((Component)this.findMessageLabel, gridBagConstraints);
        this.add((Component)this.findPanel, "South");
    }

    private void findPreviousButtonActionPerformed(ActionEvent evt) {
        this._start = this.previousMatch(this._start);
    }

    private void findCaseCheckBoxActionPerformed(ActionEvent evt) {
        _caseSensitive = this.findCaseCheckBox.isSelected();
        this.doFind(_find, _caseSensitive);
        this._start = this.nextMatch(0);
    }

    private void findNextButtonActionPerformed(ActionEvent evt) {
        this._start = this.nextMatch(this._start);
    }

    public static void main(String[] args) {
        JFrame top = new JFrame("Text Editor");
        top.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                System.exit(0);
            }
        });
        TextPanel tp = new TextPanel();
        top.getContentPane().add(tp);
        top.setBounds(100, 100, 600, 400);
        try {
            int got;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream("/etc/passwd");
            byte[] buff = new byte[1024];
            while ((got = fis.read(buff)) > -1) {
                baos.write(buff, 0, got);
            }
            fis.close();
            baos.close();
            tp.setBytes("text", baos.toByteArray());
            tp.setEditable(true);
            top.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class DocumentChangeListener
    implements DocumentListener {
        private DocumentChangeListener() {
        }

        public void changedUpdate(DocumentEvent evt) {
            TextPanel.this._modified = true;
            TextPanel.this._text = null;
        }

        public void removeUpdate(DocumentEvent evt) {
            TextPanel.this._modified = true;
            TextPanel.this._text = null;
        }

        public void insertUpdate(DocumentEvent evt) {
            TextPanel.this._modified = true;
            TextPanel.this._text = null;
        }
    }
}

