/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.owasp.webscarab.util.swing.ColumnDataEvent;
import org.owasp.webscarab.util.swing.ColumnDataListener;
import org.owasp.webscarab.util.swing.ColumnDataModel;

public abstract class ExtensibleTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -2783690695443856742L;
    private List _columns = new ArrayList();
    private ColumnDataListener _columnListener = new ColumnDataListener(){

        public void dataChanged(ColumnDataEvent cde) {
            Object column = cde.getSource();
            int col = ExtensibleTableModel.this._columns.indexOf(column);
            if (col < 0) {
                return;
            }
            Object key = cde.getKey();
            if (key == null) {
                ExtensibleTableModel.this.fireTableStructureChanged();
            } else {
                int row = ExtensibleTableModel.this.indexOfKey(key);
                if (row > -1) {
                    ExtensibleTableModel.this.fireTableCellUpdated(row, col);
                }
            }
        }
    };

    public abstract int getRowCount();

    public abstract Object getKeyAt(int var1);

    public abstract int indexOfKey(Object var1);

    public void addColumn(ColumnDataModel column) {
        this._columns.add(column);
        column.addColumnDataListener(this._columnListener);
        this.fireTableStructureChanged();
    }

    public void removeColumn(ColumnDataModel column) {
        int index = this._columns.indexOf(column);
        if (index < 0) {
            return;
        }
        column.removeColumnDataListener(this._columnListener);
        this._columns.remove(index);
        this.fireTableStructureChanged();
    }

    public int getColumnCount() {
        return this._columns.size();
    }

    public String getColumnName(int column) {
        return ((ColumnDataModel)this._columns.get(column)).getColumnName();
    }

    public Class getColumnClass(int column) {
        return ((ColumnDataModel)this._columns.get(column)).getColumnClass();
    }

    protected Object getValueAt(Object key, int column) {
        return ((ColumnDataModel)this._columns.get(column)).getValue(key);
    }

    public Object getValueAt(int row, int column) {
        Object key = this.getKeyAt(row);
        return this.getValueAt(key, column);
    }

    protected boolean isCellEditable(Object key, int column) {
        return ((ColumnDataModel)this._columns.get(column)).isEditable(key);
    }

    public boolean isCellEditable(int row, int column) {
        Object key = this.getKeyAt(row);
        return this.isCellEditable(key, column);
    }

    protected void setValueAt(Object aValue, Object key, int column) {
        ((ColumnDataModel)this._columns.get(column)).setValue(aValue, key);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Object key = this.getKeyAt(row);
        this.setValueAt(aValue, key, column);
    }
}

