/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class HeapMonitor
extends JButton
implements ActionListener {
    private long free;
    private long max = Runtime.getRuntime().maxMemory();
    private static final long MB = 0x100000L;
    private Timer timer;
    private static final long serialVersionUID = 2794077275357170746L;

    public HeapMonitor() {
        this.update();
        this.timer = new Timer(15000, this);
        this.timer.start();
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HeapMonitor.this.gc();
            }
        });
    }

    private void gc() {
        new Thread("Garbage collector"){

            public void run() {
                System.out.println("Running gc");
                System.gc();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        HeapMonitor.this.update();
                    }
                });
            }
        }.start();
    }

    private void update() {
        this.free = this.max + Runtime.getRuntime().freeMemory() - Runtime.getRuntime().totalMemory();
        String label = "Used " + HeapMonitor.toMB(this.max - this.free) + " of " + HeapMonitor.toMB(this.max) + "MB";
        this.setOpaque(true);
        double ratio = (double)(this.max - this.free) / (double)this.max;
        if (ratio > (double)0.9f) {
            this.setBackground(Color.RED);
        } else if (ratio > 0.75) {
            this.setBackground(Color.YELLOW);
        } else {
            this.setBackground(Color.GREEN);
        }
        this.setText(label);
    }

    public void actionPerformed(ActionEvent e) {
        this.update();
    }

    public static String toMB(long bytes) {
        String s = Double.toString((double)bytes / 1048576.0);
        int dot = s.indexOf(".");
        if (dot > 0 && dot < s.length() - 2) {
            s = s.substring(0, dot + 3);
        }
        return s;
    }

    public static void main(String[] args) throws Exception {
        JFrame frame = new JFrame("Heapspace");
        frame.getContentPane().add(new HeapMonitor());
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        byte[][] bytes = new byte[1024][];
        for (int i = 0; i < 1024; ++i) {
            bytes[i] = new byte[65535];
            Arrays.fill(bytes[i], (byte)1);
            Thread.sleep(10L);
        }
        System.exit(0);
    }
}

