/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.util.swing;

import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class NoWrapEditorKit
extends StyledEditorKit {
    private static final long serialVersionUID = 2867130121374027370L;

    public ViewFactory getViewFactory() {
        return new StyledViewFactory();
    }

    static class MyLabelView
    extends LabelView {
        public MyLabelView(Element elem) {
            super(elem);
        }

        public float getPreferredSpan(int axis) {
            float span = 0.0f;
            if (axis == 0) {
                int p0 = this.getStartOffset();
                int p1 = this.getEndOffset();
                this.checkPainter();
                TabExpander ex = this.getTabExpander();
                if (ex == null) {
                    ex = (TabExpander)((Object)this.getParent().getParent());
                }
                span = this.getGlyphPainter().getSpan(this, p0, p1, ex, 0.0f);
                return Math.max(span, 1.0f);
            }
            span = super.getPreferredSpan(axis);
            return span;
        }
    }

    static class NoWrapBoxView
    extends BoxView {
        public NoWrapBoxView(Element elem, int axis) {
            super(elem, axis);
        }

        public void layout(int width, int height) {
            super.layout(32768, height);
        }

        public float getMinimumSpan(int axis) {
            return super.getPreferredSpan(axis);
        }
    }

    static class StyledViewFactory
    implements ViewFactory {
        StyledViewFactory() {
        }

        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new MyLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new NoWrapBoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

