/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.axis.AxisConstants;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotNotCompatibleException;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.ObjectUtils;

public abstract class Axis
implements AxisConstants,
Cloneable,
Serializable {
    private boolean visible;
    private String label;
    private Font labelFont;
    private transient Paint labelPaint;
    private Insets labelInsets;
    private double labelAngle;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private transient Paint tickLabelPaint;
    private Insets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private transient Stroke tickMarkStroke;
    private transient Paint tickMarkPaint;
    private double fixedDimension;
    private transient List ticks;
    private transient Plot plot;
    private transient EventListenerList listenerList;
    static /* synthetic */ Class class$org$jfree$chart$event$AxisChangeListener;

    protected Axis(String string) {
        this.label = string;
        this.visible = true;
        this.labelFont = AxisConstants.DEFAULT_AXIS_LABEL_FONT;
        this.labelPaint = AxisConstants.DEFAULT_AXIS_LABEL_PAINT;
        this.labelInsets = AxisConstants.DEFAULT_AXIS_LABEL_INSETS;
        this.labelAngle = 0.0;
        this.tickLabelsVisible = true;
        this.tickLabelFont = AxisConstants.DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaint = AxisConstants.DEFAULT_TICK_LABEL_PAINT;
        this.tickLabelInsets = AxisConstants.DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = AxisConstants.DEFAULT_TICK_MARK_STROKE;
        this.tickMarkPaint = AxisConstants.DEFAULT_TICK_MARK_PAINT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.plot = null;
        this.ticks = new ArrayList();
        this.listenerList = new EventListenerList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.label = string;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.label = string;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getLabelAngle() {
        return this.labelAngle;
    }

    public void setLabelAngle(double d) {
        this.labelAngle = d;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (bl != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl) {
        if (bl != this.tickMarksVisible) {
            this.tickMarksVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float f) {
        this.tickMarkInsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float f) {
        this.tickMarkOutsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Axis.setTickMarkStroke(...): null not permitted.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickMarkPaint(...): null not permitted.");
        }
        if (!this.tickMarkPaint.equals(paint)) {
            this.tickMarkPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public List getTicks() {
        return this.ticks;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) throws PlotNotCompatibleException {
        if (!this.isCompatiblePlot(plot) && plot != null) {
            throw new PlotNotCompatibleException("Axis.setPlot(...): plot not compatible with axis.");
        }
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double d) {
        this.fixedDimension = d;
    }

    public abstract void configure();

    public abstract AxisSpace reserveSpace(Graphics2D var1, Plot var2, Rectangle2D var3, RectangleEdge var4, AxisSpace var5);

    public abstract double draw(Graphics2D var1, double var2, Rectangle2D var4, Rectangle2D var5, RectangleEdge var6);

    public abstract void refreshTicks(Graphics2D var1, double var2, Rectangle2D var4, Rectangle2D var5, RectangleEdge var6);

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
            if (!(rectangle2D2.getWidth() > d)) continue;
            d = rectangle2D2.getWidth();
        }
        return d;
    }

    protected abstract boolean isCompatiblePlot(Plot var1);

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.add(class$org$jfree$chart$event$AxisChangeListener == null ? (class$org$jfree$chart$event$AxisChangeListener = Axis.class$("org.jfree.chart.event.AxisChangeListener")) : class$org$jfree$chart$event$AxisChangeListener, axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.remove(class$org$jfree$chart$event$AxisChangeListener == null ? (class$org$jfree$chart$event$AxisChangeListener = Axis.class$("org.jfree.chart.event.AxisChangeListener")) : class$org$jfree$chart$event$AxisChangeListener, axisChangeListener);
    }

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$org$jfree$chart$event$AxisChangeListener == null ? Axis.class$("org.jfree.chart.event.AxisChangeListener") : class$org$jfree$chart$event$AxisChangeListener)) {
                ((AxisChangeListener)objectArray[n + 1]).axisChanged(axisChangeEvent);
            }
            n -= 2;
        }
    }

    protected Rectangle2D getLabelEnclosure(Graphics2D graphics2D, RectangleEdge rectangleEdge) {
        Rectangle2D rectangle2D = new Rectangle2D.Double();
        String string = this.getLabel();
        if (string != null) {
            Font font = this.getLabelFont();
            Rectangle2D rectangle2D2 = font.getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            rectangle2D2.setRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() + (double)insets.left + (double)insets.right, rectangle2D2.getHeight() + (double)insets.top + (double)insets.bottom);
            double d = this.getLabelAngle();
            if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
                d -= 1.5707963267948966;
            }
            double d2 = rectangle2D2.getCenterX();
            double d3 = rectangle2D2.getCenterY();
            AffineTransform affineTransform = AffineTransform.getRotateInstance(d, d2, d3);
            Shape shape = affineTransform.createTransformedShape(rectangle2D2);
            rectangle2D = shape.getBounds2D();
        }
        return rectangle2D;
    }

    protected double drawLabel(String string, Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (string == null || string.equals("")) {
            return 0.0;
        }
        Font font = this.getLabelFont();
        Insets insets = this.getLabelInsets();
        graphics2D.setFont(font);
        graphics2D.setPaint(this.getLabelPaint());
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        double d2 = 0.0;
        if (rectangleEdge == RectangleEdge.TOP) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d3 = rectangle2D2.getCenterX();
            double d4 = d - (double)insets.bottom - rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d3), (float)((float)d4), (TextAnchor)TextAnchor.CENTER, (TextAnchor)TextAnchor.CENTER, (double)this.getLabelAngle());
            d2 = (double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom;
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle(), rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d5 = rectangle2D2.getCenterX();
            double d6 = d + (double)insets.top + rectangle2D3.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d5), (float)((float)d6), (TextAnchor)TextAnchor.CENTER, (TextAnchor)TextAnchor.CENTER, (double)this.getLabelAngle());
            d2 = (double)insets.top + rectangle2D3.getHeight() + (double)insets.bottom;
        } else if (rectangleEdge == RectangleEdge.LEFT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() - 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d7 = d - (double)insets.right - rectangle2D3.getWidth() / 2.0;
            double d8 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d7), (float)((float)d8), (TextAnchor)TextAnchor.CENTER, (TextAnchor)TextAnchor.CENTER, (double)(this.getLabelAngle() - 1.5707963267948966));
            d2 = (double)insets.left + rectangle2D3.getWidth() + (double)insets.right;
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            AffineTransform affineTransform = AffineTransform.getRotateInstance(this.getLabelAngle() + 1.5707963267948966, rectangle2D3.getCenterX(), rectangle2D3.getCenterY());
            Shape shape = affineTransform.createTransformedShape(rectangle2D3);
            rectangle2D3 = shape.getBounds2D();
            double d9 = d + (double)insets.left + rectangle2D3.getWidth() / 2.0;
            double d10 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0;
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d9), (float)((float)d10), (TextAnchor)TextAnchor.CENTER, (TextAnchor)TextAnchor.CENTER, (double)(this.getLabelAngle() + 1.5707963267948966));
            d2 = (double)insets.left + rectangle2D3.getWidth() + (double)insets.right;
        }
        return d2;
    }

    public Object clone() throws CloneNotSupportedException {
        Axis axis = (Axis)super.clone();
        if (this.labelInsets != null) {
            axis.labelInsets = (Insets)this.labelInsets.clone();
        }
        if (this.tickLabelInsets != null) {
            axis.tickLabelInsets = (Insets)this.tickLabelInsets.clone();
        }
        return axis;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof Axis) {
            Axis axis = (Axis)object;
            boolean bl = this.visible == axis.visible;
            boolean bl2 = ObjectUtils.equal((Object)this.label, (Object)axis.label);
            boolean bl3 = ObjectUtils.equal((Object)this.labelFont, (Object)axis.labelFont);
            boolean bl4 = ObjectUtils.equal((Object)this.labelPaint, (Object)axis.labelPaint);
            boolean bl5 = ObjectUtils.equal((Object)this.labelInsets, (Object)axis.labelInsets);
            boolean bl6 = Math.abs(this.labelAngle - axis.labelAngle) < 1.0E-7;
            boolean bl7 = this.tickLabelsVisible == axis.tickLabelsVisible;
            boolean bl8 = ObjectUtils.equal((Object)this.tickLabelFont, (Object)axis.tickLabelFont);
            boolean bl9 = ObjectUtils.equal((Object)this.tickLabelPaint, (Object)axis.tickLabelPaint);
            boolean bl10 = ObjectUtils.equal((Object)this.tickLabelInsets, (Object)axis.tickLabelInsets);
            boolean bl11 = this.tickMarksVisible == axis.tickMarksVisible;
            boolean bl12 = (double)Math.abs(this.tickMarkInsideLength - axis.tickMarkInsideLength) < 1.0E-6;
            boolean bl13 = (double)Math.abs(this.tickMarkOutsideLength - axis.tickMarkOutsideLength) < 1.0E-6;
            boolean bl14 = ObjectUtils.equal((Object)this.tickMarkPaint, (Object)axis.tickMarkPaint);
            boolean bl15 = ObjectUtils.equal((Object)this.tickMarkStroke, (Object)axis.tickMarkStroke);
            boolean bl16 = Math.abs(this.fixedDimension - axis.fixedDimension) < 1.0E-6;
            return bl && bl2 && bl3 && bl4 && bl5 && bl7 && bl8 && bl9 && bl10 && bl11 && bl12 && bl13 && bl14 && bl15 && bl16 && bl6;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint((Paint)this.labelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.tickLabelPaint, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writeStroke((Stroke)this.tickMarkStroke, (ObjectOutputStream)objectOutputStream);
        SerialUtilities.writePaint((Paint)this.tickMarkPaint, (ObjectOutputStream)objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.labelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.tickLabelPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.tickMarkStroke = SerialUtilities.readStroke((ObjectInputStream)objectInputStream);
        this.tickMarkPaint = SerialUtilities.readPaint((ObjectInputStream)objectInputStream);
        this.listenerList = new EventListenerList();
        this.ticks = new ArrayList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

