/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.Tick;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class NumberAxis3D
extends NumberAxis
implements Serializable {
    public NumberAxis3D() {
        this(null);
    }

    public NumberAxis3D(String string) {
        super(string);
        this.setAxisLineVisible(false);
    }

    public double draw(Graphics2D graphics2D, double d, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, RectangleEdge rectangleEdge) {
        if (!this.isVisible()) {
            this.refreshTicks(graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
            return 0.0;
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        Effect3D effect3D = (Effect3D)((Object)categoryPlot.getRenderer());
        double d2 = rectangle2D2.getMinX();
        double d3 = rectangle2D2.getMinY();
        double d4 = rectangle2D2.getWidth() - effect3D.getXOffset();
        double d5 = rectangle2D2.getHeight() - effect3D.getYOffset();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d3 + effect3D.getYOffset(), d4, d5);
        if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.BOTTOM) {
            d3 += effect3D.getYOffset();
        } else if (rectangleEdge == RectangleEdge.RIGHT || rectangleEdge == RectangleEdge.TOP) {
            d2 += effect3D.getXOffset();
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d3, d4, d5);
        this.refreshTicks(graphics2D, d, rectangle2D, double_2, rectangleEdge);
        double d6 = this.getTickMarkOutsideLength();
        double d7 = this.getTickMarkInsideLength();
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), double_2, rectangleEdge);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                if (this.isVerticalTickLabels()) {
                    RefineryUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)graphics2D, (float)tick.getX(), (float)tick.getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            Line2D.Double double_3 = null;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            if (rectangleEdge == RectangleEdge.LEFT) {
                double_3 = new Line2D.Double(d - d6, f, d + d7, f);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                double_3 = new Line2D.Double(d + d6, f, d - d7, f);
            } else if (rectangleEdge == RectangleEdge.TOP) {
                double_3 = new Line2D.Double(f, d - d6, f, d + d7);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                double_3 = new Line2D.Double(f, d + d6, f, d - d7);
            }
            graphics2D.draw(double_3);
        }
        double d8 = this.reservedForTickLabels;
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.LEFT) {
            d -= d8;
        } else if (rectangleEdge == RectangleEdge.BOTTOM || rectangleEdge == RectangleEdge.RIGHT) {
            d += d8;
        }
        double d9 = this.drawLabel(this.getLabel(), graphics2D, d, rectangle2D, rectangle2D2, rectangleEdge);
        return d8 + d9;
    }
}

