/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.Range;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtils;

public class CombinedRangeCategoryPlot
extends CategoryPlot
implements Cloneable,
Serializable {
    private List subplots = new ArrayList();
    private int totalWeight = 0;
    private double gap = 5.0;
    private transient Rectangle2D[] subplotArea;

    public CombinedRangeCategoryPlot(ValueAxis valueAxis) {
        super(null, null, valueAxis, null);
    }

    public void add(CategoryPlot categoryPlot, int n) {
        categoryPlot.setParent(this);
        categoryPlot.setWeight(n);
        categoryPlot.setInsets(new Insets(0, 0, 0, 0));
        categoryPlot.setRangeAxis(null);
        categoryPlot.setOrientation(this.getOrientation());
        this.subplots.add(categoryPlot);
        this.totalWeight += n;
        ValueAxis valueAxis = this.getRangeAxis();
        if (valueAxis != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void remove(CategoryPlot categoryPlot) {
        ValueAxis valueAxis;
        this.subplots.remove(categoryPlot);
        categoryPlot.setParent(null);
        this.totalWeight -= categoryPlot.getWeight();
        ValueAxis valueAxis2 = this.getRangeAxis();
        if (valueAxis2 != null) {
            valueAxis2.configure();
        }
        if ((valueAxis = this.getSecondaryRangeAxis(0)) != null) {
            valueAxis.configure();
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public List getSubplots() {
        return Collections.unmodifiableList(this.subplots);
    }

    protected AxisSpace calculateAxisSpace(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Cloneable cloneable;
        AxisSpace axisSpace = new AxisSpace();
        PlotOrientation plotOrientation = this.getOrientation();
        AxisSpace axisSpace2 = this.getFixedRangeAxisSpace();
        if (axisSpace2 != null) {
            if (plotOrientation == PlotOrientation.VERTICAL) {
                axisSpace.setLeft(axisSpace2.getLeft());
                axisSpace.setRight(axisSpace2.getRight());
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                axisSpace.setTop(axisSpace2.getTop());
                axisSpace.setBottom(axisSpace2.getBottom());
            }
        } else {
            cloneable = this.getRangeAxis();
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.getRangeAxisLocation(), plotOrientation);
            if (cloneable != null) {
                axisSpace = ((Axis)cloneable).reserveSpace(graphics2D, this, rectangle2D, rectangleEdge, axisSpace);
            }
        }
        cloneable = axisSpace.shrink(rectangle2D, null);
        int n = this.subplots.size();
        this.subplotArea = new Rectangle2D[n];
        double d = ((RectangularShape)cloneable).getX();
        double d2 = ((RectangularShape)cloneable).getY();
        double d3 = 0.0;
        if (plotOrientation == PlotOrientation.VERTICAL) {
            d3 = ((RectangularShape)cloneable).getWidth() - this.gap * (double)(n - 1);
        } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d3 = ((RectangularShape)cloneable).getHeight() - this.gap * (double)(n - 1);
        }
        int n2 = 0;
        while (n2 < n) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(n2);
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double d4 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotArea[n2] = new Rectangle2D.Double(d, d2, d4, ((RectangularShape)cloneable).getHeight());
                d = d + d4 + this.gap;
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double d5 = d3 * (double)categoryPlot.getWeight() / (double)this.totalWeight;
                this.subplotArea[n2] = new Rectangle2D.Double(d, d2, ((RectangularShape)cloneable).getWidth(), d5);
                d2 = d2 + d5 + this.gap;
            }
            AxisSpace axisSpace3 = categoryPlot.calculateDomainAxisSpace(graphics2D, this.subplotArea[n2], null);
            axisSpace.ensureAtLeast(axisSpace3);
            ++n2;
        }
        return axisSpace;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Insets insets;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        AxisSpace axisSpace = this.calculateAxisSpace(graphics2D, rectangle2D);
        Rectangle2D rectangle2D2 = axisSpace.shrink(rectangle2D, null);
        this.setFixedDomainAxisSpaceForSubplots(axisSpace);
        int n = 0;
        while (n < this.subplots.size()) {
            object = (CategoryPlot)this.subplots.get(n);
            ((CategoryPlot)object).draw(graphics2D, this.subplotArea[n], chartRenderingInfo);
            ++n;
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea(rectangle2D2);
        }
        object = this.getRangeAxisEdge();
        double d = RectangleEdge.coordinate((Rectangle2D)rectangle2D2, (RectangleEdge)object);
        d = this.getRangeAxis().draw(graphics2D, d, rectangle2D, rectangle2D2, this.getRangeAxisEdge());
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        super.setOrientation(plotOrientation);
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setOrientation(plotOrientation);
        }
    }

    public Range getDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                range = Range.combine(range, categoryPlot.getDataRange(valueAxis));
            }
        }
        return range;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    protected void setFixedDomainAxisSpaceForSubplots(AxisSpace axisSpace) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
            categoryPlot.setFixedDomainAxisSpace(axisSpace);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CombinedRangeCategoryPlot) {
            CombinedRangeCategoryPlot combinedRangeCategoryPlot = (CombinedRangeCategoryPlot)object;
            if (super.equals(object)) {
                boolean bl = ObjectUtils.equal((Object)this.subplots, (Object)combinedRangeCategoryPlot.subplots);
                boolean bl2 = this.totalWeight == combinedRangeCategoryPlot.totalWeight;
                boolean bl3 = this.gap == combinedRangeCategoryPlot.gap;
                return bl && bl2 && bl3;
            }
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

