/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.needle.ArrowNeedle;
import org.jfree.chart.needle.LineNeedle;
import org.jfree.chart.needle.LongNeedle;
import org.jfree.chart.needle.MeterNeedle;
import org.jfree.chart.needle.PinNeedle;
import org.jfree.chart.needle.PlumNeedle;
import org.jfree.chart.needle.PointerNeedle;
import org.jfree.chart.needle.ShipNeedle;
import org.jfree.chart.needle.WindNeedle;
import org.jfree.chart.plot.Plot;
import org.jfree.data.DefaultValueDataset;
import org.jfree.data.ValueDataset;
import org.jfree.util.ObjectUtils;

public class CompassPlot
extends Plot
implements Cloneable,
Serializable {
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 1, 10);
    public static final int NO_LABELS = 0;
    public static final int VALUE_LABELS = 1;
    private int labelType;
    private Font labelFont;
    private boolean drawBorder = false;
    private Paint roseHighlightPaint = Color.black;
    private Paint rosePaint = Color.yellow;
    private Paint roseCenterPaint = Color.white;
    private Font compassFont = new Font("Arial", 0, 10);
    private transient Ellipse2D circle1;
    private transient Ellipse2D circle2;
    private transient Area a1;
    private transient Area a2;
    private transient Rectangle2D rect1;
    private ValueDataset[] datasets = new ValueDataset[1];
    private MeterNeedle[] seriesNeedle = new MeterNeedle[1];
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");

    public CompassPlot() {
        this(new DefaultValueDataset());
    }

    public CompassPlot(ValueDataset valueDataset) {
        if (valueDataset != null) {
            this.datasets[0] = valueDataset;
            valueDataset.addChangeListener(this);
        }
        this.circle1 = new Ellipse2D.Double();
        this.circle2 = new Ellipse2D.Double();
        this.rect1 = new Rectangle2D.Double();
        this.setSeriesNeedle(0);
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setLabelType(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("MeterPlot.setLabelType(int): unrecognised type.");
        }
        if (this.labelType != n) {
            this.labelType = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("MeterPlot.setLabelFont(...): null font not allowed.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getDrawBorder() {
        return this.drawBorder;
    }

    public void setDrawBorder(boolean bl) {
        this.drawBorder = bl;
    }

    public void setSeriesPaint(int n, Paint paint) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setFillPaint(paint);
        }
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlinePaint(paint);
        }
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        if (n >= 0 && n < this.seriesNeedle.length) {
            this.seriesNeedle[n].setOutlineStroke(stroke);
        }
    }

    public void setSeriesNeedle(int n) {
        this.setSeriesNeedle(0, n);
    }

    public void setSeriesNeedle(int n, int n2) {
        switch (n2) {
            case 0: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
                this.setSeriesPaint(n, Color.red);
                this.seriesNeedle[n].setHighlightPaint(Color.white);
                break;
            }
            case 1: {
                this.setSeriesNeedle(n, new LineNeedle());
                break;
            }
            case 2: {
                this.setSeriesNeedle(n, new LongNeedle());
                break;
            }
            case 3: {
                this.setSeriesNeedle(n, new PinNeedle());
                break;
            }
            case 4: {
                this.setSeriesNeedle(n, new PlumNeedle());
                break;
            }
            case 5: {
                this.setSeriesNeedle(n, new PointerNeedle());
                break;
            }
            case 6: {
                this.setSeriesPaint(n, null);
                this.setSeriesOutlineStroke(n, new BasicStroke(3.0f));
                this.setSeriesNeedle(n, new ShipNeedle());
                break;
            }
            case 7: {
                this.setSeriesPaint(n, Color.blue);
                this.setSeriesNeedle(n, new WindNeedle());
                break;
            }
            case 8: {
                this.setSeriesNeedle(n, new ArrowNeedle(true));
                break;
            }
            default: {
                String string = "CompassPlot.setSeriesNeedle(...): unrecognised type.";
                throw new IllegalArgumentException(string);
            }
        }
    }

    public void setSeriesNeedle(int n, MeterNeedle meterNeedle) {
        if (meterNeedle != null && n < this.seriesNeedle.length) {
            this.seriesNeedle[n] = meterNeedle;
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueDataset[] getData() {
        return this.datasets;
    }

    public void addData(ValueDataset valueDataset) {
        this.addData(valueDataset, null);
    }

    public void addData(ValueDataset valueDataset, MeterNeedle meterNeedle) {
        if (valueDataset != null) {
            int n = this.datasets.length + 1;
            ValueDataset[] valueDatasetArray = new ValueDataset[n];
            MeterNeedle[] meterNeedleArray = new MeterNeedle[n];
            n -= 2;
            while (n >= 0) {
                valueDatasetArray[n] = this.datasets[n];
                meterNeedleArray[n] = this.seriesNeedle[n];
                --n;
            }
            n = this.datasets.length;
            valueDatasetArray[n] = valueDataset;
            meterNeedleArray[n] = meterNeedle != null ? meterNeedle : meterNeedleArray[n - 1];
            ValueDataset[] valueDatasetArray2 = this.datasets;
            MeterNeedle[] meterNeedleArray2 = this.seriesNeedle;
            this.datasets = valueDatasetArray;
            this.seriesNeedle = meterNeedleArray;
            --n;
            while (n >= 0) {
                valueDatasetArray2[n] = null;
                meterNeedleArray2[n] = null;
                --n;
            }
            valueDataset.addChangeListener(this);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Serializable serializable;
        int n;
        double d;
        Insets insets;
        int n2 = 0;
        int n3 = 0;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (this.drawBorder) {
            this.drawBackground(graphics2D, rectangle2D);
        }
        int n4 = (int)(rectangle2D.getWidth() / 2.0);
        int n5 = (int)(rectangle2D.getHeight() / 2.0);
        int n6 = n4;
        if (n5 < n4) {
            n6 = n5;
        }
        int n7 = 2 * --n6;
        this.circle1.setFrame((n4 += (int)rectangle2D.getMinX()) - n6, (n5 += (int)rectangle2D.getMinY()) - n6, n7, n7);
        this.circle2.setFrame(n4 - n6 + 15, n5 - n6 + 15, n7 - 30, n7 - 30);
        graphics2D.setPaint(this.rosePaint);
        this.a1 = new Area(this.circle1);
        this.a2 = new Area(this.circle2);
        this.a1.subtract(this.a2);
        graphics2D.fill(this.a1);
        graphics2D.setPaint(this.roseCenterPaint);
        int n8 = n7 - 30;
        graphics2D.fillOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        graphics2D.setPaint(this.roseHighlightPaint);
        graphics2D.drawOval(n4 - n6, n5 - n6, n7, n7);
        n8 = n7 - 20;
        graphics2D.drawOval(n4 - n6 + 10, n5 - n6 + 10, n8, n8);
        n8 = n7 - 30;
        graphics2D.drawOval(n4 - n6 + 15, n5 - n6 + 15, n8, n8);
        n8 = n7 - 80;
        graphics2D.drawOval(n4 - n6 + 40, n5 - n6 + 40, n8, n8);
        n2 = n6 - 20;
        n3 = n6 - 32;
        int n9 = 0;
        while (n9 < 360) {
            d = Math.toRadians(n9);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            int n10 = n4 - (int)(Math.sin(d) * (double)n2);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            int n11 = n5 - (int)(Math.cos(d) * (double)n2);
            graphics2D.drawLine(n8, n, n10, n11);
            n9 += 15;
        }
        graphics2D.setPaint(this.roseHighlightPaint);
        n3 = n6 - 26;
        n2 = 7;
        int n12 = 45;
        while (n12 < 360) {
            d = Math.toRadians(n12);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            graphics2D.fillOval(n8 - n2, n - n2, 2 * n2, 2 * n2);
            n12 += 90;
        }
        int n13 = 0;
        while (n13 < 360) {
            d = Math.toRadians(n13);
            n8 = n4 - (int)(Math.sin(d) * (double)n3);
            n = n5 - (int)(Math.cos(d) * (double)n3);
            serializable = new Polygon();
            ((Polygon)serializable).addPoint(n8 - n2, n);
            ((Polygon)serializable).addPoint(n8, n + n2);
            ((Polygon)serializable).addPoint(n8 + n2, n);
            ((Polygon)serializable).addPoint(n8, n - n2);
            graphics2D.fillPolygon((Polygon)serializable);
            n13 += 90;
        }
        n3 = n6 - 42;
        serializable = this.getCompassFont(n6);
        graphics2D.setFont((Font)serializable);
        graphics2D.drawString("N", n4 - 5, n5 - n3 + ((Font)serializable).getSize());
        graphics2D.drawString("S", n4 - 5, n5 + n3 - 5);
        graphics2D.drawString("W", n4 - n3 + 5, n5 + 5);
        graphics2D.drawString("E", n4 + n3 - ((Font)serializable).getSize(), n5 + 5);
        n = n6 / 2;
        n8 = n6 / 6;
        Rectangle2D.Double double_ = new Rectangle2D.Double(n4 - n8, n5 - n, 2 * n8, 2 * n);
        int n14 = this.seriesNeedle.length;
        int n15 = 0;
        double d2 = 0.0;
        int n16 = this.datasets.length - 1;
        while (n16 >= 0) {
            ValueDataset valueDataset = this.datasets[n16];
            if (valueDataset != null) {
                d2 = valueDataset.getValue().doubleValue() % 360.0;
                n15 = n16 % n14;
                this.seriesNeedle[n15].draw(graphics2D, double_, d2);
            }
            --n16;
        }
        if (this.drawBorder) {
            this.drawOutline(graphics2D, rectangle2D);
        }
    }

    public String getPlotType() {
        return localizationResources.getString("Compass_Plot");
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public void zoom(double d) {
    }

    protected Font getCompassFont(int n) {
        float f = n / 10;
        if (f < 8.0f) {
            f = 8.0f;
        }
        Font font = this.compassFont.deriveFont(f);
        return font;
    }

    public List getLegendItemLabels() {
        return null;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof CompassPlot && super.equals(object)) {
            CompassPlot compassPlot = (CompassPlot)object;
            boolean bl = this.labelType == compassPlot.labelType;
            boolean bl2 = ObjectUtils.equal((Object)this.labelFont, (Object)compassPlot.labelFont);
            boolean bl3 = this.drawBorder == compassPlot.drawBorder;
            boolean bl4 = ObjectUtils.equal((Object)this.roseHighlightPaint, (Object)compassPlot.roseHighlightPaint);
            boolean bl5 = ObjectUtils.equal((Object)this.rosePaint, (Object)compassPlot.rosePaint);
            boolean bl6 = ObjectUtils.equal((Object)this.roseCenterPaint, (Object)compassPlot.roseCenterPaint);
            boolean bl7 = ObjectUtils.equal((Object)this.compassFont, (Object)compassPlot.compassFont);
            boolean bl8 = Arrays.equals(this.seriesNeedle, compassPlot.seriesNeedle);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6 && bl7 && bl8;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        CompassPlot compassPlot = (CompassPlot)super.clone();
        compassPlot.circle1 = (Ellipse2D)this.circle1.clone();
        compassPlot.circle2 = (Ellipse2D)this.circle2.clone();
        compassPlot.a1 = (Area)this.a1.clone();
        compassPlot.a2 = (Area)this.a2.clone();
        compassPlot.rect1 = (Rectangle2D)this.rect1.clone();
        compassPlot.datasets = (ValueDataset[])this.datasets.clone();
        compassPlot.seriesNeedle = (MeterNeedle[])this.seriesNeedle.clone();
        return this.clone();
    }
}

