/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.ItemLabelAnchor;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class BarRenderer
extends AbstractCategoryItemRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    public static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    private double itemMargin = 0.2;
    private boolean drawBarOutline = true;
    private double upperClip;
    private double lowerClip;
    private double itemLabelAnchorOffset = 2.0;
    private transient double barWidth;

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.firePropertyChanged("ItemMargin", null, null);
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl) {
        this.drawBarOutline = bl;
        this.firePropertyChanged("DrawBarOutline", null, null);
    }

    public double getItemLabelAnchorOffset() {
        return this.itemLabelAnchorOffset;
    }

    public void setItemLabelAnchorOffset(double d) {
        this.itemLabelAnchorOffset = d;
        this.firePropertyChanged("ItemLabelAnchorOffset", null, null);
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    protected void setBarWidth(double d) {
        this.barWidth = d;
    }

    public double getLowerClip() {
        return this.lowerClip;
    }

    public double getUpperClip() {
        return this.upperClip;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, n, chartRenderingInfo);
        ValueAxis valueAxis = this.getRangeAxis(categoryPlot, n);
        this.lowerClip = valueAxis.getRange().getLowerBound();
        this.upperClip = valueAxis.getRange().getUpperBound();
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d3 = this.getItemMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2 - d3);
            if (n3 * n2 > 0) {
                this.setBarWidth(d4 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBarWidth(d4);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    protected void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Object object2;
        double d;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d2 = number.doubleValue();
        double d3 = 0.0;
        double d4 = this.getLowerClip();
        double d5 = this.getUpperClip();
        if (d5 <= 0.0) {
            if (d2 >= d5) {
                return;
            }
            d3 = d5;
            if (d2 <= d4) {
                d2 = d4;
            }
        } else if (d4 <= 0.0) {
            if (d2 >= d5) {
                d2 = d5;
            } else if (d2 <= d4) {
                d2 = d4;
            }
        } else {
            if (d2 <= d4) {
                return;
            }
            d3 = d4;
            if (d2 >= d5) {
                d2 = d5;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.translateValueToJava2D(d2, rectangle2D, rectangleEdge);
        double d8 = Math.min(d6, d7);
        double d9 = Math.abs(d7 - d6);
        double d10 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d10 += (double)n * (this.getBarWidth() + d);
        } else {
            d10 += (double)n * this.getBarWidth();
        }
        d = this.getBarWidth();
        Rectangle2D.Double double_ = new Rectangle2D.Double(d8, d10, d9, d);
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && this.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, d6 > d7);
        }
        if (this.getInfo() != null && (object = this.getInfo().getEntityCollection()) != null) {
            String string = null;
            if (object2 != null) {
                string = object2.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object.addEntity(categoryItemEntity);
        }
    }

    protected void drawItemLabel(Graphics2D graphics2D, CategoryDataset categoryDataset, int n, int n2, CategoryPlot categoryPlot, CategoryItemLabelGenerator categoryItemLabelGenerator, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getItemLabelFont(n, n2);
        graphics2D.setFont(font);
        Paint paint = this.getItemLabelPaint(n, n2);
        graphics2D.setPaint(paint);
        String string = categoryItemLabelGenerator.generateItemLabel(categoryDataset, n, n2);
        ItemLabelAnchor itemLabelAnchor = this.getItemLabelAnchor(n, n2);
        TextAnchor textAnchor = this.getItemLabelTextAnchor(n, n2);
        TextAnchor textAnchor2 = this.getItemLabelRotationAnchor(n, n2);
        double d = this.getItemLabelAngle(n, n2).doubleValue();
        if (bl) {
            itemLabelAnchor = ItemLabelAnchor.getHorizontalOpposite(itemLabelAnchor);
            textAnchor = TextAnchor.getHorizontalOpposite((TextAnchor)textAnchor);
            textAnchor2 = TextAnchor.getHorizontalOpposite((TextAnchor)textAnchor2);
        }
        Point2D point2D = this.calculateLabelAnchorPoint(itemLabelAnchor, rectangle2D, categoryPlot.getOrientation());
        RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)textAnchor, (TextAnchor)textAnchor2, (double)d);
    }

    protected void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        double d;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d2 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d2 += (double)n * (this.getBarWidth() + d);
        } else {
            d2 += (double)n * this.getBarWidth();
        }
        d = number.doubleValue();
        double d3 = 0.0;
        double d4 = this.getLowerClip();
        double d5 = this.getUpperClip();
        if (d5 <= 0.0) {
            if (d >= d5) {
                return;
            }
            d3 = d5;
            if (d <= d4) {
                d = d4;
            }
        } else if (d4 <= 0.0) {
            if (d >= d5) {
                d = d5;
            } else if (d <= d4) {
                d = d4;
            }
        } else {
            if (d <= d4) {
                return;
            }
            d3 = this.getLowerClip();
            if (d >= d5) {
                d = d5;
            }
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d6 = valueAxis.translateValueToJava2D(d3, rectangle2D, rectangleEdge);
        double d7 = valueAxis.translateValueToJava2D(d, rectangle2D, rectangleEdge);
        double d8 = Math.min(d7, d6);
        double d9 = this.getBarWidth();
        double d10 = Math.abs(d7 - d6);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d8, d9, d10);
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && this.getBarWidth() > 3.0) {
            object4 = this.getItemOutlineStroke(n, n2);
            object3 = this.getItemOutlinePaint(n, n2);
            if (object4 != null && object3 != null) {
                graphics2D.setStroke((Stroke)object4);
                graphics2D.setPaint((Paint)object3);
                graphics2D.draw(double_);
            }
        }
        if ((object4 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            object3 = this.getItemLabelFont(n, n2);
            graphics2D.setFont((Font)object3);
            object2 = this.getItemLabelPaint(n, n2);
            graphics2D.setPaint((Paint)object2);
            string = object4.generateItemLabel(categoryDataset, n, n2);
            object = this.getItemLabelAnchor(n, n2);
            TextAnchor textAnchor = this.getItemLabelTextAnchor(n, n2);
            TextAnchor textAnchor2 = this.getItemLabelRotationAnchor(n, n2);
            if (d7 > d6) {
                object = ItemLabelAnchor.getVerticalOpposite((ItemLabelAnchor)object);
                textAnchor = TextAnchor.getVerticalOpposite((TextAnchor)textAnchor);
                textAnchor2 = TextAnchor.getVerticalOpposite((TextAnchor)textAnchor2);
            }
            double d11 = this.getItemLabelAngle(n, n2).doubleValue();
            Point2D point2D = this.calculateLabelAnchorPoint((ItemLabelAnchor)object, double_, PlotOrientation.VERTICAL);
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)point2D.getX()), (float)((float)point2D.getY()), (TextAnchor)textAnchor, (TextAnchor)textAnchor2, (double)d11);
        }
        if (this.getInfo() != null && (object3 = this.getInfo().getEntityCollection()) != null) {
            object2 = null;
            if (object4 != null) {
                object2 = object4.generateToolTip(categoryDataset, n, n2);
            }
            string = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            object = new CategoryItemEntity(double_, (String)object2, string, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            object3.addEntity((ChartEntity)object);
        }
    }

    private Point2D calculateLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D, PlotOrientation plotOrientation) {
        Point2D point2D = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            point2D = this.getHorizontalLabelAnchorPoint(itemLabelAnchor, rectangle2D);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            point2D = this.getVerticalLabelAnchorPoint(itemLabelAnchor, rectangle2D);
        }
        return point2D;
    }

    private Point2D getHorizontalLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D) {
        Point2D.Double double_ = null;
        double d = rectangle2D.getX() - this.itemLabelAnchorOffset;
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getX() + this.itemLabelAnchorOffset;
        double d4 = rectangle2D.getCenterX();
        double d5 = rectangle2D.getMaxX() - this.itemLabelAnchorOffset;
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMaxX() + this.itemLabelAnchorOffset;
        double d8 = rectangle2D.getMaxY() + this.itemLabelAnchorOffset;
        double d9 = rectangle2D.getMaxY();
        double d10 = rectangle2D.getMaxY() - this.itemLabelAnchorOffset;
        double d11 = rectangle2D.getCenterY();
        double d12 = rectangle2D.getMinY() + this.itemLabelAnchorOffset;
        double d13 = rectangle2D.getMinY();
        double d14 = rectangle2D.getMinY() - this.itemLabelAnchorOffset;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d5, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d5, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d4, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d3, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d3, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d3, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d3, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d3, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d4, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d5, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d7, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d6, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d4, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d2, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d2, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d4, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d6, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d7, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d7, d11);
        }
        return double_;
    }

    private Point2D getVerticalLabelAnchorPoint(ItemLabelAnchor itemLabelAnchor, Rectangle2D rectangle2D) {
        Point2D.Double double_ = null;
        double d = rectangle2D.getX() - this.itemLabelAnchorOffset;
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getX() + this.itemLabelAnchorOffset;
        double d4 = rectangle2D.getCenterX();
        double d5 = rectangle2D.getMaxX() - this.itemLabelAnchorOffset;
        double d6 = rectangle2D.getMaxX();
        double d7 = rectangle2D.getMaxX() + this.itemLabelAnchorOffset;
        double d8 = rectangle2D.getMaxY() + this.itemLabelAnchorOffset;
        double d9 = rectangle2D.getMaxY();
        double d10 = rectangle2D.getMaxY() - this.itemLabelAnchorOffset;
        double d11 = rectangle2D.getCenterY();
        double d12 = rectangle2D.getMinY() + this.itemLabelAnchorOffset;
        double d13 = rectangle2D.getMinY();
        double d14 = rectangle2D.getMinY() - this.itemLabelAnchorOffset;
        if (itemLabelAnchor == ItemLabelAnchor.CENTER) {
            double_ = new Point2D.Double(d4, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE1) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE2) {
            double_ = new Point2D.Double(d5, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE3) {
            double_ = new Point2D.Double(d5, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE4) {
            double_ = new Point2D.Double(d5, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE5) {
            double_ = new Point2D.Double(d5, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE6) {
            double_ = new Point2D.Double(d4, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE7) {
            double_ = new Point2D.Double(d3, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE8) {
            double_ = new Point2D.Double(d3, d10);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE9) {
            double_ = new Point2D.Double(d3, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE10) {
            double_ = new Point2D.Double(d3, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE11) {
            double_ = new Point2D.Double(d3, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.INSIDE12) {
            double_ = new Point2D.Double(d4, d12);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE1) {
            double_ = new Point2D.Double(d6, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE2) {
            double_ = new Point2D.Double(d7, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE3) {
            double_ = new Point2D.Double(d7, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE4) {
            double_ = new Point2D.Double(d7, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE5) {
            double_ = new Point2D.Double(d6, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE6) {
            double_ = new Point2D.Double(d4, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE7) {
            double_ = new Point2D.Double(d2, d8);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE8) {
            double_ = new Point2D.Double(d, d9);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE9) {
            double_ = new Point2D.Double(d, d11);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE10) {
            double_ = new Point2D.Double(d, d13);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE11) {
            double_ = new Point2D.Double(d2, d14);
        } else if (itemLabelAnchor == ItemLabelAnchor.OUTSIDE12) {
            double_ = new Point2D.Double(d4, d14);
        }
        return double_;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (super.equals(object) && object instanceof BarRenderer) {
            BarRenderer barRenderer = (BarRenderer)object;
            boolean bl = this.itemMargin == barRenderer.itemMargin;
            boolean bl2 = this.drawBarOutline == barRenderer.drawBarOutline;
            boolean bl3 = this.itemLabelAnchorOffset == barRenderer.itemLabelAnchorOffset;
            return bl && bl2 && bl3;
        }
        return false;
    }
}

