/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.AreaRenderer;
import org.jfree.chart.renderer.RangeType;
import org.jfree.data.CategoryDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedAreaRenderer
extends AreaRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    public RangeType getRangeType() {
        return RangeType.STACKED;
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d2 = 0.0;
        double d3 = number.doubleValue();
        graphics2D.setPaint(this.getItemPaint(n, n2));
        graphics2D.setStroke(this.getItemStroke(n, n2));
        if (n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
            double d4 = categoryAxis.getCategoryMiddle(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d5 = ((Number)object).doubleValue();
            double d6 = this.getPreviousHeight(categoryDataset, n, n2 - 1);
            double d7 = this.getPreviousHeight(categoryDataset, n, n2);
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            double d8 = valueAxis.translateValueToJava2D(d6, rectangle2D, rectangleEdge);
            double d9 = valueAxis.translateValueToJava2D(d7, rectangle2D, rectangleEdge);
            double d10 = valueAxis.translateValueToJava2D(d5 += d6, rectangle2D, rectangleEdge);
            d2 = valueAxis.translateValueToJava2D(d3 += d7, rectangle2D, rectangleEdge);
            Polygon polygon = null;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                polygon = new Polygon();
                polygon.addPoint((int)d10, (int)d4);
                polygon.addPoint((int)d2, (int)d);
                polygon.addPoint((int)d9, (int)d);
                polygon.addPoint((int)d8, (int)d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                polygon = new Polygon();
                polygon.addPoint((int)d4, (int)d10);
                polygon.addPoint((int)d, (int)d2);
                polygon.addPoint((int)d, (int)d9);
                polygon.addPoint((int)d4, (int)d8);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            graphics2D.fill(polygon);
        }
        if (this.getInfo() != null) {
            object = this.getInfo().getEntityCollection();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d - 3.0, d2 - 3.0, 6.0, 6.0);
            if (object != null && double_ != null) {
                String string = null;
                CategoryItemLabelGenerator categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2);
                if (categoryItemLabelGenerator != null) {
                    string = categoryItemLabelGenerator.generateToolTip(categoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                object.addEntity(categoryItemEntity);
            }
        }
    }

    protected double getPreviousHeight(CategoryDataset categoryDataset, int n, int n2) {
        double d = 0.0;
        int n3 = 0;
        while (n3 < n) {
            Number number = categoryDataset.getValue(n3, n2);
            if (number != null) {
                d += number.doubleValue();
            }
            ++n3;
        }
        return d;
    }
}

