/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.DefaultKeyedValue;
import org.jfree.data.KeyedValue;
import org.jfree.data.KeyedValueComparator;
import org.jfree.data.KeyedValueComparatorType;
import org.jfree.data.KeyedValues;
import org.jfree.util.SortOrder;

public class DefaultKeyedValues
implements KeyedValues,
Cloneable,
Serializable {
    private List data = new ArrayList();

    public int getItemCount() {
        return this.data.size();
    }

    public Number getValue(int n) {
        Number number = null;
        KeyedValue keyedValue = (KeyedValue)this.data.get(n);
        if (keyedValue != null) {
            number = keyedValue.getValue();
        }
        return number;
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        KeyedValue keyedValue = (KeyedValue)this.data.get(n);
        if (keyedValue != null) {
            comparable = keyedValue.getKey();
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        int n2 = 0;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            KeyedValue keyedValue = (KeyedValue)iterator.next();
            if (keyedValue.getKey().equals(comparable)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            KeyedValue keyedValue = (KeyedValue)iterator.next();
            arrayList.add(keyedValue.getKey());
        }
        return arrayList;
    }

    public Number getValue(Comparable comparable) {
        Number number = null;
        int n = this.getIndex(comparable);
        if (n >= 0) {
            number = this.getValue(n);
        }
        return number;
    }

    public void addValue(Comparable comparable, Number number) {
        this.setValue(comparable, number);
    }

    public void setValue(Comparable comparable, Number number) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            DefaultKeyedValue defaultKeyedValue = (DefaultKeyedValue)this.data.get(n);
            defaultKeyedValue.setValue(number);
        } else {
            DefaultKeyedValue defaultKeyedValue = new DefaultKeyedValue(comparable, number);
            this.data.add(defaultKeyedValue);
        }
    }

    public void removeValue(int n) {
        this.data.remove(n);
    }

    public void removeValue(Comparable comparable) {
        int n = this.getIndex(comparable);
        if (n >= 0) {
            this.removeValue(n);
        }
    }

    public void sortByKeys(SortOrder sortOrder) {
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_KEY, sortOrder);
        Collections.sort(this.data, keyedValueComparator);
    }

    public void sortByValues(SortOrder sortOrder) {
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_VALUE, sortOrder);
        Collections.sort(this.data, keyedValueComparator);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof KeyedValues) {
            KeyedValues keyedValues = (KeyedValues)object;
            int n = this.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                Comparable comparable;
                Comparable comparable2 = this.getKey(n2);
                if (comparable2.equals(comparable = keyedValues.getKey(n2))) {
                    Number number = this.getValue(n2);
                    Number number2 = keyedValues.getValue(n2);
                    if (number == null ? number2 != null : !number.equals(number2)) {
                        return false;
                    }
                } else {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)super.clone();
        defaultKeyedValues.data = new ArrayList();
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            DefaultKeyedValue defaultKeyedValue = (DefaultKeyedValue)iterator.next();
            defaultKeyedValues.data.add(defaultKeyedValue.clone());
        }
        return defaultKeyedValues;
    }
}

