/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.data.AbstractDataset;
import org.jfree.data.HistogramBin;
import org.jfree.data.IntervalXYDataset;

public class HistogramDataset
extends AbstractDataset
implements IntervalXYDataset {
    public static final HistogramType FREQUENCY = new HistogramType();
    public static HistogramType RELATIVE_FREQUENCY = new HistogramType();
    public static HistogramType SCALE_AREA_TO_1 = new HistogramType();
    private List list = new ArrayList();
    private HistogramType type = FREQUENCY;

    public void setType(HistogramType histogramType) {
        if (histogramType == null) {
            throw new IllegalArgumentException("HistogramDataset.setType(...):  null not permitted.");
        }
        this.type = histogramType;
    }

    public HistogramType getType() {
        return this.type;
    }

    public void addSeries(String string, double[] dArray, int n) {
        if (dArray == null) {
            throw new IllegalArgumentException("HistogramDataset.addSeries(...): 'values' argument must not be null.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("HistogramDataset.addSeries(...): number of bins must be at least 1");
        }
        Arrays.sort(dArray);
        double d = dArray[0];
        double d2 = dArray[dArray.length - 1];
        double d3 = (d2 - d) / (double)n;
        double d4 = d;
        HistogramBin[] histogramBinArray = new HistogramBin[n];
        int n2 = 0;
        while (n2 < histogramBinArray.length) {
            HistogramBin histogramBin = new HistogramBin(d4, d4 + d3);
            d4 += d3;
            histogramBinArray[n2] = histogramBin;
            ++n2;
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            int n4 = 0;
            while (n4 < histogramBinArray.length) {
                if (dArray[n3] >= histogramBinArray[n4].getStartBoundary() && dArray[n3] <= histogramBinArray[n4].getEndBoundary()) {
                    histogramBinArray[n4].incrementCount();
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("name", string);
        hashMap.put("bins", histogramBinArray);
        hashMap.put("values.length", new Integer(dArray.length));
        hashMap.put("bin width", new Double(d3));
        this.list.add(hashMap);
    }

    private HistogramBin[] getBins(int n) {
        Map map = (Map)this.list.get(n);
        return (HistogramBin[])map.get("bins");
    }

    private int getTotal(int n) {
        Map map = (Map)this.list.get(n);
        return (Integer)map.get("values.length");
    }

    private double getBinWidth(int n) {
        Map map = (Map)this.list.get(n);
        return (Double)map.get("bin width");
    }

    public int getSeriesCount() {
        return this.list.size();
    }

    public String getSeriesName(int n) {
        Map map = (Map)this.list.get(n);
        return (String)map.get("name");
    }

    public int getItemCount(int n) {
        return this.getBins(n).length;
    }

    public Number getXValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        HistogramBin histogramBin = histogramBinArray[n2];
        double d = (histogramBin.getStartBoundary() + histogramBin.getEndBoundary()) / 2.0;
        return new Double(d);
    }

    public Number getYValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        double d = this.getTotal(n);
        double d2 = this.getBinWidth(n);
        if (this.type == FREQUENCY) {
            return new Double(histogramBinArray[n2].getCount());
        }
        if (this.type == RELATIVE_FREQUENCY) {
            return new Double((double)histogramBinArray[n2].getCount() / d);
        }
        if (this.type == SCALE_AREA_TO_1) {
            return new Double((double)histogramBinArray[n2].getCount() / (d2 * d));
        }
        throw new IllegalStateException();
    }

    public Number getStartXValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        return new Double(histogramBinArray[n2].getStartBoundary());
    }

    public Number getEndXValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        return new Double(histogramBinArray[n2].getEndBoundary());
    }

    public Number getStartYValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        HistogramBin[] histogramBinArray = this.getBins(n);
        return this.getYValue(n, n2);
    }

    private static class HistogramType {
        private HistogramType() {
        }
    }
}

