/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.data.statistics.BoxAndWhiskerItem;

public class BoxAndWhiskerCalculator {
    public static BoxAndWhiskerItem calculateBoxAndWhiskerStatistics(List list) {
        Collections.sort(list);
        double d = BoxAndWhiskerCalculator.calculateMean(list);
        double d2 = BoxAndWhiskerCalculator.calculateMedian(list);
        double d3 = BoxAndWhiskerCalculator.calculateQ1(list);
        double d4 = BoxAndWhiskerCalculator.calculateQ3(list);
        double d5 = d4 - d3;
        double d6 = d3 + d5 * 1.5;
        double d7 = d4 - d5 * 1.5;
        double d8 = d3 + d5 * 2.0;
        double d9 = d4 - d5 * 2.0;
        double d10 = Double.POSITIVE_INFINITY;
        double d11 = Double.NEGATIVE_INFINITY;
        double d12 = Double.POSITIVE_INFINITY;
        double d13 = Double.NEGATIVE_INFINITY;
        ArrayList<Number> arrayList = new ArrayList<Number>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !(e instanceof Number)) continue;
            Number number = (Number)e;
            double d14 = number.doubleValue();
            if (d14 > d6) {
                arrayList.add(number);
                if (!(d14 > d13) || !(d14 <= d8)) continue;
                d13 = d14;
                continue;
            }
            if (d14 < d7) {
                arrayList.add(number);
                if (!(d14 < d12) || !(d14 >= d9)) continue;
                d12 = d14;
                continue;
            }
            d10 = d10 == Double.NaN ? d14 : Math.min(d10, d14);
            d11 = d11 == Double.NaN ? d14 : Math.max(d11, d14);
        }
        d12 = Math.min(d12, d10);
        d13 = Math.max(d13, d11);
        return new BoxAndWhiskerItem(new Double(d), new Double(d2), new Double(d3), new Double(d4), new Double(d10), new Double(d11), new Double(d12), new Double(d13), arrayList);
    }

    public static double calculateMean(List list) {
        double d = Double.NaN;
        int n = 0;
        double d2 = 0.0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e == null || !(e instanceof Number)) continue;
            Number number = (Number)e;
            d2 += number.doubleValue();
            ++n;
        }
        if (n > 0) {
            d = d2 / (double)n;
        }
        return d;
    }

    public static double calculateMedian(List list) {
        return BoxAndWhiskerCalculator.calculateMedian(list, 0, list.size() - 1);
    }

    public static double calculateMedian(List list, int n, int n2) {
        double d = Double.NaN;
        int n3 = n2 - n + 1;
        if (n3 > 0) {
            if (n3 % 2 == 1) {
                if (n3 > 1) {
                    Number number = (Number)list.get(n + n3 / 2 + 1);
                    d = number.doubleValue();
                } else {
                    Number number = (Number)list.get(n);
                    d = number.doubleValue();
                }
            } else {
                Number number = (Number)list.get(n + n3 / 2 - 1);
                Number number2 = (Number)list.get(n + n3 / 2);
                d = (number.doubleValue() + number2.doubleValue()) / 2.0;
            }
        }
        return d;
    }

    public static double calculateQ1(List list) {
        double d = Double.NaN;
        int n = list.size();
        if (n > 0) {
            d = n % 2 == 1 ? (n > 1 ? BoxAndWhiskerCalculator.calculateMedian(list, 0, n / 2) : BoxAndWhiskerCalculator.calculateMedian(list, 0, 0)) : BoxAndWhiskerCalculator.calculateMedian(list, 0, n / 2);
        }
        return d;
    }

    public static double calculateQ3(List list) {
        double d = Double.NaN;
        int n = list.size();
        if (n > 0) {
            d = n % 2 == 1 ? (n > 1 ? BoxAndWhiskerCalculator.calculateMedian(list, n / 2 + 1, n - 1) : BoxAndWhiskerCalculator.calculateMedian(list, 0, 0)) : BoxAndWhiskerCalculator.calculateMedian(list, n / 2 + 1, n - 1);
        }
        return d;
    }
}

