/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.time;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.Series;
import org.jfree.data.SeriesException;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimePeriodValue;

public class TimePeriodValues
extends Series
implements Serializable {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private List data;
    private int minStartIndex = -1;
    private int maxStartIndex = -1;
    private int minMiddleIndex = -1;
    private int maxMiddleIndex = -1;
    private int minEndIndex = -1;
    private int maxEndIndex = -1;

    public TimePeriodValues(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION);
    }

    public TimePeriodValues(String string, String string2, String string3) {
        super(string);
        this.domain = string2;
        this.range = string3;
        this.data = new ArrayList();
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public TimePeriodValue getDataItem(int n) {
        return (TimePeriodValue)this.data.get(n);
    }

    public TimePeriod getTimePeriod(int n) {
        return this.getDataItem(n).getPeriod();
    }

    public Number getValue(int n) {
        return this.getDataItem(n).getValue();
    }

    public void add(TimePeriodValue timePeriodValue) throws SeriesException {
        if (timePeriodValue == null) {
            throw new IllegalArgumentException("TimePeriodValues.add(...): null item not allowed.");
        }
        this.data.add(timePeriodValue);
        this.updateBounds(timePeriodValue.getPeriod(), this.data.size() - 1);
    }

    private void updateBounds(TimePeriod timePeriod, int n) {
        long l;
        long l2;
        long l3;
        long l4 = timePeriod.getStart().getTime();
        long l5 = timePeriod.getEnd().getTime();
        long l6 = l4 + (l5 - l4) / 2L;
        if (this.minStartIndex >= 0) {
            l3 = this.getDataItem(this.minStartIndex).getPeriod().getStart().getTime();
            if (l4 < l3) {
                this.minStartIndex = n;
            }
        } else {
            this.minStartIndex = n;
        }
        if (this.maxStartIndex >= 0) {
            l3 = this.getDataItem(this.maxStartIndex).getPeriod().getStart().getTime();
            if (l4 > l3) {
                this.maxStartIndex = n;
            }
        } else {
            this.maxStartIndex = n;
        }
        if (this.minMiddleIndex >= 0) {
            l3 = this.getDataItem(this.minMiddleIndex).getPeriod().getStart().getTime();
            l = l3 + ((l2 = this.getDataItem(this.minMiddleIndex).getPeriod().getEnd().getTime()) - l3) / 2L;
            if (l6 < l) {
                this.minMiddleIndex = n;
            }
        } else {
            this.minMiddleIndex = n;
        }
        if (this.maxMiddleIndex >= 0) {
            l3 = this.getDataItem(this.minMiddleIndex).getPeriod().getStart().getTime();
            l = l3 + ((l2 = this.getDataItem(this.minMiddleIndex).getPeriod().getEnd().getTime()) - l3) / 2L;
            if (l6 > l) {
                this.maxMiddleIndex = n;
            }
        } else {
            this.maxMiddleIndex = n;
        }
        if (this.minEndIndex >= 0) {
            l3 = this.getDataItem(this.minEndIndex).getPeriod().getEnd().getTime();
            if (l5 < l3) {
                this.minEndIndex = n;
            }
        } else {
            this.minEndIndex = n;
        }
        if (this.maxEndIndex >= 0) {
            l3 = this.getDataItem(this.maxEndIndex).getPeriod().getEnd().getTime();
            if (l5 > l3) {
                this.maxEndIndex = n;
            }
        } else {
            this.maxEndIndex = n;
        }
    }

    private void recalculateBounds() {
        int n = 0;
        while (n < this.data.size()) {
            TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(n);
            this.updateBounds(timePeriodValue.getPeriod(), n);
            ++n;
        }
    }

    public void add(TimePeriod timePeriod, double d) throws SeriesException {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, d);
        this.add(timePeriodValue);
    }

    public void add(TimePeriod timePeriod, Number number) throws SeriesException {
        TimePeriodValue timePeriodValue = new TimePeriodValue(timePeriod, number);
        this.add(timePeriodValue);
    }

    public void update(int n, Number number) {
        TimePeriodValue timePeriodValue = this.getDataItem(n);
        timePeriodValue.setValue(number);
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        int n3 = 0;
        while (n3 <= n2 - n) {
            this.data.remove(n);
            ++n3;
        }
        this.recalculateBounds();
        this.fireSeriesChanged();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        boolean bl = super.equals(object);
        if (object instanceof TimePeriodValues) {
            TimePeriodValues timePeriodValues = (TimePeriodValues)object;
            boolean bl2 = this.getDomainDescription().equals(timePeriodValues.getDomainDescription());
            boolean bl3 = this.getRangeDescription().equals(timePeriodValues.getRangeDescription());
            boolean bl4 = bl = bl && bl2 && bl3;
            if (bl) {
                boolean bl5 = true;
                int n = this.getItemCount();
                if (n == timePeriodValues.getItemCount()) {
                    int n2 = 0;
                    while (n2 < n) {
                        boolean bl6 = bl5 = bl5 && this.getDataItem(n2).equals(timePeriodValues.getDataItem(n2));
                        if (!bl5) {
                            // empty if block
                        }
                        ++n2;
                    }
                    bl = bl5;
                } else {
                    bl = false;
                }
            }
        }
        return bl;
    }

    public Object clone() {
        TimePeriodValues timePeriodValues = this.createCopy(0, this.getItemCount() - 1);
        return timePeriodValues;
    }

    public TimePeriodValues createCopy(int n, int n2) {
        TimePeriodValues timePeriodValues = (TimePeriodValues)super.clone();
        timePeriodValues.data = new ArrayList();
        if (this.data.size() > 0) {
            int n3 = n;
            while (n3 <= n2) {
                TimePeriodValue timePeriodValue = (TimePeriodValue)this.data.get(n3);
                TimePeriodValue timePeriodValue2 = (TimePeriodValue)timePeriodValue.clone();
                try {
                    timePeriodValues.add(timePeriodValue2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimePeriodValues.createCopy(): unable to add cloned item.");
                }
                ++n3;
            }
        }
        return timePeriodValues;
    }

    public int getMinStartIndex() {
        return this.minStartIndex;
    }

    public int getMaxStartIndex() {
        return this.maxStartIndex;
    }

    public int getMinMiddleIndex() {
        return this.minMiddleIndex;
    }

    public int getMaxMiddleIndex() {
        return this.maxMiddleIndex;
    }

    public int getMinEndIndex() {
        return this.minEndIndex;
    }

    public int getMaxEndIndex() {
        return this.maxEndIndex;
    }
}

