<?php
/**
 * Application configuration data.  Data here has no GUI to edit it,
 * although most of it can be altered to customise local installations.
 *
 * NOTE: The one-item-per-line and extra-comma-after-last-item approach
 * is used to allow SVN to reliably merge changes for users that have
 * customised their local copy of this file.
 *
 * webtrees: Web based Family History software
 * Copyright (C) 2010 webtrees development team.
 *
 * Derived from PhpGedView
 * Copyright (C) 2010 PGV Development Team.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @version $Id: config_data.php 9968 2010-11-26 09:47:02Z greg $
 */

if (!defined('WT_WEBTREES')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

define('WT_CONFIG_DATA_PHP', '');

// Unknown surname in various scripts
// TODO: This is extremely poor I18N - there is not a 1:1 correlation between script and language
$UNKNOWN_NN=array(
	'hebrew'    =>'(לא-ידוע)',
	'arabic'    =>'(غير معروف)',
	'greek'     =>'(άγνωστος/η)',
	'russian'   =>'(неопределено)',
	'han'       =>'(未知)',
	'latin'     =>i18n::translate_c('surname', '(unknown)'),
	'common'    =>i18n::translate_c('surname', '(unknown)'),
);

// Unknown givne name in various scripts
// TODO: This is extremely poor I18N - there is not a 1:1 correlation between script and language
$UNKNOWN_PN=array(
	'hebrew'    =>'(לא-ידוע)',
	'arabic'    =>'(غير معروف)',
	'greek'     =>'(άγνωστος/η)',
	'russian'   =>'(неопределено)',
	'han'       =>'(未知)',
	'latin'     =>i18n::translate_c('given name', '(unknown)'),
	'common'    =>i18n::translate_c('given name', '(unknown)'),
);

// Type attribute of a media object
$MEDIA_TYPES=array(
	'audio'      =>i18n::translate('Audio'),
	'book'       =>i18n::translate('Book'),
	'card'       =>i18n::translate('Card'),
	'certificate'=>i18n::translate('Certificate'),
	'coat'       =>i18n::translate('Coat of Arms'),
	'document'   =>i18n::translate('Document'),
	'electronic' =>i18n::translate('Electronic'),
	'fiche'      =>i18n::translate('Microfiche'),
	'film'       =>i18n::translate('Microfilm'),
	'magazine'   =>i18n::translate('Magazine'),
	'manuscript' =>i18n::translate('Manuscript'),
	'map'        =>i18n::translate('Map'),
	'newspaper'  =>i18n::translate('Newspaper'),
	'photo'      =>i18n::translate('Photo'),
	'tombstone'  =>i18n::translate('Tombstone'),
	'video'      =>i18n::translate('Video'),
	'painting'   =>i18n::translate('Painting'),
	'other'      =>i18n::translate('Other'),
);

// GEDCOM ADOP codes
$ADOP_CODES=array(
	'BOTH'=>i18n::translate('Adopted by both parents'),
	'HUSB'=>i18n::translate('Adopted by father'),
	'WIFE'=>i18n::translate('Adopted by mother'),
);

// GEDCOM ADOP Female codes
$ADOP_CODES=array(
	'BOTH'=>i18n::translate_c('FEMALE', 'Adopted by both parents'),
	'HUSB'=>i18n::translate_c('FEMALE', 'Adopted by father'),
	'WIFE'=>i18n::translate_c('FEMALE', 'Adopted by mother'),
);

// GEDCOM ADOP Male codes
$ADOP_CODES=array(
	'BOTH'=>i18n::translate_c('MALE', 'Adopted by both parents'),
	'HUSB'=>i18n::translate_c('MALE', 'Adopted by father'),
	'WIFE'=>i18n::translate_c('MALE', 'Adopted by mother'),
);

// GEDCOM PEDI codes
$PEDI_CODES=array(
	'birth'  =>i18n::translate_c('Pedigree', 'Birth'),
	'adopted'=>i18n::translate_c('Pedigree', 'Adopted'),
	'foster' =>i18n::translate_c('Pedigree', 'Foster'),
	'sealing'=>i18n::translate_c('Pedigree', 'Sealing'),
);

// GEDCOM PEDI Female codes
$PEDI_CODES_F=array(
	'birth'  =>i18n::translate_c('Female pedigree', 'Birth'),
	'adopted'=>i18n::translate_c('Female pedigree', 'Adopted'),
	'foster' =>i18n::translate_c('Female pedigree', 'Foster'),
	'sealing'=>i18n::translate_c('Female pedigree', 'Sealing'),
);

// GEDCOM PEDI Male codes
$PEDI_CODES_M=array(
	'birth'  =>i18n::translate_c('Male pedigree', 'Birth'),
	'adopted'=>i18n::translate_c('Male pedigree', 'Adopted'),
	'foster' =>i18n::translate_c('Male pedigree', 'Foster'),
	'sealing'=>i18n::translate_c('Male pedigree', 'Sealing'),
);

// GEDCOM RELA codes for non-genealogical relationships.
// These aren't part of the standard, but we list the common ones here so we can translate them.
$RELA_CODES=array(
	'attendant'       =>i18n::translate('Attendant'),
	'attending'       =>i18n::translate('Attending'),
	'best_man'        =>i18n::translate('Best Man'),
	'bridesmaid'      =>i18n::translate('Bridesmaid'),
	'buyer'           =>i18n::translate('Buyer'),
	'circumciser'     =>i18n::translate('Circumciser'),
	'civil_registrar' =>i18n::translate('Civil Registrar'),
	'employee'        =>i18n::translate('Employee'),
	'employer'        =>i18n::translate('Employer'),
	'foster_child'    =>i18n::translate('Foster Child'),
	'foster_father'   =>i18n::translate('Foster Father'),
	'foster_mother'   =>i18n::translate('Foster Mother'),
	'friend'          =>i18n::translate('Friend'),
	'godfather'       =>i18n::translate('Godfather'),
	'godmother'       =>i18n::translate('Godmother'),
	'godparent'       =>i18n::translate('Godparent'),
	'godson'          =>i18n::translate('Godson'),
	'goddaughter'     =>i18n::translate('Goddaughter'),
	'godchild'        =>i18n::translate('Godchild'),
	'guardian'        =>i18n::translate('Guardian'),
	'informant'       =>i18n::translate('Informant'),
	'lodger'          =>i18n::translate('Lodger'),
	'nanny'           =>i18n::translate('Nanny'),
	'nurse'           =>i18n::translate('Nurse'),
	'owner'           =>i18n::translate('Owner'),
	'priest'          =>i18n::translate('Priest'),
	'rabbi'           =>i18n::translate('Rabbi'),
	'registry_officer'=>i18n::translate('Registry Officer'),
	'seller'          =>i18n::translate('Seller'),
	'servant'         =>i18n::translate('Servant'),
	'slave'           =>i18n::translate('Slave'),
	'ward'            =>i18n::translate('Ward'),
	'witness'         =>i18n::translate('Witness'),
);

// GEDCOM RELA codes for non-genealogical relationships.
// These aren't part of the standard, but we list the common ones here so we can translate them.
$RELA_CODES_F=array(
	'attendant'       =>i18n::translate_c('FEMALE', 'Attendant'),
	'attending'       =>i18n::translate_c('FEMALE', 'Attending'),
	'buyer'           =>i18n::translate_c('FEMALE', 'Buyer'),
	'civil_registrar' =>i18n::translate_c('FEMALE', 'Civil Registrar'),
	'employee'        =>i18n::translate_c('FEMALE', 'Employee'),
	'employer'        =>i18n::translate_c('FEMALE', 'Employer'),
	'friend'          =>i18n::translate_c('FEMALE', 'Friend'),
	'guardian'        =>i18n::translate_c('FEMALE', 'Guardian'),
	'informant'       =>i18n::translate_c('FEMALE', 'Informant'),
	'lodger'          =>i18n::translate_c('FEMALE', 'Lodger'),
	'nurse'           =>i18n::translate_c('FEMALE', 'Nurse'),
	'owner'           =>i18n::translate_c('FEMALE', 'Owner'),
	'registry_officer'=>i18n::translate_c('FEMALE', 'Registry Officer'),
	'seller'          =>i18n::translate_c('FEMALE', 'Seller'),
	'servant'         =>i18n::translate_c('FEMALE', 'Servant'),
	'slave'           =>i18n::translate_c('FEMALE', 'Slave'),
	'ward'            =>i18n::translate_c('FEMALE', 'Ward'),
);

// GEDCOM RELA codes for non-genealogical relationships.
// These aren't part of the standard, but we list the common ones here so we can translate them.
$RELA_CODES_M=array(
	'attendant'       =>i18n::translate_c('MALE', 'Attendant'),
	'attending'       =>i18n::translate_c('MALE', 'Attending'),
	'buyer'           =>i18n::translate_c('MALE', 'Buyer'),
	'civil_registrar' =>i18n::translate_c('MALE', 'Civil Registrar'),
	'employee'        =>i18n::translate_c('MALE', 'Employee'),
	'employer'        =>i18n::translate_c('MALE', 'Employer'),
	'friend'          =>i18n::translate_c('MALE', 'Friend'),
	'guardian'        =>i18n::translate_c('MALE', 'Guardian'),
	'informant'       =>i18n::translate_c('MALE', 'Informant'),
	'lodger'          =>i18n::translate_c('MALE', 'Lodger'),
	'nurse'           =>i18n::translate_c('MALE', 'Nurse'),
	'owner'           =>i18n::translate_c('MALE', 'Owner'),
	'registry_officer'=>i18n::translate_c('MALE', 'Registry Officer'),
	'seller'          =>i18n::translate_c('MALE', 'Seller'),
	'servant'         =>i18n::translate_c('MALE', 'Servant'),
	'slave'           =>i18n::translate_c('MALE', 'Slave'),
	'ward'            =>i18n::translate_c('MALE', 'Ward'),
);

// TEMP tags - LDS temple codes
$TEMPLE_CODES = array(
	'ABA'  =>i18n::translate('Aba, Nigeria'),
	'ACCRA'=>i18n::translate('Accra, Ghana'),
	'ADELA'=>i18n::translate('Adelaide, Australia'),
	'ALBER'=>i18n::translate('Cardston, Alberta, Canada'),
	'ALBUQ'=>i18n::translate('Albuquerque, New Mexico'),
	'ANCHO'=>i18n::translate('Anchorage, Alaska'),
	'ARIZO'=>i18n::translate('Mesa, Arizona'),
	'ASUNC'=>i18n::translate('Asuncion, Paraguay'),
	'ATLAN'=>i18n::translate('Atlanta, Georgia'),
	'BAIRE'=>i18n::translate('Buenos Aires, Argentina'),
	'BILLI'=>i18n::translate('Billings, Montana'),
	'BIRMI'=>i18n::translate('Birmingham, Alabama'),
	'BISMA'=>i18n::translate('Bismarck, North Dakota'),
	'BOGOT'=>i18n::translate('Bogota, Colombia'),
	'BOISE'=>i18n::translate('Boise, Idaho'),
	'BOSTO'=>i18n::translate('Boston, Massachusetts'),
	'BOUNT'=>i18n::translate('Bountiful, Utah'),
	'BRISB'=>i18n::translate('Brisbane, Australia'),
	'BROUG'=>i18n::translate('Baton Rouge, Louisiana'),
	'CAMPI'=>i18n::translate('Campinas, Brazil'),
	'CARAC'=>i18n::translate('Caracas, Venezuela'),
	'CHICA'=>i18n::translate('Chicago, Illinois'),
	'CIUJU'=>i18n::translate('Ciudad Juarez, Mexico'),
	'COCHA'=>i18n::translate('Cochabamba, Bolivia'),
	'COLJU'=>i18n::translate('Colonia Juarez, Mexico'),
	'COLSC'=>i18n::translate('Columbia, South Carolina'),
	'COLUM'=>i18n::translate('Columbus, Ohio'),
	'COPEN'=>i18n::translate('Copenhagen, Denmark'),
	'CRIVE'=>i18n::translate('Columbia River, Washington'),
	'DALLA'=>i18n::translate('Dallas, Texas'),
	'DENVE'=>i18n::translate('Denver, Colorado'),
	'DETRO'=>i18n::translate('Detroit, Michigan'),
	'EDMON'=>i18n::translate('Edmonton, Alberta, Canada'),
	'EHOUS'=> /* I18N: http://en.wikipedia.org/wiki/Endowment_house */ i18n::translate('Endowment House'),
	'FRANK'=>i18n::translate('Frankfurt am Main, Germany'),
	'FREIB'=>i18n::translate('Freiburg, Germany'),
	'FRESN'=>i18n::translate('Fresno, California'),
	'FUKUO'=>i18n::translate('Fukuoka, Japan'),
	'GUADA'=>i18n::translate('Guadalajara, Mexico'),
	'GUATE'=>i18n::translate('Guatemala City, Guatemala'),
	'GUAYA'=>i18n::translate('Guayaquil, Ecuador'),
	'HAGUE'=>i18n::translate('The Hague, Netherlands'),
	'HALIF'=>i18n::translate('Halifax, Nova Scotia, Canada'),
	'HARTF'=>i18n::translate('Hartford, Connecticut'),
	'HAWAI'=>i18n::translate('Laie, Hawaii'),
	'HELSI'=>i18n::translate('Helsinki, Finland'),
	'HERMO'=>i18n::translate('Hermosillo, Mexico'),
	'HKONG'=>i18n::translate('Hong Kong'),
	'HOUST'=>i18n::translate('Houston, Texas'),
	'IFALL'=>i18n::translate('Idaho Falls, Idaho'),
	'JOHAN'=>i18n::translate('Johannesburg, South Africa'),
	'JRIVE'=>i18n::translate('Jordan River, Utah'),
	'KIEV' =>i18n::translate('Kiev, Ukraine'),
	'KONA' =>i18n::translate('Kona, Hawaii'),
	'LANGE'=>i18n::translate('Los Angeles, California'),
	'LIMA' =>i18n::translate('Lima, Peru'),
	'LOGAN'=>i18n::translate('Logan, Utah'),
	'LONDO'=>i18n::translate('London, England'),
	'LOUIS'=>i18n::translate('Louisville, Kentucky'),
	'LUBBO'=>i18n::translate('Lubbock, Texas'),
	'LVEGA'=>i18n::translate('Las Vegas, Nevada'),
	'MADRI'=>i18n::translate('Madrid, Spain'),
	'MANIL'=>i18n::translate('Manila, Philippines'),
	'MANTI'=>i18n::translate('Manti, Utah'),
	'MEDFO'=>i18n::translate('Medford, Oregon'),
	'MELBO'=>i18n::translate('Melbourne, Australia'),
	'MEMPH'=>i18n::translate('Memphis, Tennessee'),
	'MERID'=>i18n::translate('Merida, Mexico'),
	'MEXIC'=>i18n::translate('Mexico City, Mexico'),
	'MNTVD'=>i18n::translate('Montevideo, Uruguay'),
	'MONTE'=>i18n::translate('Monterrey, Mexico'),
	'MONTI'=>i18n::translate('Monticello, Utah'),
	'MONTR'=>i18n::translate('Montreal, Quebec, Canada'),
	'MTIMP'=>i18n::translate('Mt. Timpanogos, Utah'),
	'NASHV'=>i18n::translate('Nashville, Tennessee'),
	'NAUV2'=>i18n::translate('Nauvoo, Illinois (new)'),
	'NAUVO'=>i18n::translate('Nauvoo, Illinois (original)'),
	'NBEAC'=>i18n::translate('Newport Beach, California'),
	'NUKUA'=>i18n::translate('Nuku\'Alofa, Tonga'),
	'NYORK'=>i18n::translate('New York, New York'),
	'NZEAL'=>i18n::translate('Hamilton, New Zealand'),
	'OAKLA'=>i18n::translate('Oakland, California'),
	'OAXAC'=>i18n::translate('Oaxaca, Mexico'),
	'OGDEN'=>i18n::translate('Ogden, Utah'),
	'OKLAH'=>i18n::translate('Oklahoma City, Oklahoma'),
	'ORLAN'=>i18n::translate('Orlando, Florida'),
	'PALEG'=>i18n::translate('Porto Alegre, Brazil'),
	'PALMY'=>i18n::translate('Palmyra, New York'),
	'PAPEE'=>i18n::translate('Papeete, Tahiti'),
	'PERTH'=>i18n::translate('Perth, Australia'),
	'POFFI'=> /* I18N: http://en.wikipedia.org/wiki/President_of_the_Church */ i18n::translate('President\'s Office'),
	'PORTL'=>i18n::translate('Portland, Oregon'),
	'PREST'=>i18n::translate('Preston, England'),
	'PROVO'=>i18n::translate('Provo, Utah'),
	'RALEI'=>i18n::translate('Raleigh, North Carolina'),
	'RECIF'=>i18n::translate('Recife, Brazil'),
	'REDLA'=>i18n::translate('Redlands, California'),
	'REGIN'=>i18n::translate('Regina, Saskatchewan, Canada'),
	'RENO' =>i18n::translate('Reno, Nevada'),
	'SACRA'=>i18n::translate('Sacramento, California'),
	'SAMOA'=>i18n::translate('Apia, Samoa'),
	'SANTI'=>i18n::translate('Santiago, Chile'),
	'SANTO'=>i18n::translate('San Antonio, Texas'),
	'SDIEG'=>i18n::translate('San Diego, California'),
	'SDOMI'=>i18n::translate('Santo Domingo, Dom. Rep.'),
	'SEATT'=>i18n::translate('Seattle, Washington'),
	'SEOUL'=>i18n::translate('Seoul, Korea'),
	'SGEOR'=>i18n::translate('St. George, Utah'),
	'SJOSE'=>i18n::translate('San Jose, Costa Rica'),
	'SLAKE'=>i18n::translate('Salt Lake City, Utah'),
	'SLOUI'=>i18n::translate('St. Louis, Missouri'),
	'SNOWF'=>i18n::translate('Snowflake, Arizona'),
	'SPAUL'=>i18n::translate('Sao Paulo, Brazil'),
	'SPMIN'=>i18n::translate('St. Paul, Minnesota'),
	'SPOKA'=>i18n::translate('Spokane, Washington'),
	'STOCK'=>i18n::translate('Stockholm, Sweden'),
	'SUVA' =>i18n::translate('Suva, Fiji'),
	'SWISS'=>i18n::translate('Bern, Switzerland'),
	'SYDNE'=>i18n::translate('Sydney, Australia'),
	'TAIPE'=>i18n::translate('Taipei, Taiwan'),
	'TAMPI'=>i18n::translate('Tampico, Mexico'),
	'TGUTI'=>i18n::translate('Tuxtla Gutierrez, Mexico'),
	'TOKYO'=>i18n::translate('Tokyo, Japan'),
	'TORNO'=>i18n::translate('Toronto, Ontario, Canada'),
	'VERAC'=>i18n::translate('Veracruz, Mexico'),
	'VERNA'=>i18n::translate('Vernal, Utah'),
	'VILLA'=>i18n::translate('Villa Hermosa, Mexico'),
	'WASHI'=>i18n::translate('Washington, DC'),
	'WINTE'=>i18n::translate('Winter Quarters, Nebraska'),
);

// STAT tags - LDS status codes
$STATUS_CODES = array(
	'BIC'      => /* LDS sealing statuses; http://en.wikipedia.org/wiki/Sealing_(Latter_Day_Saints) */ i18n::translate('Born in the covenant'),
	'CANCELLED'=>i18n::translate('Sealing cancelled (divorce)'),
	'CHILD'    =>i18n::translate('Died as a child: exempt'),
	'CLEARED'  =>i18n::translate('Cleared but not yet completed'),
	'COMPLETED'=>i18n::translate('Completed; date unknown'),
	'DNS'      =>i18n::translate('Do Not Seal: unauthorized'),
	'DNS/CAN'  =>i18n::translate('Do Not Seal, previous sealing cancelled'),
	'INFANT'   =>i18n::translate('Died as an infant: exempt'),
	'PRE-1970' =>i18n::translate('Completed before 1970; date not available'),
	'STILLBORN'=>i18n::translate('Stillborn: exempt'),
	'SUBMITTED'=>i18n::translate('Submitted but not yet cleared'),
	'UNCLEARED'=>i18n::translate('Uncleared: insufficient data'),
);

// RESN tags - restriction status
$RESN_CODES = array(
	'none'        =>i18n::translate_c('Restriction status', 'None'),
	'locked'      =>i18n::translate_c('Restriction status', 'Do not change'),
	'privacy'     =>i18n::translate_c('Restriction status', 'Privacy'),
	'confidential'=>i18n::translate_c('Restriction status', 'Confidential')
);

// NPFX tags - name prefixes
$NPFX_accept=array(
	'Adm',
	'Amb',
	'Brig',
	'Can',
	'Capt',
	'Chan',
	'Chapln',
	'Cmdr',
	'Col',
	'Cpl',
	'Cpt',
	'Dr',
	'Gen',
	'Gov',
	'Hon',
	'Lady',
	'Lt',
	'Mr',
	'Mrs',
	'Ms',
	'Msgr',
	'Pfc',
	'Pres',
	'Prof',
	'Pvt',
	'Rabbi',
	'Rep',
	'Rev',
	'Sen',
	'Sgt',
	'Sir',
	'Sr',
	'Sra',
	'Srta',
	'Ven',
);

// SPFX tags - surname prefixes
$SPFX_accept=array(
	'al',
	'da',
	'de',
	'dem',
	'den',
	'der',
	'di',
	'du',
	'el',
	'la',
	'van',
	'von',
);

// NSFX tags - name suffixes
$NSFX_accept=array(
	'I',
	'II',
	'III',
	'IV',
	'Jr',
	'Junior',
	'MD',
	'PhD',
	'Senior',
	'Sr',
	'V',
	'VI',
);

// FILE:FORM tags - file formats
$FILE_FORM_accept=array(
	'avi',
	'bmp',
	'gif',
	'jpeg',
	'mp3',
	'ole',
	'pcx',
	'png',
	'tiff',
	'wav',
);

// Fact tags (as opposed to event tags), that don't normally have a value
$emptyfacts=array(
	'ADOP',
	'ANUL',
	'BAPL',
	'BAPM',
	'BARM',
	'BASM',
	'BIRT',
	'BLES',
	'BURI',
	'CENS',
	'CHAN',
	'CHR',
	'CHRA',
	'CONF',
	'CONL',
	'CREM',
	'DATA',
	'DEAT',
	'DIV',
	'DIVF',
	'EMIG',
	'ENDL',
	'ENGA',
	'FCOM',
	'GRAD',
	'HUSB',
	'IMMI',
	'MAP',
	'MARB',
	'MARC',
	'MARL',
	'MARR',
	'MARS',
	'NATU',
	'ORDN',
	'PROB',
	'RESI',
	'RETI',
	'SLGC',
	'SLGS',
	'WIFE',
	'WILL',
	'_HOL',
	'_NMR',
	'_SEPR',
);

// Tags that require a TEMP subtag
$templefacts=array(
	'BAPL',
	'CONL',
	'ENDL',
	'SLGC',
	'SLGS',
);

// Tags that don't require a PLAC subtag
$nonplacfacts=array(
	'ENDL',
	'NCHI',
	'SLGC',
	'SLGS',
);

// Tags that don't require a DATE subtag
$nondatefacts=array(
	'ABBR',
	'ADDR',
	'AFN',
	'AUTH',
	'CHIL',
	'EMAIL',
	'FAX',
	'HUSB',
	'NAME',
	'NCHI',
	'NOTE',
	'OBJE',
	'PHON',
	'PUBL',
	'REFN',
	'REPO',
	'SEX',
	'SOUR',
	'SSN',
	'TEXT',
	'TITL',
	'WIFE',
	'WWW',
	'_EMAIL',
);

// Tags that require a TYPE subtag
$typefacts=array(
);

// Tags that require a DATE:TIME as well as a DATE
$date_and_time=array(
	'BIRT',
	'DEAT',
);

// Level 2 tags that apply to specific Level 1 tags
// Tags are applied in the order they appear here.
$level2_tags=array(
	'_HEB'=>array(
		'NAME',
		'TITL',
	),
	'ROMN'=>array(
		'NAME',
		'TITL',
	),
	'TYPE'=>array(
		'EVEN',
		'FACT',
		'GRAD',
		'IDNO',
		'MARR',
		'ORDN',
		'SSN',
	),
	'AGNC'=>array(
		'EDUC',
		'GRAD',
		'OCCU',
		'ORDN',
		'RETI',
	),
	'CAUS'=>array(
		'DEAT',
	),
	'CALN'=>array(
		'REPO',
	),
	'CEME'=>array( // CEME is NOT a valid 5.5.1 tag
		'BURI',
	),
	'RELA'=>array(
		'ASSO',
	),
	'DATE'=>array(
		'ADOP',
		'ANUL',
		'BAPL',
		'BAPM',
		'BARM',
		'BASM',
		'BIRT',
		'BLES',
		'BURI',
		'CENS',
		'CENS',
		'CHR',
		'CHRA',
		'CONF',
		'CONL',
		'CREM',
		'DEAT',
		'DIV',
		'DIVF',
		'EDUC',
		'EMIG',
		'ENDL',
		'ENGA',
		'EVEN',
		'EVEN',
		'FCOM',
		'GRAD',
		'IMMI',
		'MARB',
		'MARC',
		'MARL',
		'MARR',
		'MARS',
		'NATU',
		'OCCU',
		'ORDN',
		'PROB',
		'PROP',
		'RELI',
		'RESI',
		'RESI',
		'RETI',
		'SLGC',
		'SLGS',
		'WILL',
		'_TODO',
	),
	'TEMP'=>array(
		'BAPL',
		'CONL',
		'ENDL',
		'SLGC',
		'SLGS',
	),
	'PLAC'=>array(
		'ADOP',
		'ANUL',
		'BAPL',
		'BAPM',
		'BARM',
		'BASM',
		'BIRT',
		'BLES',
		'BURI',
		'CENS',
		'CENS',
		'CHR',
		'CHRA',
		'CONF',
		'CONL',
		'CREM',
		'DEAT',
		'DIV',
		'DIVF',
		'EDUC',
		'EMIG',
		'ENDL',
		'ENGA',
		'EVEN',
		'EVEN',
		'FCOM',
		'GRAD',
		'IMMI',
		'MARB',
		'MARC',
		'MARL',
		'MARR',
		'MARS',
		'NATU',
		'OCCU',
		'ORDN',
		'PROB',
		'PROP',
		'RELI',
		'RESI',
		'RESI',
		'RETI',
		'SLGC',
		'SLGS',
		'SSN',
		'WILL',
	),
	'STAT'=>array(
		'BAPL',
		'CONL',
		'ENDL',
		'SLGC',
		'SLGS',
	),
	'ADDR'=>array(
		'BIRT',
		'BURI',
		'CENS',
		'CHR',
		'CHRA',
		'CREM',
		'DEAT',
		'EDUC',
		'EVEN',
		'GRAD',
		'MARR',
		'OCCU',
		'ORDN',
		'PROP',
		'RESI',
	),
	'PHON'=>array(
		'OCCU',
		'RESI',
	),
	'FAX'=>array(
		'OCCU',
		'RESI',
	),
	'URL'=>array(
		'OCCU',
		'RESI',
	),
	'EMAIL'=>array(
		'OCCU',
		'RESI',
	),
	'AGE'=>array(
		'CENS',
		'DEAT',
	),
	'HUSB'=>array(
		'MARR',
	),
	'WIFE'=>array(
		'MARR',
	),
	'FAMC'=>array(
		'ADOP',
		'SLGC',
	),
	'FILE'=>array(
		'OBJE',
	),
	'_PRIM'=>array(
		'OBJE',
	),
	'EVEN'=>array(
		'DATA',
	),
	'_WT_USER'=>array(
		'_TODO',
	),
);

// The order of name parts, when generating names
$STANDARD_NAME_FACTS=array('NAME', 'NPFX', 'GIVN', 'SPFX', 'SURN', 'NSFX');
$REVERSED_NAME_FACTS=array('NAME', 'NPFX', 'SPFX', 'SURN', 'GIVN', 'NSFX');

// ISO3166 3 letter codes, with their 2 letter equivalent.
// NOTE: this is not 1:1.  ENG/SCO/WAL/NIR => GB
// NOTE: this also includes champman codes and others.  Should it?
$iso3166=array(
	'ABW'=>'AW', 'AFG'=>'AF', 'AGO'=>'AO', 'AIA'=>'AI', 'ALA'=>'AX', 'ALB'=>'AL', 'AND'=>'AD', 'ANT'=>'AN',
	'ARE'=>'AE', 'ARG'=>'AR', 'ARM'=>'AM', 'ASM'=>'AS', 'ATA'=>'AQ', 'ATF'=>'TF', 'ATG'=>'AG', 'AUS'=>'AU',
	'AUT'=>'AT', 'AZE'=>'AZ', 'BDI'=>'BI', 'BEL'=>'BE', 'BEN'=>'BJ', 'BFA'=>'BF', 'BGD'=>'BD', 'BGR'=>'BG',
	'BHR'=>'BH', 'BHS'=>'BS', 'BIH'=>'BA', 'BLR'=>'BY', 'BLZ'=>'BZ', 'BMU'=>'BM', 'BOL'=>'BO', 'BRA'=>'BR',
	'BRB'=>'BB', 'BRN'=>'BN', 'BTN'=>'BT', 'BVT'=>'BV', 'BWA'=>'BW', 'CAF'=>'CF', 'CAN'=>'CA', 'CCK'=>'CC',
	'CHE'=>'CH', 'CHL'=>'CL', 'CHN'=>'CN', 'CHI'=>'JE', 'CIV'=>'CI', 'CMR'=>'CM', 'COD'=>'CD', 'COG'=>'CG',
	'COK'=>'CK', 'COL'=>'CO', 'COM'=>'KM', 'CPV'=>'CV', 'CRI'=>'CR', 'CUB'=>'CU', 'CXR'=>'CX', 'CYM'=>'KY',
	'CYP'=>'CY', 'CZE'=>'CZ', 'DEU'=>'DE', 'DJI'=>'DJ', 'DMA'=>'DM', 'DNK'=>'DK', 'DOM'=>'DO', 'DZA'=>'DZ',
	'ECU'=>'EC', 'EGY'=>'EG', 'ENG'=>'GB', 'ERI'=>'ER', 'ESH'=>'EH', 'ESP'=>'ES', 'EST'=>'EE', 'ETH'=>'ET',
	'FIN'=>'FI', 'FJI'=>'FJ', 'FLK'=>'FK', 'FRA'=>'FR', 'FRO'=>'FO', 'FSM'=>'FM', 'GAB'=>'GA', 'GBR'=>'GB',
	'GEO'=>'GE', 'GHA'=>'GH', 'GIB'=>'GI', 'GIN'=>'GN', 'GLP'=>'GP', 'GMB'=>'GM', 'GNB'=>'GW', 'GNQ'=>'GQ',
	'GRC'=>'GR', 'GRD'=>'GD', 'GRL'=>'GL', 'GTM'=>'GT', 'GUF'=>'GF', 'GUM'=>'GU', 'GUY'=>'GY', 'HKG'=>'HK',
	'HMD'=>'HM', 'HND'=>'HN', 'HRV'=>'HR', 'HTI'=>'HT', 'HUN'=>'HU', 'IDN'=>'ID', 'IND'=>'IN', 'IOT'=>'IO',
	'IRL'=>'IE', 'IRN'=>'IR', 'IRQ'=>'IQ', 'ISL'=>'IS', 'ISR'=>'IL', 'ITA'=>'IT', 'JAM'=>'JM', 'JOR'=>'JO',
	'JPN'=>'JA', 'KAZ'=>'KZ', 'KEN'=>'KE', 'KGZ'=>'KG', 'KHM'=>'KH', 'KIR'=>'KI', 'KNA'=>'KN', 'KOR'=>'KO',
	'KWT'=>'KW', 'LAO'=>'LA', 'LBN'=>'LB', 'LBR'=>'LR', 'LBY'=>'LY', 'LCA'=>'LC', 'LIE'=>'LI', 'LKA'=>'LK',
	'LSO'=>'LS', 'LTU'=>'LT', 'LUX'=>'LU', 'LVA'=>'LV', 'MAC'=>'MO', 'MAR'=>'MA', 'MCO'=>'MC', 'MDA'=>'MD',
	'MDG'=>'MG', 'MDV'=>'MV', 'MEX'=>'MX', 'MHL'=>'MH', 'MKD'=>'MK', 'MLI'=>'ML', 'MLT'=>'MT', 'MMR'=>'MM',
	'MNG'=>'MN', 'MNP'=>'MP', 'MNT'=>'ME', 'MOZ'=>'MZ', 'MRT'=>'MR', 'MSR'=>'MS', 'MTQ'=>'MQ', 'MUS'=>'MU',
	'MWI'=>'MW', 'MYS'=>'MY', 'MYT'=>'YT', 'NAM'=>'NA', 'NCL'=>'NC', 'NER'=>'NE', 'NFK'=>'NF', 'NGA'=>'NG',
	'NIC'=>'NI', 'NIR'=>'GB', 'NIU'=>'NU', 'NLD'=>'NL', 'NOR'=>'NO', 'NPL'=>'NP', 'NRU'=>'NR', 'NZL'=>'NZ',
	'OMN'=>'OM', 'PAK'=>'PK', 'PAN'=>'PA', 'PCN'=>'PN', 'PER'=>'PE', 'PHL'=>'PH', 'PLW'=>'PW', 'PNG'=>'PG',
	'POL'=>'PL', 'PRI'=>'PR', 'PRK'=>'KP', 'PRT'=>'PO', 'PRY'=>'PY', 'PSE'=>'PS', 'PYF'=>'PF', 'QAT'=>'QA',
	'REU'=>'RE', 'ROM'=>'RO', 'RUS'=>'RU', 'RWA'=>'RW', 'SAU'=>'SA', 'SCT'=>'GB', 'SDN'=>'SD', 'SEN'=>'SN',
	'SER'=>'RS', 'SGP'=>'SG', 'SGS'=>'GS', 'SHN'=>'SH', 'SIC'=>'IT', 'SJM'=>'SJ', 'SLB'=>'SB', 'SLE'=>'SL',
	'SLV'=>'SV', 'SMR'=>'SM', 'SOM'=>'SO', 'SPM'=>'PM', 'STP'=>'ST', 'SUN'=>'RU', 'SUR'=>'SR', 'SVK'=>'SK',
	'SVN'=>'SI', 'SWE'=>'SE', 'SWZ'=>'SZ', 'SYC'=>'SC', 'SYR'=>'SY', 'TCA'=>'TC', 'TCD'=>'TD', 'TGO'=>'TG',
	'THA'=>'TH', 'TJK'=>'TJ', 'TKL'=>'TK', 'TKM'=>'TM', 'TLS'=>'TL', 'TON'=>'TO', 'TTO'=>'TT', 'TUN'=>'TN',
	'TUR'=>'TR', 'TUV'=>'TV', 'TWN'=>'TW', 'TZA'=>'TZ', 'UGA'=>'UG', 'UKR'=>'UA', 'UMI'=>'UM', 'URY'=>'UY',
	'USA'=>'US', 'UZB'=>'UZ', 'VAT'=>'VA', 'VCT'=>'VC', 'VEN'=>'VE', 'VGB'=>'VG', 'VIR'=>'VI', 'VNM'=>'VN',
	'VUT'=>'VU', 'WLF'=>'WF', 'WLS'=>'GB', 'WSM'=>'WS', 'YEM'=>'YE', 'ZAF'=>'ZA', 'ZMB'=>'ZM', 'ZWE'=>'ZW',
);

function get_all_countries() {
	return array(
		'???'=>i18n::translate('Unknown'),
		'ABW'=>i18n::translate('Aruba'),
		'ACA'=>i18n::translate('Acadia'),
		'AFG'=>i18n::translate('Afghanistan'),
		'AGO'=>i18n::translate('Angola'),
		'AIA'=>i18n::translate('Anguilla'),
		'ALA'=>i18n::translate('Aland Islands'),
		'ALB'=>i18n::translate('Albania'),
		'AND'=>i18n::translate('Andorra'),
		'ANT'=>i18n::translate('Netherlands Antilles'),
		'ARE'=>i18n::translate('United Arab Emirates'),
		'ARG'=>i18n::translate('Argentina'),
		'ARM'=>i18n::translate('Armenia'),
		'ASM'=>i18n::translate('American Samoa'),
		'ATA'=>i18n::translate('Antarctica'),
		'ATF'=>i18n::translate('French Southern Territories'),
		'ATG'=>i18n::translate('Antigua and Barbuda'),
		'AUS'=>i18n::translate('Australia'),
		'AUT'=>i18n::translate('Austria'),
		'AZE'=>i18n::translate('Azerbaijan'),
		'AZR'=>i18n::translate('Azores'),
		'BDI'=>i18n::translate('Burundi'),
		'BEL'=>i18n::translate('Belgium'),
		'BEN'=>i18n::translate('Benin'),
		'BFA'=>i18n::translate('Burkina Faso'),
		'BGD'=>i18n::translate('Bangladesh'),
		'BGR'=>i18n::translate('Bulgaria'),
		'BHR'=>i18n::translate('Bahrain'),
		'BHS'=>i18n::translate('Bahamas'),
		'BIH'=>i18n::translate('Bosnia and Herzegovina'),
		'BLR'=>i18n::translate('Belarus'),
		'BLZ'=>i18n::translate('Belize'),
		'BMU'=>i18n::translate('Bermuda'),
		'BOL'=>i18n::translate('Bolivia'),
		'BRA'=>i18n::translate('Brazil'),
		'BRB'=>i18n::translate('Barbados'),
		'BRN'=>i18n::translate('Brunei Darussalam'),
		'BTN'=>i18n::translate('Bhutan'),
		'BVT'=>i18n::translate('Bouvet Island'),
		'BWA'=>i18n::translate('Botswana'),
		'BWI'=>i18n::translate('British West Indies'),
		'CAF'=>i18n::translate('Central African Republic'),
		'CAN'=>i18n::translate('Canada'),
		'CAP'=>i18n::translate('Cape Colony'),
		'CAT'=>i18n::translate('Catalonia'),
		'CCK'=>i18n::translate('Cocos (Keeling) Islands'),
		'CHE'=>i18n::translate('Switzerland'),
		'CHI'=>i18n::translate('Channel Islands'),
		'CHL'=>i18n::translate('Chile'),
		'CHN'=>i18n::translate('China'),
		'CIV'=>i18n::translate('Cote d\'Ivoire'),
		'CMR'=>i18n::translate('Cameroon'),
		'COD'=>i18n::translate('Congo (Kinshasa)'),
		'COG'=>i18n::translate('Congo (Brazzaville)'),
		'COK'=>i18n::translate('Cook Islands'),
		'COL'=>i18n::translate('Colombia'),
		'COM'=>i18n::translate('Comoros'),
		'CPV'=>i18n::translate('Cape Verde'),
		'CRI'=>i18n::translate('Costa Rica'),
		'CSK'=>i18n::translate('Czechoslovakia'),
		'CUB'=>i18n::translate('Cuba'),
		'CXR'=>i18n::translate('Christmas Island'),
		'CYM'=>i18n::translate('Cayman Islands'),
		'CYP'=>i18n::translate('Cyprus'),
		'CZE'=>i18n::translate('Czech Republic'),
		'DEU'=>i18n::translate('Germany'),
		'DJI'=>i18n::translate('Djibouti'),
		'DMA'=>i18n::translate('Dominica'),
		'DNK'=>i18n::translate('Denmark'),
		'DOM'=>i18n::translate('Dominican Republic'),
		'DZA'=>i18n::translate('Algeria'),
		'ECU'=>i18n::translate('Ecuador'),
		'EGY'=>i18n::translate('Egypt'),
		'EIR'=>i18n::translate('Eire'),
		'ENG'=>i18n::translate('England'),
		'ERI'=>i18n::translate('Eritrea'),
		'ESH'=>i18n::translate('Western Sahara'),
		'ESP'=>i18n::translate('Spain'),
		'EST'=>i18n::translate('Estonia'),
		'ETH'=>i18n::translate('Ethiopia'),
		'FIN'=>i18n::translate('Finland'),
		'FJI'=>i18n::translate('Fiji'),
		'FLD'=>i18n::translate('Flanders'),
		'FLK'=>i18n::translate('Falkland Islands'),
		'FRA'=>i18n::translate('France'),
		'FRO'=>i18n::translate('Faeroe Islands'),
		'FSM'=>i18n::translate('Micronesia'),
		'GAB'=>i18n::translate('Gabon'),
		'GBR'=>i18n::translate('United Kingdom'),
		'GEO'=>i18n::translate('Georgia'),
		'GHA'=>i18n::translate('Ghana'),
		'GIB'=>i18n::translate('Gibraltar'),
		'GIN'=>i18n::translate('Guinea'),
		'GLP'=>i18n::translate('Guadeloupe'),
		'GMB'=>i18n::translate('Gambia'),
		'GNB'=>i18n::translate('Guinea-Bissau'),
		'GNQ'=>i18n::translate('Equatorial Guinea'),
		'GRC'=>i18n::translate('Greece'),
		'GRD'=>i18n::translate('Grenada'),
		'GRL'=>i18n::translate('Greenland'),
		'GTM'=>i18n::translate('Guatemala'),
		'GUF'=>i18n::translate('French Guiana'),
		'GUM'=>i18n::translate('Guam'),
		'GUY'=>i18n::translate('Guyana'),
		'HKG'=>i18n::translate('Hong Kong'),
		'HMD'=>i18n::translate('Heard Island and McDonald Islands'),
		'HND'=>i18n::translate('Honduras'),
		'HRV'=>i18n::translate('Croatia'),
		'HTI'=>i18n::translate('Haiti'),
		'HUN'=>i18n::translate('Hungary'),
		'IDN'=>i18n::translate('Indonesia'),
		'IND'=>i18n::translate('India'),
		'IOM'=>i18n::translate('Isle of Man'),
		'IOT'=>i18n::translate('British Indian Ocean Territory'),
		'IRL'=>i18n::translate('Ireland'),
		'IRN'=>i18n::translate('Iran'),
		'IRQ'=>i18n::translate('Iraq'),
		'ISL'=>i18n::translate('Iceland'),
		'ISR'=>i18n::translate('Israel'),
		'ITA'=>i18n::translate('Italy'),
		'JAM'=>i18n::translate('Jamaica'),
		'JOR'=>i18n::translate('Jordan'),
		'JPN'=>i18n::translate('Japan'),
		'KAZ'=>i18n::translate('Kazakhstan'),
		'KEN'=>i18n::translate('Kenya'),
		'KGZ'=>i18n::translate('Kyrgyzstan'),
		'KHM'=>i18n::translate('Cambodia'),
		'KIR'=>i18n::translate('Kiribati'),
		'KNA'=>i18n::translate('Saint Kitts and Nevis'),
		'KOR'=>i18n::translate('Korea'),
		'KWT'=>i18n::translate('Kuwait'),
		'LAO'=>i18n::translate('Laos'),
		'LBN'=>i18n::translate('Lebanon'),
		'LBR'=>i18n::translate('Liberia'),
		'LBY'=>i18n::translate('Libya'),
		'LCA'=>i18n::translate('Saint Lucia'),
		'LIE'=>i18n::translate('Liechtenstein'),
		'LKA'=>i18n::translate('Sri Lanka'),
		'LSO'=>i18n::translate('Lesotho'),
		'LTU'=>i18n::translate('Lithuania'),
		'LUX'=>i18n::translate('Luxembourg'),
		'LVA'=>i18n::translate('Latvia'),
		'MAC'=>i18n::translate('Macau'),
		'MAR'=>i18n::translate('Morocco'),
		'MCO'=>i18n::translate('Monaco'),
		'MDA'=>i18n::translate('Moldova'),
		'MDG'=>i18n::translate('Madagascar'),
		'MDV'=>i18n::translate('Maldives'),
		'MEX'=>i18n::translate('Mexico'),
		'MHL'=>i18n::translate('Marshall Islands'),
		'MKD'=>i18n::translate('Macedonia'),
		'MLI'=>i18n::translate('Mali'),
		'MLT'=>i18n::translate('Malta'),
		'MMR'=>i18n::translate('Myanmar'),
		'MNG'=>i18n::translate('Mongolia'),
		'MNP'=>i18n::translate('Northern Mariana Islands'),
		'MNT'=>i18n::translate('Montenegro'),
		'MOZ'=>i18n::translate('Mozambique'),
		'MRT'=>i18n::translate('Mauritania'),
		'MSR'=>i18n::translate('Montserrat'),
		'MTQ'=>i18n::translate('Martinique'),
		'MUS'=>i18n::translate('Mauritius'),
		'MWI'=>i18n::translate('Malawi'),
		'MYS'=>i18n::translate('Malaysia'),
		'MYT'=>i18n::translate('Mayotte'),
		'NAM'=>i18n::translate('Namibia'),
		'NCL'=>i18n::translate('New Caledonia'),
		'NER'=>i18n::translate('Niger'),
		'NFK'=>i18n::translate('Norfolk Island'),
		'NGA'=>i18n::translate('Nigeria'),
		'NIC'=>i18n::translate('Nicaragua'),
		'NIR'=>i18n::translate('Northern Ireland'),
		'NIU'=>i18n::translate('Niue'),
		'NLD'=>i18n::translate('Netherlands'),
		'NOR'=>i18n::translate('Norway'),
		'NPL'=>i18n::translate('Nepal'),
		'NRU'=>i18n::translate('Nauru'),
		'NTZ'=>i18n::translate('Neutral Zone'),
		'NZL'=>i18n::translate('New Zealand'),
		'OMN'=>i18n::translate('Oman'),
		'PAK'=>i18n::translate('Pakistan'),
		'PAN'=>i18n::translate('Panama'),
		'PCN'=>i18n::translate('Pitcairn'),
		'PER'=>i18n::translate('Peru'),
		'PHL'=>i18n::translate('Philippines'),
		'PLW'=>i18n::translate('Palau'),
		'PNG'=>i18n::translate('Papua New Guinea'),
		'POL'=>i18n::translate('Poland'),
		'PRI'=>i18n::translate('Puerto Rico'),
		'PRK'=>i18n::translate('North Korea'),
		'PRT'=>i18n::translate('Portugal'),
		'PRY'=>i18n::translate('Paraguay'),
		'PSE'=>i18n::translate('Occupied Palestinian Territory'),
		'PYF'=>i18n::translate('French Polynesia'),
		'QAT'=>i18n::translate('Qatar'),
		'REU'=>i18n::translate('Reunion'),
		'ROM'=>i18n::translate('Romania'),
		'RUS'=>i18n::translate('Russia'),
		'RWA'=>i18n::translate('Rwanda'),
		'SAU'=>i18n::translate('Saudi Arabia'),
		'SCG'=>i18n::translate('Serbia and Montenegro'),
		'SCT'=>i18n::translate('Scotland'),
		'SDN'=>i18n::translate('Sudan'),
		'SEA'=>i18n::translate('At Sea'),
		'SEN'=>i18n::translate('Senegal'),
		'SER'=>i18n::translate('Serbia'),
		'SGP'=>i18n::translate('Singapore'),
		'SGS'=>i18n::translate('South Georgia and the South Sandwich Islands'),
		'SHN'=>i18n::translate('Saint Helena'),
		'SIC'=>i18n::translate('Sicily'),
		'SJM'=>i18n::translate('Svalbard and Jan Mayen Islands'),
		'SLB'=>i18n::translate('Solomon Islands'),
		'SLE'=>i18n::translate('Sierra Leone'),
		'SLV'=>i18n::translate('El Salvador'),
		'SMR'=>i18n::translate('San Marino'),
		'SOM'=>i18n::translate('Somalia'),
		'SPM'=>i18n::translate('Saint Pierre and Miquelon'),
		'STP'=>i18n::translate('Sao Tome and Principe'),
		'SUN'=>i18n::translate('USSR'),
		'SUR'=>i18n::translate('Suriname'),
		'SVK'=>i18n::translate('Slovakia'),
		'SVN'=>i18n::translate('Slovenia'),
		'SWE'=>i18n::translate('Sweden'),
		'SWZ'=>i18n::translate('Swaziland'),
		'SYC'=>i18n::translate('Seychelles'),
		'SYR'=>i18n::translate('Syrian Arab Republic'),
		'TCA'=>i18n::translate('Turks and Caicos Islands'),
		'TCD'=>i18n::translate('Chad'),
		'TGO'=>i18n::translate('Togo'),
		'THA'=>i18n::translate('Thailand'),
		'TJK'=>i18n::translate('Tajikistan'),
		'TKL'=>i18n::translate('Tokelau'),
		'TKM'=>i18n::translate('Turkmenistan'),
		'TLS'=>i18n::translate('Timor-Leste'),
		'TON'=>i18n::translate('Tonga'),
		'TRN'=>i18n::translate('Transylvania'),
		'TTO'=>i18n::translate('Trinidad and Tobago'),
		'TUN'=>i18n::translate('Tunisia'),
		'TUR'=>i18n::translate('Turkey'),
		'TUV'=>i18n::translate('Tuvalu'),
		'TWN'=>i18n::translate('Taiwan'),
		'TZA'=>i18n::translate('Tanzania'),
		'UGA'=>i18n::translate('Uganda'),
		'UKR'=>i18n::translate('Ukraine'),
		'UMI'=>i18n::translate('US Minor Outlying Islands'),
		'URY'=>i18n::translate('Uruguay'),
		'USA'=>i18n::translate('USA'),
		'UZB'=>i18n::translate('Uzbekistan'),
		'VAT'=>i18n::translate('Vatican City'),
		'VCT'=>i18n::translate('Saint Vincent and the Grenadines'),
		'VEN'=>i18n::translate('Venezuela'),
		'VGB'=>i18n::translate('British Virgin Islands'),
		'VIR'=>i18n::translate('US Virgin Islands'),
		'VNM'=>i18n::translate('Viet Nam'),
		'VUT'=>i18n::translate('Vanuatu'),
		'WAF'=>i18n::translate('West Africa'),
		'WLF'=>i18n::translate('Wallis and Futuna Islands'),
		'WLS'=>i18n::translate('Wales'),
		'WSM'=>i18n::translate('Samoa'),
		'YEM'=>i18n::translate('Yemen'),
		'YUG'=>i18n::translate('Yugoslavia'),
		'ZAF'=>i18n::translate('South Africa'),
		'ZAR'=>i18n::translate('Zaire'),
		'ZMB'=>i18n::translate('Zambia'),
		'ZWE'=>i18n::translate('Zimbabwe'),
	);
}

$FACTS=array(
	'ABBR'=> /* I18N: gedcom tag ABBR */     i18n::translate('Abbreviation'),
	'ADDR'=> /* I18N: gedcom tag ADDR */     i18n::translate('Address'),
	'ADR1'=>                                 i18n::translate('Address line 1'),
	'ADR2'=>                                 i18n::translate('Address line 2'),
	'ADOP'=> /* I18N: gedcom tag ADOP */     i18n::translate('Adoption'),
	'ADOP:DATE'=>                            i18n::translate('Date of Adoption'),
	'ADOP:PLAC'=>                            i18n::translate('Place of Adoption'),
	'ADOP:SOUR'=>                            i18n::translate('Source for Adoption'),
	'AFN'=> /* I18N: gedcom tag AFN */       i18n::translate('Ancestral File Number'),
	'AGE'=> /* I18N: gedcom tag AGE */       i18n::translate('Age'),
	'AGNC'=> /* I18N: gedcom tag AGNC */     i18n::translate('Agency'),
	'ALIA'=> /* I18N: gedcom tag ALIA */     i18n::translate('Alias'),
	'ANCE'=> /* I18N: gedcom tag ANCE */     i18n::translate('Generations of ancestors'),
	'ANCI'=> /* I18N: gedcom tag ANCI */     i18n::translate('Ancestors interest'),
	'ANUL'=> /* I18N: gedcom tag ANUL */     i18n::translate('Annulment'),
	'ASSO'=> /* I18N: gedcom tag ASSO */     i18n::translate('Associate'),
	'AUTH'=> /* I18N: gedcom tag AUTH */     i18n::translate('Author'),
	'BAPL'=> /* I18N: gedcom tag BAPL */     i18n::translate('LDS baptism'),
	'BAPL:DATE'=>                            i18n::translate('Date of LDS Baptism'),
	'BAPL:PLAC'=>                            i18n::translate('Place of LDS Baptism'),
	'BAPL:TEMP'=>                            i18n::translate('Temple of LDS Baptism'),
	'BAPM'=> /* I18N: gedcom tag BAPM */     i18n::translate('Baptism'),
	'BAPM:DATE'=>                            i18n::translate('Date of baptism'),
	'BAPM:PLAC'=>                            i18n::translate('Place of baptism'),
	'BAPM:SOUR'=>                            i18n::translate('Source for baptism'),
	'BARM'=> /* I18N: gedcom tag BARM */     i18n::translate('Bar mitzvah'),
	'BARM:DATE'=>                            i18n::translate('Date of bar mitzvah'),
	'BARM:PLAC'=>                            i18n::translate('Place of bar mitzvah'),
	'BARM:SOUR'=>                            i18n::translate('Source for bar mitzvah'),
	'BASM'=> /* I18N: gedcom tag BASM */     i18n::translate('Bas mitzvah'),
	'BASM:DATE'=>                            i18n::translate('Date of bas mitzvah'),
	'BASM:PLAC'=>                            i18n::translate('Place of bas mitzvah'),
	'BASM:SOUR'=>                            i18n::translate('Source for bas mitzvah'),
	'BIRT'=> /* I18N: gedcom tag BIRT */     i18n::translate('Birth'),
	'BIRT:DATE'=>                            i18n::translate('Date of birth'),
	'BIRT:PLAC'=>                            i18n::translate('Place of birth'),
	'BIRT:SOUR'=>                            i18n::translate('Source for birth'),
	'BLES'=> /* I18N: gedcom tag BLES */     i18n::translate('Blessing'),
	'BLES:DATE'=>                            i18n::translate('Date of Blessing'),
	'BLES:PLAC'=>                            i18n::translate('Place of Blessing'),
	'BLES:SOUR'=>                            i18n::translate('Source for Blessing'),
	'BLOB'=> /* I18N: gedcom tag BLOB */     i18n::translate('Binary Data Object'),
	'BURI'=> /* I18N: gedcom tag BURI */     i18n::translate('Burial'),
	'BURI:DATE'=>                            i18n::translate('Date of burial'),
	'BURI:PLAC'=>                            i18n::translate('Place of burial'),
	'BURI:SOUR'=>                            i18n::translate('Source for burial'),
	'CALN'=> /* I18N: gedcom tag CALN */     i18n::translate('Call number'),
	'CAST'=> /* I18N: gedcom tag CAST */     i18n::translate('Caste'),
	'CAUS'=> /* I18N: gedcom tag CAUS */     i18n::translate('Cause'),
	'CEME'=> /* I18N: gedcom tag CEME */     i18n::translate('Cemetery'),
	'CENS'=> /* I18N: gedcom tag CENS */     i18n::translate('Census'),
	'CENS:DATE'=>                            i18n::translate('Census date'),
	'CENS:PLAC'=>                            i18n::translate('Census place'),
	'CHAN'=> /* I18N: gedcom tag CHAN */     i18n::translate('Last change'),
	'CHAR'=> /* I18N: gedcom tag CHAR */     i18n::translate('Character set'),
	'CHIL'=> /* I18N: gedcom tag CHIL */     i18n::translate('Child'),
	'CHR'=> /* I18N: gedcom tag CHR */       i18n::translate('Christening'),
	'CHR:DATE'=>                             i18n::translate('Date of christening'),
	'CHR:PLAC'=>                             i18n::translate('Place of christening'),
	'CHR:SOUR'=>                             i18n::translate('Source for christening'),
	'CHRA'=> /* I18N: gedcom tag CHRA */     i18n::translate('Adult christening'),
	'CITN'=> /* I18N: gedcom tag CITN */     i18n::translate('Citizenship'),
	'CITY'=> /* I18N: gedcom tag CITY */     i18n::translate('City'),
	'COMM'=> /* I18N: gedcom tag COMM */     i18n::translate('Comment'),
	'CONC'=> /* I18N: gedcom tag CONC */     i18n::translate('Concatenation'),
	'CONT'=> /* I18N: gedcom tag CONT */     i18n::translate('Continued'),
	'CONF'=> /* I18N: gedcom tag CONF */     i18n::translate('Confirmation'),
	'CONF:DATE'=>                            i18n::translate('Date of confirmation'),
	'CONF:PLAC'=>                            i18n::translate('Place of confirmation'),
	'CONF:SOUR'=>                            i18n::translate('Source for confirmation'),
	'CONL'=> /* I18N: gedcom tag CONL */     i18n::translate('LDS confirmation'),
	'COPR'=> /* I18N: gedcom tag COPR */     i18n::translate('Copyright'),
	'CORP'=> /* I18N: gedcom tag CORP */     i18n::translate('Corporation'),
	'CREM'=> /* I18N: gedcom tag CREM */     i18n::translate('Cremation'),
	'CREM:DATE'=>                            i18n::translate('Date of Cremation'),
	'CREM:PLAC'=>                            i18n::translate('Place of Cremation'),
	'CREM:SOUR'=>                            i18n::translate('Source for Cremation'),
	'CTRY'=> /* I18N: gedcom tag CTRY */     i18n::translate('Country'),
	'DATA'=> /* I18N: gedcom tag DATA */     i18n::translate('Data'),
	'DATA:DATE'=>                            i18n::translate('Date of entry in original source'),
	'DATE'=> /* I18N: gedcom tag DATE */     i18n::translate('Date'),
	'DEAT'=> /* I18N: gedcom tag DEAT */     i18n::translate('Death'),
	'DEAT:CAUS'=>                            i18n::translate('Cause of death'),
	'DEAT:DATE'=>                            i18n::translate('Date of death'),
	'DEAT:PLAC'=>                            i18n::translate('Place of death'),
	'DEAT:SOUR'=>                            i18n::translate('Source for death'),
	'DESC'=> /* I18N: gedcom tag DESC */     i18n::translate('Descendants'),
	'DESI'=> /* I18N: gedcom tag DESI */     i18n::translate('Descendants interest'),
	'DEST'=> /* I18N: gedcom tag DEST */     i18n::translate('Destination'),
	'DIV'=> /* I18N: gedcom tag DIV */       i18n::translate('Divorce'),
	'DIVF'=> /* I18N: gedcom tag DIVF */     i18n::translate('Divorce filed'),
	'DSCR'=> /* I18N: gedcom tag DSCR */     i18n::translate('Description'),
	'EDUC'=> /* I18N: gedcom tag EDUC */     i18n::translate('Education'),
	'EDUC:AGNC'=>                            i18n::translate('School or college'),
	'EMAI'=> /* I18N: gedcom tag EMAI */     i18n::translate('Email address'),
	'EMAIL'=> /* I18N: gedcom tag EMAIL */   i18n::translate('Email address'),
	'EMAL'=> /* I18N: gedcom tag EMAL */     i18n::translate('Email address'),
	'EMIG'=> /* I18N: gedcom tag EMIG */     i18n::translate('Emigration'),
	'EMIG:DATE'=>                            i18n::translate('Date of Emigration'),
	'EMIG:PLAC'=>                            i18n::translate('Place of Emigration'),
	'ENDL'=> /* I18N: gedcom tag ENDL */     i18n::translate('LDS endowment'),
	'ENDL:DATE'=>                            i18n::translate('Date of LDS Endowment'),
	'ENDL:PLAC'=>                            i18n::translate('Place of LDS Endowment'),
	'ENDL:TEMP'=>                            i18n::translate('Temple of LDS Endowment'),
	'ENGA'=> /* I18N: gedcom tag ENGA */     i18n::translate('Engagement'),
	'ENGA:DATE'=>                            i18n::translate('Date of engagement'),
	'ENGA:PLAC'=>                            i18n::translate('Place of engagement'),
	'ENGA:SOUR'=>                            i18n::translate('Source for engagement'),
	'EVEN'=> /* I18N: gedcom tag EVEN */     i18n::translate('Event'),
	'EVEN:DATE'=>                            i18n::translate('Date of Event'),
	'EVEN:PLAC'=>                            i18n::translate('Place of Event'),
	'FACT'=> /* I18N: gedcom tag FACT */     i18n::translate('Fact'),
	'FAM'=> /* I18N: gedcom tag FAM */       i18n::translate('Family'),
	'FAMC'=> /* I18N: gedcom tag FAMC */     i18n::translate('Family as a child'),
	'FAMC:HUSB:BIRT:PLAC'=>                  i18n::translate('Father\'s birthplace'),
	'FAMC:HUSB:FAMC:HUSB:GIVN'=>             i18n::translate('Paternal grandfather\'s given name'),
	'FAMC:HUSB:FAMC:WIFE:GIVN'=>             i18n::translate('Paternal grandmother\'s given name'),
	'FAMC:HUSB:GIVN'=>                       i18n::translate('Father\'s given name'),
	'FAMC:HUSB:OCCU'=>                       i18n::translate('Father\'s occupation'),
	'FAMC:HUSB:SURN'=>                       i18n::translate('Father\'s surname'),
	'FAMC:MARR:PLAC'=>                       i18n::translate('Parents\' marriage place'),
	'FAMC:WIFE:BIRT:PLAC'=>                  i18n::translate('Mother\'s birthplace'),
	'FAMC:WIFE:FAMC:HUSB:GIVN'=>             i18n::translate('Maternal grandfather\'s given name'),
	'FAMC:WIFE:FAMC:WIFE:GIVN'=>             i18n::translate('Maternal grandmother\'s Given Name'),
	'FAMC:WIFE:GIVN'=>                       i18n::translate('Mother\'s given name'),
	'FAMC:WIFE:SURN'=>                       i18n::translate('Mother\'s surname'),
	'FAMF'=> /* I18N: gedcom tag FAMF */     i18n::translate('Family file'),
	'FAMS'=> /* I18N: gedcom tag FAMS */     i18n::translate('Family as a spouse'),
	'FAMS:CENS:DATE'=>                       i18n::translate('Spouse census date'),
	'FAMS:CENS:PLAC'=>                       i18n::translate('Spouse census place'),
	'FAMS:CHIL:BIRT:PLAC'=>                  i18n::translate('Child\'s birth place'),
	'FAMS:DIV:DATE'=>                        i18n::translate('Spouse divorce date'),
	'FAMS:DIV:PLAC'=>                        i18n::translate('Spouse divorce place'),
	'FAMS:MARR:DAT'=>                        i18n::translate('Marriage date'),
	'FAMS:MARR:PLAC'=>                       i18n::translate('Marriage place'),
	'FAMS:NOTE'=>                            i18n::translate('Spouse note'),
	'FAMS:SLGS:DATE'=>                       i18n::translate('LDS spouse sealing date'),
	'FAMS:SLGS:PLAC'=>                       i18n::translate('LDS spouse sealing place'),
	'FAMS:SLGS:TEMP'=>                       i18n::translate('LDS spouse sealing temple'),
	'FAMS:SPOUSE:BIRT:PLAC'=>                i18n::translate('Spouse\'s birth place'),
	'FAMS:SPOUSE:DEAT:PLAC'=>                i18n::translate('Spouse\'s death place'),
	'FAX'=> /* I18N: gedcom tag FAX */       i18n::translate('Fax'),
	'FCOM'=> /* I18N: gedcom tag FCOM */     i18n::translate('First communion'),
	'FCOM:DATE'=>                            i18n::translate('Date of first communion'),
	'FCOM:PLAC'=>                            i18n::translate('Place of first communion'),
	'FCOM:SOUR'=>                            i18n::translate('Source for first communion'),
	'FILE'=> /* I18N: gedcom tag FILE */     i18n::translate('Filename'),
	'FONE'=> /* I18N: gedcom tag FONE */     i18n::translate('Phonetic'),
	'FORM'=> /* I18N: gedcom tag FORM */     i18n::translate('Format'),
	'GEDC'=> /* I18N: gedcom tag GEDC */     i18n::translate('Gedcom'),
	'GIVN'=> /* I18N: gedcom tag GIVN */     i18n::translate('Given names'),
	'GRAD'=> /* I18N: gedcom tag GRAD */     i18n::translate('Graduation'),
	'HEAD'=> /* I18N: gedcom tag HEAD */     i18n::translate('Header'),
	'HUSB'=> /* I18N: gedcom tag HUSB */     i18n::translate('Husband'),
	'IDNO'=> /* I18N: gedcom tag IDNO */     i18n::translate('Identification number'),
	'IMMI'=> /* I18N: gedcom tag IMMI */     i18n::translate('Immigration'),
	'IMMI:DATE'=>                            i18n::translate('Date of Immigration'),
	'IMMI:PLAC'=>                            i18n::translate('Place of Immigration'),
	'INDI'=> /* I18N: gedcom tag INDI */     i18n::translate('Individual'),
	'INFL'=> /* I18N: gedcom tag INFL */     i18n::translate('Infant'),
	'LANG'=> /* I18N: gedcom tag LANG */     i18n::translate('Language'),
	'LATI'=> /* I18N: gedcom tag LATI */     i18n::translate('Latitude'),
	'LEGA'=> /* I18N: gedcom tag LEGA */     i18n::translate('Legatee'),
	'LONG'=> /* I18N: gedcom tag LONG */     i18n::translate('Longitude'),
	'MAP'=> /* I18N: gedcom tag MAP */       i18n::translate('Map'),
	'MARB'=> /* I18N: gedcom tag MARB */     i18n::translate('Marriage banns'),
	'MARB:DATE'=>                            i18n::translate('Date of marriage banns'),
	'MARB:PLAC'=>                            i18n::translate('Place of marriage banns'),
	'MARB:SOUR'=>                            i18n::translate('Source for marriage banns'),
	'MARC'=> /* I18N: gedcom tag MARC */     i18n::translate('Marriage contract'),
	'MARL'=> /* I18N: gedcom tag MARL */     i18n::translate('Marriage licence'),
	'MARR'=> /* I18N: gedcom tag MARR */     i18n::translate('Marriage'),
	'MARR:DATE'=>                            i18n::translate('Date of marriage'),
	'MARR:PLAC'=>                            i18n::translate('Place of marriage'),
	'MARR:SOUR'=>                            i18n::translate('Source for marriage'),
	'MARR_CIVIL'=>                           i18n::translate('Civil marriage'),
	'MARR_PARTNERS'=>                        i18n::translate('Registered partnership'),
	'MARR_RELIGIOUS'=>                       i18n::translate('Religious marriage'),
	'MARR_UNKNOWN'=>                         i18n::translate('Marriage type unknown'),
	'MARS'=> /* I18N: gedcom tag MARS */     i18n::translate('Marriage settlement'),
	'MEDI'=> /* I18N: gedcom tag MEDI */     i18n::translate('Media type'),
	'NAME'=> /* I18N: gedcom tag NAME */     i18n::translate('Name'),
	'NAME:FONE'=>                            i18n::translate('Phonetic name'),
	'NAME:_HEB'=>                            i18n::translate('Name in Hebrew'),
	'NATI'=> /* I18N: gedcom tag NATI */     i18n::translate('Nationality'),
	'NATU'=> /* I18N: gedcom tag NATU */     i18n::translate('Naturalization'),
	'NATU:DATE'=>                            i18n::translate('Date of Naturalization'),
	'NATU:PLAC'=>                            i18n::translate('Place of Naturalization'),
	'NCHI'=> /* I18N: gedcom tag NCHI */     i18n::translate('Number of children'),
	'NICK'=> /* I18N: gedcom tag NICK */     i18n::translate('Nickname'),
	'NMR'=> /* I18N: gedcom tag NMR */       i18n::translate('Number of marriages'),
	'NOTE'=> /* I18N: gedcom tag NOTE */     i18n::translate('Note'),
	'NPFX'=> /* I18N: gedcom tag NPFX */     i18n::translate('Name prefix'),
	'NSFX'=> /* I18N: gedcom tag NSFX */     i18n::translate('Name suffix'),
	'OBJE'=> /* I18N: gedcom tag OBJE */     i18n::translate('Multimedia object'),
	'OCCU'=> /* I18N: gedcom tag OCCU */     i18n::translate('Occupation'),
	'OCCU:AGNC'=>                            i18n::translate('Employer'),
	'ORDI'=> /* I18N: gedcom tag ORDI */     i18n::translate('Ordinance'),
	'ORDN'=> /* I18N: gedcom tag ORDN */     i18n::translate('Ordination'),
	'ORDN:AGNC'=>                            i18n::translate('Religious Institution'),
	'ORDN:DATE'=>                            i18n::translate('Date of Ordination'),
	'ORDN:PLAC'=>                            i18n::translate('Place of Ordination'),
	'PAGE'=> /* I18N: gedcom tag PAGE */     i18n::translate('Citation details'),
	'PEDI'=> /* I18N: gedcom tag PEDI */     i18n::translate('Pedigree'),
	'PHON'=> /* I18N: gedcom tag PHON */     i18n::translate('Phone'),
	'PLAC'=> /* I18N: gedcom tag PLAC */     i18n::translate('Place'),
	'PLAC:FONE'=>                            i18n::translate('Phonetic place'),
	'PLAC:ROMN'=>                            i18n::translate('Romanized place'),
	'PLAC:_HEB'=>                            i18n::translate('Place in Hebrew'),
	'POST'=> /* I18N: gedcom tag POST */     i18n::translate('Postal code'),
	'PROB'=> /* I18N: gedcom tag PROB */     i18n::translate('Probate'),
	'PROP'=> /* I18N: gedcom tag PROP */     i18n::translate('Property'),
	'PUBL'=> /* I18N: gedcom tag PUBL */     i18n::translate('Publication'),
	'QUAY'=> /* I18N: gedcom tag QUAY */     i18n::translate('Quality of data'),
	'REFN'=> /* I18N: gedcom tag REFN */     i18n::translate('Reference number'),
	'RELA'=> /* I18N: gedcom tag RELA */     i18n::translate('Relationship'),
	'RELI'=> /* I18N: gedcom tag RELI */     i18n::translate('Religion'),
	'REPO'=> /* I18N: gedcom tag REPO */     i18n::translate('Repository'),
	'RESI'=> /* I18N: gedcom tag RESI */     i18n::translate('Residence'),
	'RESI:DATE'=>                            i18n::translate('Date of Residence'),
	'RESI:PLAC'=>                            i18n::translate('Place of Residence'),
	'RESN'=> /* I18N: gedcom tag RESN */     i18n::translate('Restriction'),
	'RETI'=> /* I18N: gedcom tag RETI */     i18n::translate('Retirement'),
	'RETI:AGNC'=>                            i18n::translate('Employer'),
	'RFN'=> /* I18N: gedcom tag RFN */       i18n::translate('Record file number'),
	'RIN'=> /* I18N: gedcom tag RIN */       i18n::translate('Record ID number'),
	'ROLE'=> /* I18N: gedcom tag ROLE */     i18n::translate('Role'),
	'ROMN'=> /* I18N: gedcom tag ROMN */     i18n::translate('Romanized'),
	'SERV'=> /* I18N: gedcom tag SERV */     i18n::translate('Remote server'),
	'SEX'=> /* I18N: gedcom tag SEX */       i18n::translate('Gender'),
	'SHARED_NOTE'=>                          i18n::translate('Shared note'),
	'SLGC'=> /* I18N: gedcom tag SLGC */     i18n::translate('LDS child sealing'),
	'SLGC:DATE'=>                            i18n::translate('Date of LDS Child Sealing'),
	'SLGC:PLAC'=>                            i18n::translate('Place of LDS Child Sealing'),
	'SLGC:TEMP'=>                            i18n::translate('Temple of LDS Child Sealing'),
	'SLGS'=> /* I18N: gedcom tag SLGS */     i18n::translate('LDS spouse sealing'),
	'SLGS:DATE'=>                            i18n::translate('Date of LDS Spouse Sealing'),
	'SLGS:PLAC'=>                            i18n::translate('Place of LDS Spouse Sealing'),
	'SLGS:TEMP'=>                            i18n::translate('Temple of LDS Spouse Sealing'),
	'SOUR'=> /* I18N: gedcom tag SOUR */     i18n::translate('Source'),
	'SPFX'=> /* I18N: gedcom tag SPFX */     i18n::translate('Surname prefix'),
	'SSN'=> /* I18N: gedcom tag SSN */       i18n::translate('Social Security Number'),
	'STAE'=> /* I18N: gedcom tag STAE */     i18n::translate('State'),
	'STAT'=> /* I18N: gedcom tag STAT */     i18n::translate('Status'),
	'STAT:DATE'=>                            i18n::translate('Status change date'),
	'SUBM'=> /* I18N: gedcom tag SUBM */     i18n::translate('Submitter'),
	'SUBN'=> /* I18N: gedcom tag SUBN */     i18n::translate('Submission'),
	'SURN'=> /* I18N: gedcom tag SURN */     i18n::translate('Surname'),
	'TEMP'=> /* I18N: gedcom tag TEMP */     i18n::translate('Temple'),
	'TEXT'=> /* I18N: gedcom tag TEXT */     i18n::translate('Text'),
	'TIME'=> /* I18N: gedcom tag TIME */     i18n::translate('Time'),
	'TITL'=> /* I18N: gedcom tag TITL */     i18n::translate('Title'),
	'TITL:FONE'=>                            i18n::translate('Phonetic title'),
	'TITL:ROMN'=>                            i18n::translate('Romanized title'),
	'TITL:_HEB'=>                            i18n::translate('Title in Hebrew'),
	'TRLR'=> /* I18N: gedcom tag TRLR */     i18n::translate('Trailer'),
	'TYPE'=> /* I18N: gedcom tag TYPE */     i18n::translate('Type'),
	'URL'=> /* I18N: gedcom tag URL */       i18n::translate('Web URL'),
	'VERS'=> /* I18N: gedcom tag VERS */     i18n::translate('Version'),
	'WIFE'=> /* I18N: gedcom tag WIFE */     i18n::translate('Wife'),
	'WILL'=> /* I18N: gedcom tag WILL */     i18n::translate('Will'),
	'WWW'=> /* I18N: gedcom tag WWW */       i18n::translate('Web home page'),
	'_ADOP_CHIL'=>                           i18n::translate('Adoption of a child'),
	'_ADOP_COUS'=>                           i18n::translate('Adoption of a first cousin'),
	'_ADOP_FSIB'=>                           i18n::translate('Adoption of father\'s sibling'),
	'_ADOP_GCHI'=>                           i18n::translate('Adoption of a grandchild'),
	'_ADOP_GGCH'=>                           i18n::translate('Adoption of a great-grandchild'),
	'_ADOP_HSIB'=>                           i18n::translate('Adoption of a half-sibling'),
	'_ADOP_MSIB'=>                           i18n::translate('Adoption of mother\'s sibling'),
	'_ADOP_NEPH'=>                           i18n::translate('Adoption of a nephew or niece'),
	'_ADOP_SIBL'=>                           i18n::translate('Adoption of a sibling'),
	'_ADPF'=> /* I18N: gedcom tag _ADPF */   i18n::translate('Adopted by father'),
	'_ADPM'=> /* I18N: gedcom tag _ADPM */   i18n::translate('Adopted by mother'),
	'_AKA'=> /* I18N: gedcom tag _AKA */     i18n::translate('Also known as'),
	'_AKAN'=> /* I18N: gedcom tag _AKAN */   i18n::translate('Also known as'),
	'_BAPM_CHIL'=>                           i18n::translate('Baptism of a child'),
	'_BAPM_COUS'=>                           i18n::translate('Baptism of a first cousin'),
	'_BAPM_FSIB'=>                           i18n::translate('Baptism of father\'s sibling'),
	'_BAPM_GCHI'=>                           i18n::translate('Baptism of a grandchild'),
	'_BAPM_GGCH'=>                           i18n::translate('Baptism of a great-grandchild'),
	'_BAPM_HSIB'=>                           i18n::translate('Baptism of half-sibling'),
	'_BAPM_MSIB'=>                           i18n::translate('Baptism of mother\'s sibling'),
	'_BAPM_NEPH'=>                           i18n::translate('Baptism of a nephew or niece'),
	'_BAPM_SIBL'=>                           i18n::translate('Baptism of sibling'),
	'_BIBL'=> /* I18N: gedcom tag _BIBL */   i18n::translate('Bibliography'),
	'_BIRT_CHIL'=>                           i18n::translate('Birth of a child'),
	'_BIRT_COUS'=>                           i18n::translate('Birth of a first cousin'),
	'_BIRT_FSIB'=>                           i18n::translate('Birth of father\'s sibling'),
	'_BIRT_GCHI'=>                           i18n::translate('Birth of a grandchild'),
	'_BIRT_GGCH'=>                           i18n::translate('Birth of a great-grandchild'),
	'_BIRT_HSIB'=>                           i18n::translate('Birth of half-sibling'),
	'_BIRT_MSIB'=>                           i18n::translate('Birth of mother\'s sibling'),
	'_BIRT_NEPH'=>                           i18n::translate('Birth of a nephew or niece'),
	'_BIRT_SIBL'=>                           i18n::translate('Birth of sibling'),
	'_BRTM'=> /* I18N: gedcom tag _BRTM */   i18n::translate('Brit milah'),
	'_BRTM:DATE'=>                           i18n::translate('Date of brit milah'),
	'_BRTM:PLAC'=>                           i18n::translate('Place of brit milah'),
	'_BRTM:SOUR'=>                           i18n::translate('Source for brit milah'),
	'_BURI_CHIL'=>                           i18n::translate('Burial of a child'),
	'_BURI_COUS'=>                           i18n::translate('Burial of a first cousin'),
	'_BURI_FATH'=>                           i18n::translate('Burial of father'),
	'_BURI_FSIB'=>                           i18n::translate('Burial of father\'s sibling'),
	'_BURI_GCHI'=>                           i18n::translate('Burial of a grandchild'),
	'_BURI_GGCH'=>                           i18n::translate('Burial of a great-grandchild'),
	'_BURI_GGPA'=>                           i18n::translate('Burial of a great-grand-parent'),
	'_BURI_GPAR'=>                           i18n::translate('Burial of a grand-parent'),
	'_BURI_HSIB'=>                           i18n::translate('Burial of half-sibling'),
	'_BURI_MOTH'=>                           i18n::translate('Burial of mother'),
	'_BURI_MSIB'=>                           i18n::translate('Burial of mother\'s sibling'),
	'_BURI_NEPH'=>                           i18n::translate('Burial of a nephew or niece'),
	'_BURI_SIBL'=>                           i18n::translate('Burial of sibling'),
	'_BURI_SPOU'=>                           i18n::translate('Burial of spouse'),
	'_CHR_CHIL'=>                            i18n::translate('Christening of a child'),
	'_CHR_COUS'=>                            i18n::translate('Christening of a first cousin'),
	'_CHR_FSIB'=>                            i18n::translate('Christening of father\'s sibling'),
	'_CHR_GCHI'=>                            i18n::translate('Christening of a grandchild'),
	'_CHR_GGCH'=>                            i18n::translate('Christening of a great-grandchild'),
	'_CHR_HSIB'=>                            i18n::translate('Christening of half-sibling'),
	'_CHR_MSIB'=>                            i18n::translate('Christening of mother\'s sibling'),
	'_CHR_NEPH'=>                            i18n::translate('Christening of a nephew or niece'),
	'_CHR_SIBL'=>                            i18n::translate('Christening of sibling'),
	'_COML'=> /* I18N: gedcom tag _COML */   i18n::translate('Common Law Marriage'),
	'_CREM_CHIL'=>                           i18n::translate('Cremation of a child'),
	'_CREM_COUS'=>                           i18n::translate('Cremation of a first cousin'),
	'_CREM_FATH'=>                           i18n::translate('Cremation of father'),
	'_CREM_FSIB'=>                           i18n::translate('Cremation of father\'s sibling'),
	'_CREM_GCHI'=>                           i18n::translate('Cremation of a grandchild'),
	'_CREM_GGCH'=>                           i18n::translate('Cremation of a great-grandchild'),
	'_CREM_GGPA'=>                           i18n::translate('Cremation of a great-grand-parent'),
	'_CREM_GPAR'=>                           i18n::translate('Cremation of a grand-parent'),
	'_CREM_HSIB'=>                           i18n::translate('Cremation of half-sibling'),
	'_CREM_MOTH'=>                           i18n::translate('Cremation of mother'),
	'_CREM_MSIB'=>                           i18n::translate('Cremation of mother\'s sibling'),
	'_CREM_NEPH'=>                           i18n::translate('Cremation of a nephew or niece'),
	'_CREM_SIBL'=>                           i18n::translate('Cremation of sibling'),
	'_CREM_SPOU'=>                           i18n::translate('Cremation of spouse'),
	'_DBID'=> /* I18N: gedcom tag _DBID */   i18n::translate('Linked database ID'),
	'_DEAT_CHIL'=>                           i18n::translate('Death of a child'),
	'_DEAT_COUS'=>                           i18n::translate('Death of a first cousin'),
	'_DEAT_FATH'=>                           i18n::translate('Death of father'),
	'_DEAT_FSIB'=>                           i18n::translate('Death of father\'s sibling'),
	'_DEAT_GCHI'=>                           i18n::translate('Death of a grandchild'),
	'_DEAT_GGCH'=>                           i18n::translate('Death of a great-grandchild'),
	'_DEAT_GGPA'=>                           i18n::translate('Death of a great-grand-parent'),
	'_DEAT_GPAR'=>                           i18n::translate('Death of a grand-parent'),
	'_DEAT_HSIB'=>                           i18n::translate('Death of half-sibling'),
	'_DEAT_MOTH'=>                           i18n::translate('Death of mother'),
	'_DEAT_MSIB'=>                           i18n::translate('Death of mother\'s sibling'),
	'_DEAT_NEPH'=>                           i18n::translate('Death of a nephew or niece'),
	'_DEAT_SIBL'=>                           i18n::translate('Death of sibling'),
	'_DEAT_SPOU'=>                           i18n::translate('Death of spouse'),
	'_DEG'=> /* I18N: gedcom tag _DEG */     i18n::translate('Degree'),
	'_DETS'=> /* I18N: gedcom tag _DETS */   i18n::translate('Death of one spouse'),
	'_EMAIL'=> /* I18N: gedcom tag _EMAIL */ i18n::translate('Email address'),
	'_EYEC'=> /* I18N: gedcom tag _EYEC */   i18n::translate('Eye color'),
	'_FA1'=>                                 i18n::translate('Fact 1'),
	'_FA2'=>                                 i18n::translate('Fact 2'),
	'_FA3'=>                                 i18n::translate('Fact 3'),
	'_FA4'=>                                 i18n::translate('Fact 4'),
	'_FA5'=>                                 i18n::translate('Fact 5'),
	'_FA6'=>                                 i18n::translate('Fact 6'),
	'_FA7'=>                                 i18n::translate('Fact 7'),
	'_FA8'=>                                 i18n::translate('Fact 8'),
	'_FA9'=>                                 i18n::translate('Fact 9'),
	'_FA10'=>                                i18n::translate('Fact 10'),
	'_FA11'=>                                i18n::translate('Fact 11'),
	'_FA12'=>                                i18n::translate('Fact 12'),
	'_FA13'=>                                i18n::translate('Fact 13'),
	'_FAMC_EMIG'=>                           i18n::translate('Emigration of parents'),
	'_FAMC_RESI'=>                           i18n::translate('Residence of parents'),
	'_FNRL'=> /* I18N: gedcom tag _FNRL */   i18n::translate('Funeral'),
	'_FREL'=> /* I18N: gedcom tag _FREL */   i18n::translate('Relationship to father'),
	'_GEDF'=> /* I18N: gedcom tag _GEDF */   i18n::translate('GEDCOM file'),
	'_HAIR'=> /* I18N: gedcom tag _HAIR */   i18n::translate('Hair color'),
	'_HEB'=> /* I18N: gedcom tag _HEB */     i18n::translate('Hebrew'),
	'_HEIG'=> /* I18N: gedcom tag _HEIG */   i18n::translate('Height'),
	'_HNM'=> /* I18N: gedcom tag _HNM */     i18n::translate('Hebrew name'),
	'_HOL'=> /* I18N: gedcom tag _HOL */     i18n::translate('Holocaust'),
	'_INTE'=> /* I18N: gedcom tag _INTE */   i18n::translate('Interred'),
	'_MARB_CHIL'=>                           i18n::translate('Marriage Banns of a child'),
	'_MARB_COUS'=>                           i18n::translate('Marriage Banns of a first cousin'),
	'_MARB_FAMC'=>                           i18n::translate('Marriage Banns of parents'),
	'_MARB_FATH'=>                           i18n::translate('Marriage Banns of father'),
	'_MARB_FSIB'=>                           i18n::translate('Marriage Banns of father\'s sibling'),
	'_MARB_GCHI'=>                           i18n::translate('Marriage Banns of a grandchild'),
	'_MARB_GGCH'=>                           i18n::translate('Marriage Banns of a great-grandchild'),
	'_MARB_HSIB'=>                           i18n::translate('Marriage Banns of half-sibling'),
	'_MARB_MOTH'=>                           i18n::translate('Marriage Banns of mother'),
	'_MARB_MSIB'=>                           i18n::translate('Marriage Banns of mother\'s sibling'),
	'_MARB_NEPH'=>                           i18n::translate('Marriage Banns of a nephew or niece'),
	'_MARB_SIBL'=>                           i18n::translate('Marriage Banns of sibling'),
	'_MARI'=> /* I18N: gedcom tag _MARI */   i18n::translate('Marriage Intention'),
	'_MARNM'=> /* I18N: gedcom tag _MARNM */ i18n::translate('Married Name'),
	'_PRIM'=> /* I18N: gedcom tag _PRIM */   i18n::translate('Highlighted image'),
	'_MARNM_SURN'=>                          i18n::translate('Married Surname'),
	'_MARR_CHIL'=>                           i18n::translate('Marriage of a child'),
	'_MARR_COUS'=>                           i18n::translate('Marriage of a first cousin'),
	'_MARR_FAMC'=>                           i18n::translate('Marriage of parents'),
	'_MARR_FATH'=>                           i18n::translate('Marriage of father'),
	'_MARR_FSIB'=>                           i18n::translate('Marriage of father\'s sibling'),
	'_MARR_GCHI'=>                           i18n::translate('Marriage of a grandchild'),
	'_MARR_GGCH'=>                           i18n::translate('Marriage of a great-grandchild'),
	'_MARR_HSIB'=>                           i18n::translate('Marriage of half-sibling'),
	'_MARR_MOTH'=>                           i18n::translate('Marriage of mother'),
	'_MARR_MSIB'=>                           i18n::translate('Marriage of mother\'s sibling'),
	'_MARR_NEPH'=>                           i18n::translate('Marriage of a nephew or niece'),
	'_MARR_SIBL'=>                           i18n::translate('Marriage of sibling'),
	'_MBON'=> /* I18N: gedcom tag _MBON */   i18n::translate('Marriage bond'),
	'_MDCL'=> /* I18N: gedcom tag _MDCL */   i18n::translate('Medical'),
	'_MEDC'=> /* I18N: gedcom tag _MEDC */   i18n::translate('Medical condition'),
	'_MEND'=> /* I18N: gedcom tag _MEND */   i18n::translate('Marriage ending status'),
	'_MILI'=> /* I18N: gedcom tag _MILI */   i18n::translate('Military'),
	'_MILT'=> /* I18N: gedcom tag _MILT */   i18n::translate('Military service'),
	'_MREL'=> /* I18N: gedcom tag _MREL */   i18n::translate('Relationship to mother'),
	'_MSTAT'=> /* I18N: gedcom tag _MSTAT */ i18n::translate('Marriage beginning status'),
	'_NAME'=> /* I18N: gedcom tag _NAME */   i18n::translate('Mailing name'),
	'_NAMS'=> /* I18N: gedcom tag _NAMS */   i18n::translate('Namesake'),
	'_NLIV'=> /* I18N: gedcom tag _NLIV */   i18n::translate('Not living'),
	'_NMAR'=> /* I18N: gedcom tag _NMAR */   i18n::translate('Never married'),
	'_NMR'=> /* I18N: gedcom tag _NMR */     i18n::translate('Not married'),
	'_WT_USER'=>                             i18n::translate('by'),
	'_PRMN'=> /* I18N: gedcom tag _PRMN */   i18n::translate('Permanent number'),
	'_SCBK'=> /* I18N: gedcom tag _SCBK */   i18n::translate('Scrapbook'),
	'_SEPR'=> /* I18N: gedcom tag _SEPR */   i18n::translate('Separated'),
	'_SSHOW'=> /* I18N: gedcom tag _SSHOW */ i18n::translate('Slide show'),
	'_STAT'=> /* I18N: gedcom tag _STAT */   i18n::translate('Marriage status'),
	'_SUBQ'=> /* I18N: gedcom tag _SUBQ */   i18n::translate('Short version'),
	'_THUM'=> /* I18N: gedcom tag _THUM */   i18n::translate('Always use main image?'),
	'_TODO'=> /* I18N: gedcom tag _TODO */   i18n::translate('To-do item'),
	'_TYPE'=> /* I18N: gedcom tag _TYPE */   i18n::translate('Media type'),
	'_UID'=> /* I18N: gedcom tag _UID */     i18n::translate('Globally unique identifier'),
	'_URL'=> /* I18N: gedcom tag _URL */     i18n::translate('Web URL'),
	'_WEIG'=> /* I18N: gedcom tag _WEIG */   i18n::translate('Weight'),
	'_YART'=> /* I18N: gedcom tag _YART */   i18n::translate('Yahrzeit'),
	'__BRTM_CHIL'=>i18n::translate  (                     'Brit milah of a son'), // Brit milah applies only to males
	'__BRTM_COUS'=>i18n::translate  (                     'Brit milah of a first cousin'),
	'__BRTM_MSIB'=>i18n::translate_c('mother\'s brother', 'Brit milah of an uncle'),
	'__BRTM_FSIB'=>i18n::translate_c('father\'s brother', 'Brit milah of an uncle'),
	'__BRTM_GCHI'=>i18n::translate  (                     'Brit milah of a grandson'),
	'__BRTM_GCH1'=>i18n::translate_c('daughter\'s son',   'Brit milah of a grandson'),
	'__BRTM_GCH2'=>i18n::translate_c('son\'s son',        'Brit milah of a grandson'),
	'__BRTM_GGCH'=>i18n::translate  (                     'Brit milah of a great-grandson'),
	'__BRTM_HSIB'=>i18n::translate  (                     'Brit milah of a half-brother'),
	'__BRTM_NEPH'=>i18n::translate  (                     'Brit milah of a nephew'),
	'__BRTM_NEP1'=>i18n::translate_c('sister\'s son',     'Brit milah of a nephew'),
	'__BRTM_NEP2'=>i18n::translate_c('brother\'s son',    'Brit milah of a nephew'),
	'__BRTM_SIBL'=>i18n::translate  (                     'Brit milah of a brother'),
);

// Facts, as applied to Males.
// Use the context-sensitive translations when the word is the same in English
$FACTS_M=array(
	// close relatives facts
	'_ADOP_CHIL'=>i18n::translate  (        'Adoption of a son'),
	'_ADOP_COUS'=>i18n::translate_c('MALE', 'Adoption of a cousin'),
	'_ADOP_FSIB'=>i18n::translate  (        'Adoption of a father\'s brother'),
	'_ADOP_GCHI'=>i18n::translate  (        'Adoption of a grandson'),
	'_ADOP_GCH1'=>i18n::translate_c('daughter\'s son', 'Adoption of a grandson'),
	'_ADOP_GCH2'=>i18n::translate_c('son\'s son',      'Adoption of a grandson'),
	'_ADOP_GGCH'=>i18n::translate  (        'Adoption of a great-grandson'),
	'_ADOP_HSIB'=>i18n::translate  (        'Adoption of a half-brother'),
	'_ADOP_MSIB'=>i18n::translate  (        'Adoption of a mother\'s brother'),
	'_ADOP_NEPH'=>i18n::translate  (        'Adoption of a nephew'),
	'_ADOP_NEP1'=>i18n::translate_c('sister\'s son',  'Adoption of a nephew'),
	'_ADOP_NEP2'=>i18n::translate_c('brother\'s son', 'Adoption of a nephew'),
	'_ADOP_SIBL'=>i18n::translate  (        'Adoption of a brother'),
	'_BAPM_CHIL'=>i18n::translate  (        'Baptism of a son'),
	'_BAPM_COUS'=>i18n::translate_c('MALE', 'Baptism of a cousin'),
	'_BAPM_FSIB'=>i18n::translate  (        'Baptism of a father\'s brother'),
	'_BAPM_GCHI'=>i18n::translate  (        'Baptism of a grandson'),
	'_BAPM_GCH1'=>i18n::translate_c('daughter\'s son', 'Baptism of a grandson'),
	'_BAPM_GCH2'=>i18n::translate_c('son\'s son',      'Baptism of a grandson'),
	'_BAPM_GGCH'=>i18n::translate  (        'Baptism of a great-grandson'),
	'_BAPM_HSIB'=>i18n::translate  (        'Baptism of a half-brother'),
	'_BAPM_MSIB'=>i18n::translate  (        'Baptism of a mother\'s brother'),
	'_BAPM_NEPH'=>i18n::translate  (        'Baptism of a nephew'),
	'_BAPM_NEP1'=>i18n::translate_c('sister\'s son',  'Baptism of a nephew'),
	'_BAPM_NEP2'=>i18n::translate_c('brother\'s son', 'Baptism of a nephew'),
	'_BAPM_SIBL'=>i18n::translate  (        'Baptism of a brother'),
	'_BIRT_CHIL'=>i18n::translate  (        'Birth of a son'),
	'_BIRT_COUS'=>i18n::translate_c('MALE', 'Birth of a cousin'),
	'_BIRT_FSIB'=>i18n::translate  (        'Birth of a father\'s brother'),
	'_BIRT_GCHI'=>i18n::translate  (        'Birth of a grandson'),
	'_BIRT_GCH1'=>i18n::translate_c('daughter\'s son', 'Birth of a grandson'),
	'_BIRT_GCH2'=>i18n::translate_c('son\'s son',      'Birth of a grandson'),
	'_BIRT_GGCH'=>i18n::translate  (        'Birth of a great-grandson'),
	'_BIRT_HSIB'=>i18n::translate  (        'Birth of a half-brother'),
	'_BIRT_MSIB'=>i18n::translate  (        'Birth of a mother\'s brother'),
	'_BIRT_NEPH'=>i18n::translate  (        'Birth of a nephew'),
	'_BIRT_NEP1'=>i18n::translate_c('sister\'s son',  'Birth of a nephew'),
	'_BIRT_NEP2'=>i18n::translate_c('brother\'s son', 'Birth of a nephew'),
	'_BIRT_SIBL'=>i18n::translate  (        'Birth of a brother'),
	'_BURI_CHIL'=>i18n::translate  (        'Burial of a son'),
	'_BURI_COUS'=>i18n::translate_c('MALE', 'Burial of a cousin'),
	'_BURI_FSIB'=>i18n::translate  (        'Burial of a father\'s brother'),
	'_BURI_GCHI'=>i18n::translate  (        'Burial of a grandson'),
	'_BURI_GCH1'=>i18n::translate_c('daughter\'s son', 'Burial of a grandson'),
	'_BURI_GCH2'=>i18n::translate_c('son\'s son',      'Burial of a grandson'),
	'_BURI_GGCH'=>i18n::translate  (        'Burial of a great-grandson'),
	'_BURI_GGPA'=>i18n::translate  (        'Burial of a great-grandfather'),
	'_BURI_GPAR'=>i18n::translate  (        'Burial of a grandfather'),
	'_BURI_GPA1'=>i18n::translate  (        'Burial of a maternal grandfather'),
	'_BURI_GPA2'=>i18n::translate  (        'Burial of a paternal grandfather'),
	'_BURI_HSIB'=>i18n::translate  (        'Burial of a half-brother'),
	'_BURI_MSIB'=>i18n::translate  (        'Burial of a mother\'s brother'),
	'_BURI_NEPH'=>i18n::translate  (        'Burial of a nephew'),
	'_BURI_NEP1'=>i18n::translate_c('sister\'s son',  'Burial of a nephew'),
	'_BURI_NEP2'=>i18n::translate_c('brother\'s son', 'Burial of a nephew'),
	'_BURI_SIBL'=>i18n::translate  (        'Burial of a brother'),
	'_BURI_SPOU'=>i18n::translate  (        'Burial of a husband'),
	'_CHR_CHIL'=>i18n::translate   (        'Christening of a son'),
	'_CHR_COUS'=>i18n::translate_c ('MALE', 'Christening of a cousin'),
	'_CHR_FSIB'=>i18n::translate   (        'Christening of a father\'s brother'),
	'_CHR_GCHI'=>i18n::translate   (        'Christening of a grandson'),
	'_CHR_GCH1'=>i18n::translate_c ('daughter\'s son', 'Christening of a grandson'),
	'_CHR_GCH2'=>i18n::translate_c ('son\'s son',      'Christening of a grandson'),
	'_CHR_GGCH'=>i18n::translate   (        'Christening of a great-grandson'),
	'_CHR_HSIB'=>i18n::translate   (        'Christening of a half-brother'),
	'_CHR_MSIB'=>i18n::translate   (        'Christening of a mother\'s brother'),
	'_CHR_NEPH'=>i18n::translate   (        'Christening of a nephew'),
	'_CHR_NEP1'=>i18n::translate_c ('sister\'s son',  'Christening of a nephew'),
	'_CHR_NEP2'=>i18n::translate_c ('brother\'s son', 'Christening of a nephew'),
	'_CHR_SIBL'=>i18n::translate   (        'Christening of a brother'),
	'_CREM_CHIL'=>i18n::translate  (        'Cremation of a son'),
	'_CREM_COUS'=>i18n::translate_c('MALE', 'Cremation of a cousin'),
	'_CREM_FSIB'=>i18n::translate  (        'Cremation of a father\'s brother'),
	'_CREM_GCHI'=>i18n::translate  (        'Cremation of a grandson'),
	'_CREM_GCH1'=>i18n::translate_c('daughter\'s son', 'Cremation of a grandson'),
	'_CREM_GCH2'=>i18n::translate_c('son\'s son',      'Cremation of a grandson'),
	'_CREM_GGCH'=>i18n::translate  (        'Cremation of a great-grandson'),
	'_CREM_GGPA'=>i18n::translate  (        'Cremation of a great-grandfather'),
	'_CREM_GPAR'=>i18n::translate  (        'Cremation of a grandfather'),
	'_CREM_GPA1'=>i18n::translate  (        'Cremation of a maternal grandfather'),
	'_CREM_GPA2'=>i18n::translate  (        'Cremation of a paternal grandfather'),
	'_CREM_HSIB'=>i18n::translate  (        'Cremation of a half-brother'),
	'_CREM_MSIB'=>i18n::translate  (        'Cremation of a mother\'s brother'),
	'_CREM_NEPH'=>i18n::translate  (        'Cremation of a nephew'),
	'_CREM_NEP1'=>i18n::translate_c('sister\'s son',  'Cremation of a nephew'),
	'_CREM_NEP2'=>i18n::translate_c('brother\'s son', 'Cremation of a nephew'),
	'_CREM_SIBL'=>i18n::translate  (        'Cremation of a brother'),
	'_CREM_SPOU'=>i18n::translate  (        'Cremation of a husband'),
	'_DEAT_CHIL'=>i18n::translate  (        'Death of a son'),
	'_DEAT_COUS'=>i18n::translate_c('MALE', 'Death of a cousin'),
	'_DEAT_FSIB'=>i18n::translate  (        'Death of a father\'s brother'),
	'_DEAT_GCHI'=>i18n::translate  (        'Death of a grandson'),
	'_DEAT_GCH1'=>i18n::translate_c('daughter\'s son', 'Death of a grandson'),
	'_DEAT_GCH2'=>i18n::translate_c('son\'s son',      'Death of a grandson'),
	'_DEAT_GGCH'=>i18n::translate  (        'Death of a great-grandson'),
	'_DEAT_GGPA'=>i18n::translate  (        'Death of a great-grandfather'),
	'_DEAT_GPAR'=>i18n::translate  (        'Death of a grandfather'),
	'_DEAT_GPA1'=>i18n::translate  (        'Death of a maternal grandfather'),
	'_DEAT_GPA2'=>i18n::translate  (        'Death of a paternal grandfather'),
	'_DEAT_HSIB'=>i18n::translate  (        'Death of a half-brother'),
	'_DEAT_MSIB'=>i18n::translate  (        'Death of a mother\'s brother'),
	'_DEAT_NEPH'=>i18n::translate  (        'Death of a nephew'),
	'_DEAT_NEP1'=>i18n::translate_c('sister\'s son',  'Death of a nephew'),
	'_DEAT_NEP2'=>i18n::translate_c('brother\'s son', 'Death of a nephew'),
	'_DEAT_SIBL'=>i18n::translate  (        'Death of a brother'),
	'_DEAT_SPOU'=>i18n::translate  (        'Death of a husband'),
	'_MARB_CHIL'=>i18n::translate  (        'Marriage Banns of a son'),
	'_MARB_COUS'=>i18n::translate_c('MALE', 'Marriage Banns of a cousin'),
	'_MARB_FSIB'=>i18n::translate  (        'Marriage Banns of a father\'s brother'),
	'_MARB_GCHI'=>i18n::translate  (        'Marriage Banns of a grandson'),
	'_MARB_GCH1'=>i18n::translate_c('daughter\'s son', 'Marriage banns of a grandson'),
	'_MARB_GCH2'=>i18n::translate_c('son\'s son',      'Marriage banns of a grandson'),
	'_MARB_GGCH'=>i18n::translate  (        'Marriage Banns of a great-grandson'),
	'_MARB_HSIB'=>i18n::translate  (        'Marriage Banns of a half-brother'),
	'_MARB_MSIB'=>i18n::translate  (        'Marriage Banns of a mother\'s brother'),
	'_MARB_NEPH'=>i18n::translate  (        'Marriage Banns of a nephew'),
	'_MARB_NEP1'=>i18n::translate_c('sister\'s son',  'Marriage Banns of a nephew'),
	'_MARB_NEP2'=>i18n::translate_c('brother\'s son', 'Marriage Banns of a nephew'),
	'_MARB_SIBL'=>i18n::translate  (        'Marriage Banns of a brother'),
	'_MARR_CHIL'=>i18n::translate  (        'Marriage of a son'),
	'_MARR_COUS'=>i18n::translate_c('MALE', 'Marriage of a cousin'),
	'_MARR_FSIB'=>i18n::translate  (        'Marriage of a father\'s brother'),
	'_MARR_GCHI'=>i18n::translate  (        'Marriage of a grandson'),
	'_MARR_GCH1'=>i18n::translate_c('daughter\'s son', 'Marriage of a grandson'),
	'_MARR_GCH2'=>i18n::translate_c('son\'s son',      'Marriage of a grandson'),
	'_MARR_GGCH'=>i18n::translate  (        'Marriage of a great-grandson'),
	'_MARR_HSIB'=>i18n::translate  (        'Marriage of a half-brother'),
	'_MARR_MSIB'=>i18n::translate  (        'Marriage of a mother\'s brother'),
	'_MARR_NEPH'=>i18n::translate  (        'Marriage of a nephew'),
	'_MARR_NEP1'=>i18n::translate_c('sister\'s son',  'Marriage of a nephew'),
	'_MARR_NEP2'=>i18n::translate_c('brother\'s son', 'Marriage of a nephew'),
	'_MARR_SIBL'=>i18n::translate  (        'Marriage of a brother'),
	// this person facts
	'_ADPF'     =>i18n::translate_c('MALE', 'Adopted by father'),
	'_ADPM'     =>i18n::translate_c('MALE', 'Adopted by mother'),
	'_AKA'      =>i18n::translate_c('MALE', 'Also known as'),
	'_AKAN'     =>i18n::translate_c('MALE', 'Also known as'),
	'_INTE'     =>i18n::translate_c('MALE', 'Interred'),
	// one of spouse facts
	'_NMAR'     =>i18n::translate_c('MALE', 'Never married'),
	'_NMR'      =>i18n::translate_c('MALE', 'Not married'),
);

// Facts, as applied to Females
$FACTS_F=array(
	// close relatives facts
	'_ADOP_CHIL'=>i18n::translate  (          'Adoption of a daughter'),
	'_ADOP_COUS'=>i18n::translate_c('FEMALE', 'Adoption of a cousin'),
	'_ADOP_FSIB'=>i18n::translate  (          'Adoption of a father\'s sister'),
	'_ADOP_GCHI'=>i18n::translate  (          'Adoption of a granddaughter'),
	'_ADOP_GCH1'=>i18n::translate_c('daughter\'s daughter','Adoption of a granddaughter'),
	'_ADOP_GCH2'=>i18n::translate_c('son\'s daughter',     'Adoption of a granddaughter'),
	'_ADOP_GGCH'=>i18n::translate  (          'Adoption of a great-granddaughter'),
	'_ADOP_HSIB'=>i18n::translate  (          'Adoption of a half-sister'),
	'_ADOP_MSIB'=>i18n::translate  (          'Adoption of a mother\'s sister'),
	'_ADOP_NEPH'=>i18n::translate  (          'Adoption of a niece'),
	'_ADOP_NIE1'=>i18n::translate_c('sister\'s daughter',  'Adoption of a niece'),
	'_ADOP_NIE2'=>i18n::translate_c('brother\'s daughter', 'Adoption of a niece'),
	'_ADOP_SIBL'=>i18n::translate  (          'Adoption of a sister'),
	'_BAPM_CHIL'=>i18n::translate  (          'Baptism of a daughter'),
	'_BAPM_COUS'=>i18n::translate_c('FEMALE', 'Baptism of a cousin'),
	'_BAPM_FSIB'=>i18n::translate  (          'Baptism of a father\'s sister'),
	'_BAPM_GCHI'=>i18n::translate  (          'Baptism of a granddaughter'),
	'_BAPM_GCH1'=>i18n::translate_c('daughter\'s daughter','Baptism of a granddaughter'),
	'_BAPM_GCH2'=>i18n::translate_c('son\'s daughter',     'Baptism of a granddaughter'),
	'_BAPM_GGCH'=>i18n::translate  (          'Baptism of a great-granddaughter'),
	'_BAPM_HSIB'=>i18n::translate  (          'Baptism of a half-sister'),
	'_BAPM_MSIB'=>i18n::translate  (          'Baptism of a mother\'s sister'),
	'_BAPM_NEPH'=>i18n::translate  (          'Baptism of a niece'),
	'_BAPM_NIE1'=>i18n::translate_c('sister\'s daughter',  'Baptism of a niece'),
	'_BAPM_NIE2'=>i18n::translate_c('brother\'s daughter', 'Baptism of a niece'),
	'_BAPM_SIBL'=>i18n::translate  (          'Baptism of sister'),
	'_BIRT_CHIL'=>i18n::translate  (          'Birth of a daughter'),
	'_BIRT_COUS'=>i18n::translate_c('FEMALE', 'Birth of a cousin'),
	'_BIRT_FSIB'=>i18n::translate  (          'Birth of a father\'s sister'),
	'_BIRT_GCHI'=>i18n::translate  (          'Birth of a granddaughter'),
	'_BIRT_GCH1'=>i18n::translate_c('daughter\'s daughter','Birth of a granddaughter'),
	'_BIRT_GCH2'=>i18n::translate_c('son\'s daughter',     'Birth of a granddaughter'),
	'_BIRT_GGCH'=>i18n::translate  (          'Birth of a great-granddaughter'),
	'_BIRT_HSIB'=>i18n::translate  (          'Birth of a half-sister'),
	'_BIRT_MSIB'=>i18n::translate  (          'Birth of a mother\'s sister'),
	'_BIRT_NEPH'=>i18n::translate  (          'Birth of a niece'),
	'_BIRT_NIE1'=>i18n::translate_c('sister\'s daughter',  'Birth of a niece'),
	'_BIRT_NIE2'=>i18n::translate_c('brother\'s daughter', 'Birth of a niece'),
	'_BIRT_SIBL'=>i18n::translate  (          'Birth of a sister'),
	'_BURI_CHIL'=>i18n::translate  (          'Burial of a daughter'),
	'_BURI_COUS'=>i18n::translate_c('FEMALE', 'Burial of a cousin'),
	'_BURI_FSIB'=>i18n::translate  (          'Burial of a father\'s sister'),
	'_BURI_GCHI'=>i18n::translate  (          'Burial of a granddaughter'),
	'_BURI_GCH1'=>i18n::translate_c('daughter\'s daughter','Burial of a granddaughter'),
	'_BURI_GCH2'=>i18n::translate_c('son\'s daughter',     'Burial of a granddaughter'),
	'_BURI_GGCH'=>i18n::translate  (          'Burial of a great-granddaughter'),
	'_BURI_GGPA'=>i18n::translate  (          'Burial of a great-grandmother'),
	'_BURI_GPAR'=>i18n::translate  (          'Burial of a grandmother'),
	'_BURI_GPA1'=>i18n::translate  (          'Burial of a maternal grandmother'),
	'_BURI_GPA2'=>i18n::translate  (          'Burial of a paternal grandmother'),
	'_BURI_HSIB'=>i18n::translate  (          'Burial of a half-sister'),
	'_BURI_MSIB'=>i18n::translate  (          'Burial of a mother\'s sister'),
	'_BURI_NEPH'=>i18n::translate  (          'Burial of a niece'),
	'_BURI_NIE1'=>i18n::translate_c('sister\'s daughter',  'Burial of a niece'),
	'_BURI_NIE2'=>i18n::translate_c('brother\'s daughter', 'Burial of a niece'),
	'_BURI_SIBL'=>i18n::translate  (          'Burial of a sister'),
	'_BURI_SPOU'=>i18n::translate  (          'Burial of a wife'),
	'_CHR_CHIL'=>i18n::translate   (          'Christening of a daughter'),
	'_CHR_COUS'=>i18n::translate_c ('FEMALE', 'Christening of a cousin'),
	'_CHR_FSIB'=>i18n::translate   (          'Christening of a father\'s sister'),
	'_CHR_GCHI'=>i18n::translate   (          'Christening of a granddaughter'),
	'_CHR_GCH1'=>i18n::translate_c ('daughter\'s daughter','Christening of a granddaughter'),
	'_CHR_GCH2'=>i18n::translate_c ('son\'s daughter',     'Christening of a granddaughter'),
	'_CHR_GGCH'=>i18n::translate   (          'Christening of a great-granddaughter'),
	'_CHR_HSIB'=>i18n::translate   (          'Christening of a half-sister'),
	'_CHR_MSIB'=>i18n::translate   (          'Christening of a mother\'s sister'),
	'_CHR_NEPH'=>i18n::translate   (          'Christening of a niece'),
	'_CHR_NIE1'=>i18n::translate_c ('sister\'s daughter',  'Christening of a niece'),
	'_CHR_NIE2'=>i18n::translate_c ('brother\'s daughter', 'Christening of a niece'),
	'_CHR_SIBL'=>i18n::translate   (          'Christening of a sister'),
	'_CREM_CHIL'=>i18n::translate  (          'Cremation of a daughter'),
	'_CREM_COUS'=>i18n::translate_c('FEMALE', 'Cremation of a cousin'),
	'_CREM_FSIB'=>i18n::translate  (          'Cremation of a father\'s sister'),
	'_CREM_GCHI'=>i18n::translate  (          'Cremation of a granddaughter'),
	'_CREM_GCH1'=>i18n::translate_c('daughter\'s daughter','Cremation of a granddaughter'),
	'_CREM_GCH2'=>i18n::translate_c('son\'s daughter',     'Cremation of a granddaughter'),
	'_CREM_GGCH'=>i18n::translate  (          'Cremation of a great-granddaughter'),
	'_CREM_GGPA'=>i18n::translate  (          'Cremation of a great-grandmother'),
	'_CREM_GPAR'=>i18n::translate  (          'Cremation of a grandmother'),
	'_CREM_GPA1'=>i18n::translate  (          'Cremation of a maternal grandmother'),
	'_CREM_GPA2'=>i18n::translate  (          'Cremation of a paternal grandmother'),
	'_CREM_HSIB'=>i18n::translate  (          'Cremation of a half-sister'),
	'_CREM_MSIB'=>i18n::translate  (          'Cremation of a mother\'s sister'),
	'_CREM_NEPH'=>i18n::translate  (          'Cremation of a niece'),
	'_CREM_NIE1'=>i18n::translate_c('sister\'s daughter',  'Cremation of a niece'),
	'_CREM_NIE2'=>i18n::translate_c('brother\'s daughter', 'Cremation of a niece'),
	'_CREM_SIBL'=>i18n::translate  (          'Cremation of a sister'),
	'_CREM_SPOU'=>i18n::translate  (          'Cremation of a wife'),
	'_DEAT_CHIL'=>i18n::translate  (          'Death of a daughter'),
	'_DEAT_COUS'=>i18n::translate_c('FEMALE', 'Death of a cousin'),
	'_DEAT_FSIB'=>i18n::translate  (          'Death of a father\'s sister'),
	'_DEAT_GCHI'=>i18n::translate  (          'Death of a granddaughter'),
	'_DEAT_GCH1'=>i18n::translate_c('daughter\'s daughter','Death of a granddaughter'),
	'_DEAT_GCH2'=>i18n::translate_c('son\'s daughter',     'Death of a granddaughter'),
	'_DEAT_GGCH'=>i18n::translate  (          'Death of a great-granddaughter'),
	'_DEAT_GGPA'=>i18n::translate  (          'Death of a great-grandmother'),
	'_DEAT_GPAR'=>i18n::translate  (          'Death of a grandmother'),
	'_DEAT_GPA1'=>i18n::translate  (          'Death of a maternal grandmother'),
	'_DEAT_GPA2'=>i18n::translate  (          'Death of a maternal grandmother'),
	'_DEAT_HSIB'=>i18n::translate  (          'Death of a half-sister'),
	'_DEAT_MSIB'=>i18n::translate  (          'Death of a mother\'s sister'),
	'_DEAT_NEPH'=>i18n::translate  (          'Death of a niece'),
	'_DEAT_NIE1'=>i18n::translate_c('sister\'s daughter',  'Death of a niece'),
	'_DEAT_NIE2'=>i18n::translate_c('brother\'s daughter', 'Death of a niece'),
	'_DEAT_SIBL'=>i18n::translate  (          'Death of a sister'),
	'_DEAT_SPOU'=>i18n::translate  (          'Death of a wife'),
	'_MARB_CHIL'=>i18n::translate  (          'Marriage Banns of a daughter'),
	'_MARB_COUS'=>i18n::translate_c('FEMALE', 'Marriage Banns of a cousin'),
	'_MARB_FSIB'=>i18n::translate  (          'Marriage Banns of father\'s sister'),
	'_MARB_GCHI'=>i18n::translate  (          'Marriage Banns of a granddaughter'),
	'_MARB_GCH1'=>i18n::translate_c('daughter\'s daughter','Marriage banns of a granddaughter'),
	'_MARB_GCH2'=>i18n::translate_c('son\'s daughter',     'Marriage banns of a granddaughter'),
	'_MARB_GGCH'=>i18n::translate  (          'Marriage Banns of a great-granddaughter'),
	'_MARB_HSIB'=>i18n::translate  (          'Marriage Banns of half-sister'),
	'_MARB_MSIB'=>i18n::translate  (          'Marriage Banns of mother\'s sister'),
	'_MARB_NEPH'=>i18n::translate  (          'Marriage Banns of a niece'),
	'_MARB_NIE1'=>i18n::translate_c('sister\'s daughter',  'Marriage Banns of a niece'),
	'_MARB_NIE2'=>i18n::translate_c('brother\'s daughter', 'Marriage Banns of a niece'),
	'_MARB_SIBL'=>i18n::translate  (          'Marriage Banns of sister'),
	'_MARR_CHIL'=>i18n::translate  (          'Marriage of a daughter'),
	'_MARR_COUS'=>i18n::translate_c('FEMALE', 'Marriage of a cousin'),
	'_MARR_FSIB'=>i18n::translate  (          'Marriage of a father\'s sister'),
	'_MARR_GCHI'=>i18n::translate  (          'Marriage of a granddaughter'),
	'_MARR_GCH1'=>i18n::translate_c('daughter\'s daughter','Marriage of a granddaughter'),
	'_MARR_GCH2'=>i18n::translate_c('son\'s daughter',     'Marriage of a granddaughter'),
	'_MARR_GGCH'=>i18n::translate  (          'Marriage of a great-granddaughter'),
	'_MARR_HSIB'=>i18n::translate  (          'Marriage of a half-sister'),
	'_MARR_MSIB'=>i18n::translate  (          'Marriage of a mother\'s sister'),
	'_MARR_NEPH'=>i18n::translate  (          'Marriage of a niece'),
	'_MARR_NIE1'=>i18n::translate_c('sister\'s daughter',  'Marriage of a niece'),
	'_MARR_NIE2'=>i18n::translate_c('brother\'s daughter', 'Marriage of a niece'),
	'_MARR_SIBL'=>i18n::translate  (          'Marriage of a sister'),
	// this person facts
	'_ADPF'     =>i18n::translate_c('FEMALE', 'Adopted by father'),
	'_ADPM'     =>i18n::translate_c('FEMALE', 'Adopted by mother'),
	'_AKA'      =>i18n::translate_c('FEMALE', 'Also known as'),
	'_AKAN'     =>i18n::translate_c('FEMALE', 'Also known as'),
	'_INTE'     =>i18n::translate_c('FEMALE', 'Interred'),
	// one of spouse facts
	'_NMAR'     =>i18n::translate_c('FEMALE', 'Never married'),
	'_NMR'      =>i18n::translate_c('FEMALE', 'Not married'),
);

// Facts, as applied to Repositories
$FACTS_REPO=array(
	'NAME'      =>i18n::translate_c('Repository', 'Name')
);

// Create a label for a fact type.
function translate_fact($fact, $person=null) {
	global $FACTS, $FACTS_M, $FACTS_F, $FACTS_REPO;

	if ($person instanceof Person && $person->getSex()=='M' && array_key_exists($fact, $FACTS_M)) {
		return $FACTS_M[$fact];
	}
	if ($person instanceof Person && $person->getSex()=='F' && array_key_exists($fact, $FACTS_F)) {
		return $FACTS_F[$fact];
	}
	if ($person instanceof Repository && array_key_exists($fact, $FACTS_REPO)) {
		return $FACTS_REPO[$fact];
	}
	if (array_key_exists($fact, $FACTS)) {
		return $FACTS[$fact];
	}
	// If no specialisation exists (e.g. DEAT:CAUS), then look for the general (CAUS)
	if (strpos($fact, ':')) {
		list(, $fact)=explode(':', $fact, 2);
		return translate_fact($fact, $person);
	}
	// Still no translation? Highlight this as an error
	return '<span class="error" title="'.i18n::translate('Unrecognized GEDCOM Code').'">'.$fact.'</span>';
}

function abbreviate_fact($fact) {
	switch ($fact) {
	case 'BIRT':  return i18n::translate_c('Abbreviation for birth',            'b.');
	case 'MARR':  return i18n::translate_c('Abbreviation for marriage',         'm.');
	case 'DEAT':  return i18n::translate_c('Abbreviation for death',            'd.');
	case 'PHON':  return i18n::translate_c('Abbreviation for telephone number', 't.');
	case 'FAX':   return i18n::translate_c('Abbreviation for fax number',       'f.');
	case 'EMAIL': return i18n::translate_c('Abbreviation for email address',    'e.');
	default:      return utf8_substr(translate_fact($fact), 0, 1).'.'; // Just use the first letter of the full fact
	}
}

// Create a label for a relationship type.
function translate_rela($rela, $sex='') {
	global $RELA_CODES, $RELA_CODES_M, $RELA_CODES_F;

	if ($sex=='M' && array_key_exists($rela, $RELA_CODES_M)) {
		return $RELA_CODES_M[$rela];
	}
	if ($sex=='F' && array_key_exists($rela, $RELA_CODES_F)) {
		return $RELA_CODES_F[$rela];
	}
	if (array_key_exists($rela, $RELA_CODES)) {
		return $RELA_CODES[$rela];
	}
	// Still no translation? Return original relationship name
	return $rela;
}
