/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;

class MessageFactory {
    private MessageFactory() {
    }

    protected static Application getApplication() {
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            return FacesContext.getCurrentInstance().getApplication();
        }
        ApplicationFactory afactory = (ApplicationFactory)FactoryFinder.getFactory("javax.faces.application.ApplicationFactory");
        return afactory.getApplication();
    }

    protected static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    static FacesMessage getMessage(String messageId, Object[] params) {
        Locale locale = null;
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null && context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        return MessageFactory.getMessage(locale, messageId, params);
    }

    static FacesMessage getMessage(FacesContext context, String messageId) {
        return MessageFactory.getMessage(context, messageId, null);
    }

    static String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        StringBuffer b = new StringBuffer(100);
        MessageFormat mf = new MessageFormat(msgtext);
        if (locale != null) {
            mf.setLocale(locale);
            b.append(mf.format(params));
            localizedStr = b.toString();
        }
        return localizedStr;
    }

    static FacesMessage getMessage(Locale locale, String messageId, Object[] params) {
        Object result = null;
        String summary = null;
        String detail = null;
        String bundleName = null;
        ResourceBundle bundle = null;
        bundleName = MessageFactory.getApplication().getMessageBundle();
        if (null != bundleName && null != (bundle = ResourceBundle.getBundle(bundleName, locale, MessageFactory.getCurrentLoader(bundleName)))) {
            try {
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (null == summary) {
            bundle = ResourceBundle.getBundle("javax.faces.Messages", locale, MessageFactory.getCurrentLoader(bundleName));
            if (null == bundle) {
                throw new NullPointerException();
            }
            try {
                summary = bundle.getString(messageId);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (null == summary) {
            return null;
        }
        if (null == summary || null == bundle) {
            throw new NullPointerException();
        }
        summary = MessageFactory.substituteParams(locale, summary, params);
        try {
            detail = MessageFactory.substituteParams(locale, bundle.getString(messageId + "_detail"), params);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return new FacesMessage(summary, detail);
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object param0) {
        return MessageFactory.getMessage(context, messageId, new Object[]{param0});
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object[] params) {
        if (context == null || messageId == null) {
            throw new NullPointerException("One or more parameters could be null");
        }
        Locale locale = null;
        locale = context != null && context.getViewRoot() != null ? context.getViewRoot().getLocale() : Locale.getDefault();
        if (null == locale) {
            throw new NullPointerException();
        }
        FacesMessage message = MessageFactory.getMessage(locale, messageId, params);
        if (message != null) {
            return message;
        }
        locale = Locale.getDefault();
        return MessageFactory.getMessage(locale, messageId, params);
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object param0, Object param1) {
        return MessageFactory.getMessage(context, messageId, new Object[]{param0, param1});
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object param0, Object param1, Object param2) {
        return MessageFactory.getMessage(context, messageId, new Object[]{param0, param1, param2});
    }

    static FacesMessage getMessage(FacesContext context, String messageId, Object param0, Object param1, Object param2, Object param3) {
        return MessageFactory.getMessage(context, messageId, new Object[]{param0, param1, param2, param3});
    }
}

