/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.webapp;

import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

public class ConverterTag
extends TagSupport {
    private String converterId = null;

    public int doStartTag() throws JspException {
        UIComponentTag tag = UIComponentTag.getParentUIComponentTag(this.pageContext);
        if (tag == null) {
            throw new JspException("Not nested in a UIComponentTag");
        }
        if (!tag.getCreated()) {
            return 0;
        }
        Converter converter = this.createConverter();
        ValueHolder vh = (ValueHolder)((Object)tag.getComponentInstance());
        vh.setConverter(converter);
        Object localValue = vh.getLocalValue();
        if (localValue instanceof String) {
            try {
                FacesContext context = FacesContext.getCurrentInstance();
                localValue = converter.getAsObject(context, (UIComponent)((Object)vh), (String)localValue);
                vh.setValue(localValue);
            }
            catch (ConverterException ce) {
                // empty catch block
            }
        }
        return 0;
    }

    public void release() {
        this.converterId = null;
    }

    public void setConverterId(String converterId) {
        this.converterId = converterId;
    }

    protected Converter createConverter() throws JspException {
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            String converterIdVal = this.converterId;
            if (UIComponentTag.isValueReference(this.converterId)) {
                ValueBinding vb = context.getApplication().createValueBinding(this.converterId);
                converterIdVal = (String)vb.getValue(context);
            }
            return context.getApplication().createConverter(converterIdVal);
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
    }
}

